/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.ClientRegionFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.security.templates.UserPasswordAuthInit;
import org.apache.geode.test.junit.rules.serializable.SerializableExternalResource;

public class ClientCacheRule
extends SerializableExternalResource {
    private ClientCache cache;
    private ClientCacheFactory cacheFactory;
    private final List<Consumer<ClientCacheFactory>> cacheSetups;
    private final Properties properties = new Properties();
    private boolean autoCreate;

    public ClientCacheRule() {
        this.properties.setProperty("mcast-port", "0");
        this.properties.setProperty("locators", "");
        this.cacheSetups = new ArrayList<Consumer<ClientCacheFactory>>();
    }

    public ClientCacheRule withProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public ClientCacheRule withCredential(String username, String password) {
        this.properties.setProperty("security-username", username);
        this.properties.setProperty("security-password", password);
        this.properties.setProperty("security-client-auth-init", UserPasswordAuthInit.class.getName());
        return this;
    }

    public ClientCacheRule withProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public ClientCacheRule withCacheSetup(Consumer<ClientCacheFactory> setup) {
        this.cacheSetups.add(setup);
        return this;
    }

    public ClientCacheRule withPoolSubscription(boolean enabled) {
        this.withCacheSetup(cf -> cf.setPoolSubscriptionEnabled(enabled));
        return this;
    }

    public ClientCacheRule withServerConnection(int ... serverPorts) {
        this.withCacheSetup(cf -> {
            for (int serverPort : serverPorts) {
                cf.addPoolServer("localhost", serverPort);
            }
        });
        return this;
    }

    public ClientCacheRule withLocatorConnection(int ... serverPorts) {
        this.withCacheSetup(cf -> {
            for (int serverPort : serverPorts) {
                cf.addPoolLocator("localhost", serverPort);
            }
        });
        return this;
    }

    public ClientCacheRule withMultiUser(boolean enabled) {
        this.withCacheSetup(cf -> cf.setPoolMultiuserAuthentication(enabled));
        return this;
    }

    public ClientCacheRule withAutoCreate() {
        this.autoCreate = true;
        return this;
    }

    public ClientCache createCache() throws Exception {
        this.cacheFactory = new ClientCacheFactory(this.properties);
        this.cacheSetups.stream().forEach(setup -> setup.accept(this.cacheFactory));
        this.cache = this.cacheFactory.create();
        return this.cache;
    }

    public <K, V> Region<K, V> createProxyRegion(String regionPath) {
        ClientRegionFactory regionFactory = this.cache.createClientRegionFactory(ClientRegionShortcut.PROXY);
        return regionFactory.create(regionPath);
    }

    public RegionService createAuthenticatedView(String username, String password) {
        Properties properties = new Properties();
        properties.setProperty("security-username", username);
        properties.setProperty("security-password", password);
        properties.setProperty("security-client-auth-init", UserPasswordAuthInit.class.getName());
        return this.cache.createAuthenticatedView(properties);
    }

    public void before() throws Exception {
        if (this.autoCreate) {
            this.createCache();
        }
    }

    public void after() {
        try {
            if (this.cache != null) {
                this.cache.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SocketCreatorFactory.close();
    }

    public ClientCache getCache() {
        return this.cache;
    }
}

