/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.DataSerializable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.TransactionDataNodeHasDepartedException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.NestedTransactionFunction;
import org.apache.geode.internal.cache.TXId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommitFunction
implements Function,
DataSerializable {
    private static final Logger logger = LogManager.getLogger();
    private static final long serialVersionUID = 7851518767859544501L;

    public boolean hasResult() {
        return true;
    }

    public void execute(FunctionContext context) {
        Cache cache = CacheFactory.getAnyInstance();
        TXId txId = null;
        try {
            txId = (TXId)context.getArguments();
        }
        catch (ClassCastException e) {
            logger.info("CommitFunction should be invoked with a TransactionId as an argument i.e. setArguments(txId).execute(function)");
            throw e;
        }
        InternalDistributedMember member = txId.getMemberId();
        Boolean result = false;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (cache.getDistributedSystem().getDistributedMember().equals(member)) {
            CacheTransactionManager txMgr;
            if (isDebugEnabled) {
                logger.debug("CommitFunction: for transaction: {} committing locally", (Object)txId);
            }
            if ((txMgr = cache.getCacheTransactionManager()).tryResume((TransactionId)txId)) {
                if (isDebugEnabled) {
                    logger.debug("CommitFunction: resumed transaction: {}", (Object)txId);
                }
                txMgr.commit();
                result = true;
            }
        } else {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(txId);
            args.add(1);
            Execution ex = FunctionService.onMember((DistributedMember)member).setArguments(args);
            if (isDebugEnabled) {
                logger.debug("CommitFunction: for transaction: {} executing NestedTransactionFunction on member: {}", (Object)txId, (Object)member);
            }
            try {
                List list = (List)ex.execute((Function)new NestedTransactionFunction()).getResult();
                result = (Boolean)list.get(0);
            }
            catch (FunctionException fe) {
                if (fe.getCause() instanceof FunctionInvocationTargetException) {
                    throw new TransactionDataNodeHasDepartedException("Could not commit on member:" + member);
                }
                throw fe;
            }
        }
        if (isDebugEnabled) {
            logger.debug("CommitFunction: for transaction: {} returning result: {}", (Object)txId, (Object)result);
        }
        context.getResultSender().lastResult((Object)result);
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public boolean isHA() {
        return true;
    }

    public void toData(DataOutput out) throws IOException {
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
    }
}

