/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.data.Portfolio;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.internal.cache.EvictionAttributesImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.internal.cli.dto.Value1;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.test.dunit.IgnoredException;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.LocatorStarterRule;
import org.assertj.core.api.Java6Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class QueryCommandDUnitTestBase {
    private static final String DATA_REGION_NAME = "GemfireDataCommandsTestRegion";
    private static final String DATA_REGION_NAME_PATH = "/GemfireDataCommandsTestRegion";
    private static final String DATA_REGION_WITH_EVICTION_NAME = "GemfireDataCommandsTestRegionWithEviction";
    private static final String DATA_REGION_WITH_EVICTION_NAME_PATH = "/GemfireDataCommandsTestRegionWithEviction";
    private static final String DATA_PAR_REGION_NAME = "GemfireDataCommandsTestParRegion";
    private static final String DATA_PAR_REGION_NAME_PATH = "/GemfireDataCommandsTestParRegion";
    private static final String DATA_REGION_WITH_PROXY_NAME = "GemfireDataCommandsTestRegionWithProxy";
    private static final String DATA_REGION_WITH_PROXY_NAME_PATH = "/GemfireDataCommandsTestRegionWithProxy";
    private static final String SERIALIZATION_FILTER = "org.apache.geode.management.internal.cli.dto.**";
    static final int COUNT = 5;
    @Rule
    public GfshCommandRule gfsh = new GfshCommandRule();
    @Rule
    public ClusterStartupRule cluster = new ClusterStartupRule();
    protected MemberVM locator;
    protected MemberVM server1;
    protected MemberVM server2;

    @Before
    public void before() throws Exception {
        Properties locatorProps = this.locatorProperties();
        this.locator = this.cluster.startLocatorVM(0, l -> (LocatorStarterRule)((LocatorStarterRule)l.withHttpService()).withProperties(locatorProps));
        this.server1 = this.cluster.startServerVM(1, this.serverProperties(), this.locator.getPort());
        this.server2 = this.cluster.startServerVM(2, this.serverProperties(), this.locator.getPort());
        this.server1.invoke(() -> QueryCommandDUnitTestBase.setupReplicatedRegion(DATA_REGION_NAME));
        this.server2.invoke(() -> QueryCommandDUnitTestBase.setupReplicatedRegion(DATA_REGION_NAME));
        this.server1.invoke(() -> QueryCommandDUnitTestBase.setupPartitionedRegion(DATA_PAR_REGION_NAME));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_PATH, 1);
        this.connectToLocator();
    }

    public void connectToLocator() throws Exception {
        this.gfsh.connectAndVerify(this.locator.getJmxPort(), GfshCommandRule.PortType.jmxManager, new String[0]);
    }

    @Test
    public void testWithGfshEnvironmentVariables() {
        String query = "query --query=\"select ID , status , createTime , pk, floatMinValue from ${DATA_REGION} where ID <= ${PORTFOLIO_ID} and status=${STATUS}\" --interactive=false";
        this.gfsh.executeAndAssertThat("set variable --name=DATA_REGION --value=/GemfireDataCommandsTestRegion").statusIsSuccess();
        this.gfsh.executeAndAssertThat("set variable --name=PORTFOLIO_ID --value=3").statusIsSuccess();
        this.gfsh.executeAndAssertThat("set variable --name=STATUS --value=inactive").statusIsSuccess();
        this.gfsh.executeAndAssertThat(query).statusIsSuccess();
    }

    @Test
    public void testWithUnsetGfshEnvironmentVariables() {
        IgnoredException.addIgnoredException(QueryInvalidException.class.getSimpleName(), this.locator.getVM());
        String query = "query --query=\"select ID , status , createTime , pk, floatMinValue from ${UNSET_REGION} where ID <= ${UNSET_PORTFOLIO_ID} and status=${UNSET_STATUS}\" --interactive=false";
        this.gfsh.executeAndAssertThat(query).statusIsError().containsOutput(new String[]{String.format("Syntax error in query: %s", "")});
    }

    @Test
    public void testSimpleQuery() {
        this.server1.invoke(() -> QueryCommandDUnitTestBase.prepareDataForRegion(DATA_PAR_REGION_NAME_PATH));
        Random random = new Random(System.nanoTime());
        int randomInteger = random.nextInt(5);
        String query = "query --query=\"select ID , status , createTime , pk, floatMinValue from /GemfireDataCommandsTestParRegion where ID <= " + randomInteger + "\" --interactive=false";
        CommandResult commandResult = this.gfsh.executeCommand(query);
        this.validateSelectResult(commandResult, true, randomInteger + 1, new String[]{"ID", "status", "createTime", "pk", "floatMinValue"});
    }

    @Test
    public void testSimpleQueryOnLocator() {
        this.server1.invoke(() -> QueryCommandDUnitTestBase.prepareDataForRegion(DATA_PAR_REGION_NAME_PATH));
        this.locator.invoke(() -> {
            String query = "query --query=\"select ID , status , createTime , pk, floatMinValue from /GemfireDataCommandsTestParRegion where ID <= 4\" --interactive=false";
            ManagementService service = ManagementService.getExistingManagementService((Cache)ClusterStartupRule.getCache());
            MemberMXBean member = service.getMemberMXBean();
            String cmdResult = member.processCommand(query);
            Java6Assertions.assertThat((String)cmdResult).contains(new CharSequence[]{"ID"});
            Java6Assertions.assertThat((String)cmdResult).contains(new CharSequence[]{"status"});
            Java6Assertions.assertThat((String)cmdResult).contains(new CharSequence[]{"createTime"});
            Java6Assertions.assertThat((String)cmdResult).contains(new CharSequence[]{"pk"});
            Java6Assertions.assertThat((String)cmdResult).contains(new CharSequence[]{"floatMinValue"});
            Java6Assertions.assertThat((String)cmdResult).contains(new CharSequence[]{"\"Rows\":\"5\""});
        });
    }

    @Test
    public void testQueryEvictedDataDeserializable() {
        this.server1.invoke(() -> QueryCommandDUnitTestBase.setupReplicatedRegionWithEviction(DATA_REGION_WITH_EVICTION_NAME));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_WITH_EVICTION_NAME_PATH, 1);
        this.server1.invoke(() -> QueryCommandDUnitTestBase.prepareDeserializableDataForRegion(DATA_REGION_WITH_EVICTION_NAME_PATH));
        String query = "query --query=\"select Value from /GemfireDataCommandsTestRegionWithEviction\" --interactive=false";
        CommandResult commandResult = this.gfsh.executeCommand(query);
        this.validateSelectResult(commandResult, Boolean.TRUE, 10, new String[]{"Value"});
    }

    @Test
    public void testQueryEvictedDataNotDeserializable() {
        IgnoredException.addIgnoredException(Exception.class.getSimpleName(), this.server1.getVM());
        this.server1.invoke(() -> QueryCommandDUnitTestBase.setupReplicatedRegionWithEviction(DATA_REGION_WITH_EVICTION_NAME));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_WITH_EVICTION_NAME_PATH, 1);
        this.server1.invoke(() -> QueryCommandDUnitTestBase.prepareNotDeserializableDataForRegion(DATA_REGION_WITH_EVICTION_NAME_PATH));
        String query = "query --query=\"select Value from /GemfireDataCommandsTestRegionWithEviction\" --interactive=false";
        CommandResult commandResult = this.gfsh.executeCommand(query);
        this.validateSelectResult(commandResult, Boolean.FALSE, -1, new String[]{"Value"});
        Java6Assertions.assertThat((String)commandResult.asString()).contains(new CharSequence[]{"An IOException was thrown while deserializing"});
    }

    private static void prepareDataForRegion(String regionPath) {
        InternalCache cache = ClusterStartupRule.getCache();
        Region dataRegion = cache.getRegion(regionPath);
        for (int j = 0; j < 10; ++j) {
            dataRegion.put((Object)new Integer(j), (Object)new Portfolio(j));
        }
    }

    private static void prepareNotDeserializableDataForRegion(String regionPath) {
        InternalCache cache = ClusterStartupRule.getCache();
        Region dataRegion = cache.getRegion(regionPath);
        for (int j = 0; j < 10; ++j) {
            dataRegion.put((Object)new Integer(j), (Object)new shouldFailSerializationFilter(j));
        }
    }

    private static void prepareDeserializableDataForRegion(String regionPath) {
        InternalCache cache = ClusterStartupRule.getCache();
        Region dataRegion = cache.getRegion(regionPath);
        for (int j = 0; j < 10; ++j) {
            dataRegion.put((Object)new Integer(j), (Object)new Value1(j));
        }
    }

    private static void setupReplicatedRegionWithEviction(String regionName) {
        InternalCache cache = ClusterStartupRule.getCache();
        EvictionAttributesImpl evictionAttributes = new EvictionAttributesImpl();
        evictionAttributes.setMaximum(1).setAction(EvictionAction.OVERFLOW_TO_DISK).setAlgorithm(EvictionAlgorithm.LRU_ENTRY);
        RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE).setEvictionAttributes((EvictionAttributes)evictionAttributes);
        Region dataRegion = regionFactory.create(regionName);
        Java6Assertions.assertThat((Map)dataRegion).isNotNull();
        Java6Assertions.assertThat((String)dataRegion.getFullPath()).contains(new CharSequence[]{regionName});
    }

    private static void setupPartitionedRegion(String regionName) {
        InternalCache cache = ClusterStartupRule.getCache();
        PartitionAttributes partitionAttrs = new PartitionAttributesFactory().setRedundantCopies(2).create();
        RegionFactory partitionRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
        partitionRegionFactory.setPartitionAttributes(partitionAttrs);
        Region dataParRegion = partitionRegionFactory.create(regionName);
        Java6Assertions.assertThat((Map)dataParRegion).isNotNull();
        Java6Assertions.assertThat((String)dataParRegion.getFullPath()).contains(new CharSequence[]{regionName});
    }

    private static void setupReplicatedRegion(String regionName) {
        InternalCache cache = ClusterStartupRule.getCache();
        RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
        Region dataRegion = regionFactory.create(regionName);
        Java6Assertions.assertThat((Map)dataRegion).isNotNull();
        Java6Assertions.assertThat((String)dataRegion.getFullPath()).contains(new CharSequence[]{regionName});
    }

    private static void setupReplicatedProxyRegion(String regionName) {
        InternalCache cache = ClusterStartupRule.getCache();
        RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE_PROXY);
        Region proxyRegion = regionFactory.create(regionName);
        Java6Assertions.assertThat((Map)proxyRegion).isNotNull();
        Java6Assertions.assertThat((String)proxyRegion.getFullPath()).contains(new CharSequence[]{regionName});
    }

    private void validateSelectResult(CommandResult cmdResult, Boolean expectSuccess, Integer expectedRows, String[] cols) {
        ResultModel rd = cmdResult.getResultData();
        Map data = rd.getDataSection("data-info").getContent();
        Java6Assertions.assertThat((String)((String)data.get("Result"))).isEqualTo(expectSuccess.toString());
        if (expectSuccess.booleanValue() && expectedRows != -1) {
            Java6Assertions.assertThat((String)((String)data.get("Rows"))).isEqualTo(expectedRows.toString());
            if (expectedRows > 0 && cols != null) {
                Map table = rd.getTableSection("query").getContent();
                Java6Assertions.assertThat(table.keySet()).contains((Object[])cols);
            }
        }
    }

    private Properties locatorProperties() {
        int jmxPort = AvailablePortHelper.getRandomAvailableTCPPort();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("log-level", "fine");
        props.setProperty("serializable-object-filter", SERIALIZATION_FILTER);
        props.setProperty("jmx-manager-hostname-for-clients", "localhost");
        props.setProperty("jmx-manager-port", "" + jmxPort);
        return props;
    }

    private Properties serverProperties() {
        Properties props = new Properties();
        props.setProperty("serializable-object-filter", SERIALIZATION_FILTER);
        return props;
    }

    @Test
    public void testSimpleQueryWithProxyRegion() {
        this.server1.invoke(() -> QueryCommandDUnitTestBase.setupReplicatedProxyRegion(DATA_REGION_WITH_PROXY_NAME));
        this.server2.invoke(() -> QueryCommandDUnitTestBase.setupReplicatedRegion(DATA_REGION_WITH_PROXY_NAME));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_WITH_PROXY_NAME_PATH, 2);
        this.server1.invoke(() -> QueryCommandDUnitTestBase.prepareDataForRegion(DATA_REGION_WITH_PROXY_NAME_PATH));
        String member = "server-2";
        Random random = new Random(System.nanoTime());
        int randomInteger = random.nextInt(5);
        String queryString = "\"select ID , status , createTime , pk, floatMinValue from " + DATA_REGION_WITH_PROXY_NAME_PATH + " where ID <= " + randomInteger + "\"";
        String command = new CommandStringBuilder("query").addOption("member", member).addOption("query", queryString).getCommandString();
        CommandResult commandResult = this.gfsh.executeAndAssertThat(command).getCommandResult();
        this.validateSelectResult(commandResult, true, randomInteger + 1, new String[]{"ID", "status", "createTime", "pk", "floatMinValue"});
    }

    public static class shouldFailSerializationFilter
    extends Value1 {
        private Value1 value1 = null;

        public shouldFailSerializationFilter(int i) {
            super(i);
        }

        public Value1 getValue1() {
            return this.value1;
        }

        public void setValue1(Value1 value1) {
            this.value1 = value1;
        }
    }
}

