/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.ProcessHolder;
import org.apache.geode.test.dunit.internal.ProcessManager;
import org.apache.geode.test.dunit.internal.RemoteDUnitVM;
import org.apache.geode.test.dunit.internal.RemoteDUnitVMIF;
import org.apache.geode.test.dunit.internal.VMEventNotifier;

class DUnitHost
extends Host {
    private static final long serialVersionUID = -8034165624503666383L;
    private final transient VM debuggingVM = new VM(this, "10240.0.0", -1, new RemoteDUnitVM(), null, null);
    private final transient ProcessManager processManager;
    private final transient VMEventNotifier vmEventNotifier;

    DUnitHost(String hostName, ProcessManager processManager, VMEventNotifier vmEventNotifier) throws RemoteException {
        super(hostName, vmEventNotifier);
        this.processManager = processManager;
        this.vmEventNotifier = vmEventNotifier;
    }

    public void init(int numVMs, boolean launchLocator) throws RemoteException, NotBoundException, InterruptedException {
        for (int i = 0; i < numVMs; ++i) {
            RemoteDUnitVMIF remote = this.processManager.getStub(i);
            ProcessHolder processHolder = this.processManager.getProcessHolder(i);
            this.addVM(i, "10240.0.0", remote, processHolder, this.processManager);
        }
        if (launchLocator) {
            this.addLocator(-2, this.processManager.getStub(-2), this.processManager.getProcessHolder(-2), this.processManager);
        }
        DUnitHost.addHost(this);
    }

    @Override
    public VM getVM(int n) {
        if (n < this.getVMCount() && n != -1) {
            VM current = super.getVM(n);
            return this.getVM(current.getVersion(), n);
        }
        return this.getVM("10240.0.0", n);
    }

    @Override
    public VM getVM(String version, int n) {
        if (n == -1) {
            return this.debuggingVM;
        }
        if (n < this.getVMCount()) {
            VM current = super.getVM(n);
            if (!current.getVersion().equals(version)) {
                current.bounce(version);
            }
            return current;
        }
        int oldVMCount = this.getVMCount();
        if (n >= oldVMCount) {
            try {
                int i;
                for (i = oldVMCount; i < n; ++i) {
                    this.processManager.launchVM(i);
                }
                this.processManager.waitForVMs(120000L);
                for (i = oldVMCount; i < n; ++i) {
                    this.addVM(i, "10240.0.0", this.processManager.getStub(i), this.processManager.getProcessHolder(i), this.processManager);
                }
                this.processManager.launchVM(version, n, false);
                this.processManager.waitForVMs(120000L);
                this.addVM(n, version, this.processManager.getStub(n), this.processManager.getProcessHolder(n), this.processManager);
            }
            catch (IOException | InterruptedException | NotBoundException e) {
                throw new RuntimeException("Could not dynamically launch vm + " + n, e);
            }
        }
        return super.getVM(n);
    }
}

