/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.test.dunit.DistributedTestUtils;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.DistributedRule;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class InternalCacheForClientAccessDUnitTest<tearDown>
implements Serializable {
    public static final long serialVersionUID = 1L;
    @Rule
    public DistributedRule dunitRule = new DistributedRule();
    VM serverVM;
    VM clientVM;
    static GemFireCache cache;

    @Before
    public void setup() {
        this.serverVM = VM.getVM(0);
        this.clientVM = VM.getVM(1);
        int locatorPort = DistributedTestUtils.getDUnitLocatorPort();
        this.serverVM.invoke(() -> {
            String locatorSpec = "localhost[" + locatorPort + "]";
            CacheFactory config = new CacheFactory();
            config.set("locators", locatorSpec);
            config.set("name", "server1");
            Cache serverCache = config.create();
            cache = serverCache;
            CacheServer cacheServer = serverCache.addCacheServer();
            cacheServer.start();
        });
        this.clientVM.invoke(() -> {
            ClientCacheFactory config = new ClientCacheFactory();
            config.addPoolLocator("localhost", locatorPort);
            config.setPoolSubscriptionEnabled(true);
            cache = config.create();
        });
    }

    @After
    public void tearDown() {
        this.serverVM.invoke(() -> {
            DistributedSystem system = cache.getDistributedSystem();
            cache.close();
            cache = null;
            Assertions.assertThat((boolean)system.isConnected()).isFalse();
        });
        this.clientVM.invoke(() -> {
            cache.close();
            cache = null;
        });
    }

    @Test
    public void serverUsesFilteredCache() {
        this.serverVM.invoke(() -> {
            Cache serverCache = (Cache)cache;
            serverCache.createRegionFactory(RegionShortcut.REPLICATE).create("region");
        });
        this.clientVM.invoke(() -> {
            ClientCache clientCache = (ClientCache)cache;
            Region region = clientCache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("region");
            region.put((Object)"Object1", (Object)"Value1");
        });
        this.serverVM.invoke(() -> {
            Cache serverCache = (Cache)cache;
            CacheServer server = (CacheServer)serverCache.getCacheServers().stream().findFirst().get();
            CacheServerImpl impl = (CacheServerImpl)server;
            Assertions.assertThat((Object)impl.getAcceptor().getCachedRegionHelper().getCache()).isInstanceOf(InternalCacheForClientAccess.class);
        });
    }

    @Test
    public void invokeClientOperationsOnInternalRegion() {
        this.serverVM.invoke(() -> {
            GemFireCacheImpl serverCache = (GemFireCacheImpl)cache;
            InternalRegionArguments internalRegionArguments = new InternalRegionArguments();
            internalRegionArguments.setIsUsedForPartitionedRegionAdmin(true);
            RegionAttributes attributes = serverCache.getRegionAttributes(RegionShortcut.REPLICATE.toString());
            LocalRegion region = (LocalRegion)serverCache.createVMRegion("internalRegion", attributes, internalRegionArguments);
            Assertions.assertThat((boolean)region.isInternalRegion()).isTrue();
        });
        this.clientVM.invoke(this::testAllOperations);
    }

    private void testAllOperations() {
        ClientCache clientCache = (ClientCache)cache;
        Region region = clientCache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("internalRegion");
        this.assertFailure(() -> region.create((Object)"Object1", (Object)"Value1"));
        this.assertFailure(() -> {
            String cfr_ignored_0 = (String)region.put((Object)"Object1", (Object)"Value1");
        });
        this.assertFailure(() -> {
            String cfr_ignored_0 = (String)region.putIfAbsent((Object)"Object1", (Object)"Value1");
        });
        this.assertFailure(() -> {
            String cfr_ignored_0 = (String)region.get((Object)"Object1");
        });
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Object1", "Value1");
        this.assertFailure(() -> region.putAll(map));
        ArrayList<String> list = new ArrayList<String>();
        list.add("Object1");
        this.assertFailure(() -> region.getAll((Collection)list));
        this.assertFailure(() -> region.removeAll((Collection)list));
        this.assertFailure(() -> {
            String cfr_ignored_0 = (String)region.destroy((Object)"Object1");
        });
        this.assertFailure(() -> {
            String cfr_ignored_0 = (String)region.remove((Object)"Object1");
        });
        this.assertFailure(() -> region.replace((Object)"Object1", (Object)"oldValue", (Object)"newValue"));
        this.assertFailure(() -> region.invalidate((Object)"Object1"));
        this.assertFailure(() -> ((Region)region).keySetOnServer());
        this.assertFailure(() -> region.registerInterest((Object)"Object1"));
    }

    private void assertFailure(ThrowableAssert.ThrowingCallable callable) {
        Assertions.assertThatExceptionOfType(ServerOperationException.class).isThrownBy(callable).withCauseInstanceOf(NotAuthorizedException.class).withMessageContaining("The region internalRegion is an internal region that a client is never allowed to access");
    }
}

