/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.generator;

import java.security.Principal;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.cache.operations.OperationContext;
import org.apache.geode.security.generator.AuthzCredentialGenerator;
import org.apache.geode.security.templates.DummyAuthorization;
import org.apache.geode.security.templates.UsernamePrincipal;

public class DummyAuthzCredentialGenerator
extends AuthzCredentialGenerator {
    public static final byte READER_ROLE = 1;
    public static final byte WRITER_ROLE = 2;
    public static final byte ADMIN_ROLE = 3;
    private static Set readerOpsSet;
    private static Set writerOpsSet;

    public static byte getRequiredRole(OperationContext.OperationCode[] opCodes) {
        byte roleType = 3;
        boolean requiresReader = true;
        boolean requiresWriter = true;
        for (int opNum = 0; opNum < opCodes.length; ++opNum) {
            if (requiresReader && !readerOpsSet.contains(opCodes[opNum])) {
                requiresReader = false;
            }
            if (!requiresWriter || writerOpsSet.contains(opCodes[opNum])) continue;
            requiresWriter = false;
        }
        if (requiresReader) {
            roleType = 1;
        } else if (requiresWriter) {
            roleType = 2;
        }
        return roleType;
    }

    @Override
    protected Properties init() throws IllegalArgumentException {
        if (!this.generator.classCode().isDummy()) {
            throw new IllegalArgumentException("DummyAuthorization module only works with DummyAuthenticator");
        }
        return null;
    }

    @Override
    public AuthzCredentialGenerator.ClassCode classCode() {
        return AuthzCredentialGenerator.ClassCode.DUMMY;
    }

    @Override
    public String getAuthorizationCallback() {
        return DummyAuthorization.class.getName() + ".create";
    }

    @Override
    protected Principal getAllowedPrincipal(OperationContext.OperationCode[] opCodes, String[] regionNames, int index) {
        byte roleType = DummyAuthzCredentialGenerator.getRequiredRole(opCodes);
        return this.getPrincipal(roleType, index);
    }

    @Override
    protected Principal getDisallowedPrincipal(OperationContext.OperationCode[] opCodes, String[] regionNames, int index) {
        byte disallowedRoleType;
        byte roleType = DummyAuthzCredentialGenerator.getRequiredRole(opCodes);
        switch (roleType) {
            case 1: {
                disallowedRoleType = 2;
                break;
            }
            case 2: {
                disallowedRoleType = 1;
                break;
            }
            default: {
                disallowedRoleType = 1;
            }
        }
        return this.getPrincipal(disallowedRoleType, index);
    }

    @Override
    protected int getNumPrincipalTries(OperationContext.OperationCode[] opCodes, String[] regionNames) {
        return 5;
    }

    private Principal getPrincipal(byte roleType, int index) {
        String[] admins = new String[]{"root", "admin", "administrator"};
        switch (roleType) {
            case 1: {
                return new UsernamePrincipal("reader" + index);
            }
            case 2: {
                return new UsernamePrincipal("writer" + index);
            }
        }
        return new UsernamePrincipal(admins[index % admins.length]);
    }

    static {
        int index;
        readerOpsSet = new HashSet();
        for (index = 0; index < DummyAuthorization.READER_OPS.length; ++index) {
            readerOpsSet.add(DummyAuthorization.READER_OPS[index]);
        }
        writerOpsSet = new HashSet();
        for (index = 0; index < DummyAuthorization.WRITER_OPS.length; ++index) {
            writerOpsSet.add(DummyAuthorization.WRITER_OPS[index]);
        }
    }
}

