/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache30;

import java.io.IOException;
import java.util.Iterator;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.LoaderHelper;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache30.CacheSerializableRunnable;
import org.apache.geode.cache30.TestCacheLoader;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.DistributedTestUtils;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.cache.internal.JUnit4CacheTestCase;
import org.assertj.core.api.Assertions;

public abstract class ClientServerTestCase
extends JUnit4CacheTestCase {
    public static final String NON_EXISTENT_KEY = "NON_EXISTENT_KEY";
    public static boolean AUTO_LOAD_BALANCE = false;
    public static final String TEST_POOL_NAME = "testPool";
    private static final String BridgeServerKey = "BridgeServerKey";

    @Override
    public final void postSetUp() throws Exception {
        ClientServerTestCase.disconnectAllFromDS();
        this.postSetUpClientServerTestCase();
    }

    protected void postSetUpClientServerTestCase() throws Exception {
    }

    @Override
    public final void preTearDownCacheTestCase() throws Exception {
        this.preTearDownClientServerTestCase();
        ClientServerTestCase.disconnectAllFromDS();
    }

    protected void preTearDownClientServerTestCase() throws Exception {
    }

    public int startBridgeServer(int port) throws IOException {
        InternalCache cache = this.getCache();
        CacheServer bridge = cache.addCacheServer();
        bridge.setPort(port);
        bridge.setMaxThreads(this.getMaxThreads());
        bridge.start();
        return bridge.getPort();
    }

    protected int getMaxThreads() {
        return 0;
    }

    public void stopBridgeServers(Cache cache) {
        Iterator iterator = cache.getCacheServers().iterator();
        while (iterator.hasNext()) {
            CacheServer cacheServer;
            CacheServer bridge = cacheServer = (CacheServer)iterator.next();
            bridge.stop();
            Assertions.assertThat((boolean)bridge.isRunning()).isFalse();
        }
    }

    protected <K, V> RegionAttributes<K, V> getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        return factory.create();
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int port1, int port2, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval, int idleTimeout, int lifetimeTimeout) {
        int[] ports = port2 != -1 ? new int[]{port1, port2} : new int[]{port1};
        return ClientServerTestCase.configureConnectionPool(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, pingInterval, idleTimeout, lifetimeTimeout);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int port1, int port2, boolean establish, int redundancy, int connectionsPerServer, String serverGroup) {
        return ClientServerTestCase.configureConnectionPool(factory, host, port1, port2, establish, redundancy, connectionsPerServer, serverGroup, -1, -1, -2);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup) {
        return ClientServerTestCase.configureConnectionPool(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, -1, -1, -2);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval, int idleTimeout, int lifetimeTimeout) {
        return ClientServerTestCase.configureConnectionPoolWithNameAndFactory(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, null, PoolManager.createFactory(), pingInterval, idleTimeout, lifetimeTimeout, -1);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval, int idleTimeout, int lifetimeTimeout, int statisticInterval) {
        return ClientServerTestCase.configureConnectionPoolWithNameAndFactory(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, null, PoolManager.createFactory(), pingInterval, idleTimeout, lifetimeTimeout, statisticInterval);
    }

    public static Pool configureConnectionPoolWithNameAndFactory(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, String poolName, PoolFactory pf) {
        return ClientServerTestCase.configureConnectionPoolWithNameAndFactory(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, poolName, pf, -1, -1, -2, -1);
    }

    public static Pool configureConnectionPoolWithNameAndFactory(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, String poolName, PoolFactory pf, int pingInterval, int idleTimeout, int lifetimeTimeout, int statisticInterval) {
        if (AUTO_LOAD_BALANCE || ports.length == 0) {
            pf.addLocator(host, DistributedTestUtils.getLocatorPort());
        } else {
            for (int port : ports) {
                pf.addServer(host, port);
            }
        }
        if (connectionsPerServer != -1 && ports != null) {
            pf.setMinConnections(connectionsPerServer * ports.length);
        }
        if (pingInterval != -1) {
            pf.setPingInterval((long)pingInterval);
        }
        if (idleTimeout != -1) {
            pf.setIdleTimeout((long)idleTimeout);
        }
        if (statisticInterval != -1) {
            pf.setStatisticInterval(statisticInterval);
        }
        if (lifetimeTimeout != -2) {
            pf.setLoadConditioningInterval(lifetimeTimeout);
        }
        if (establish) {
            pf.setSubscriptionEnabled(true);
            pf.setSubscriptionRedundancy(redundancy);
            pf.setSubscriptionAckInterval(1);
        }
        if (serverGroup != null) {
            pf.setServerGroup(serverGroup);
        }
        String rpoolName = TEST_POOL_NAME;
        if (poolName != null) {
            rpoolName = poolName;
        }
        Pool pool = pf.create(rpoolName);
        if (factory != null) {
            factory.setPoolName(rpoolName);
        }
        return pool;
    }

    public static <K, V> Pool configureConnectionPool(RegionFactory<K, V> factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup) {
        return ClientServerTestCase.configureConnectionPoolWithNameAndFactory(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, TEST_POOL_NAME, PoolManager.createFactory(), -1, -1, -2, -1);
    }

    public static <K, V> Pool configureConnectionPoolWithNameAndFactory(RegionFactory<K, V> factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, String poolName, PoolFactory pf) {
        return ClientServerTestCase.configureConnectionPoolWithNameAndFactory(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, poolName, pf, -1, -1, -2, -1);
    }

    public static <K, V> Pool configureConnectionPoolWithNameAndFactory(RegionFactory<K, V> factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, String poolName, PoolFactory pf, int pingInterval, int idleTimeout, int lifetimeTimeout, int statisticInterval) {
        if (AUTO_LOAD_BALANCE || ports.length == 0) {
            pf.addLocator(host, DistributedTestUtils.getLocatorPort());
        } else {
            for (int port : ports) {
                pf.addServer(host, port);
            }
        }
        if (connectionsPerServer != -1 && ports != null) {
            pf.setMinConnections(connectionsPerServer * ports.length);
        }
        if (pingInterval != -1) {
            pf.setPingInterval((long)pingInterval);
        }
        if (idleTimeout != -1) {
            pf.setIdleTimeout((long)idleTimeout);
        }
        if (statisticInterval != -1) {
            pf.setStatisticInterval(statisticInterval);
        }
        if (lifetimeTimeout != -2) {
            pf.setLoadConditioningInterval(lifetimeTimeout);
        }
        if (establish) {
            pf.setSubscriptionEnabled(true);
            pf.setSubscriptionRedundancy(redundancy);
            pf.setSubscriptionAckInterval(1);
        }
        if (serverGroup != null) {
            pf.setServerGroup(serverGroup);
        }
        String rpoolName = TEST_POOL_NAME;
        if (poolName != null) {
            rpoolName = poolName;
        }
        Pool pool = pf.create(rpoolName);
        if (factory != null) {
            factory.setPoolName(rpoolName);
        }
        return pool;
    }

    protected static DistributedMember getMemberId() {
        GeodeAwaitility.await((String)("Waiting for client to connect " + ClientServerTestCase.getSystemStatic().getMemberId())).until(() -> ClientServerTestCase.getSystemStatic().getDistributedMember().getMembershipPort() > 0);
        return ClientServerTestCase.getSystemStatic().getDistributedMember();
    }

    protected void createBridgeServer(VM vm, final String rName, final int port) {
        vm.invoke("Create Region on Server", new CacheSerializableRunnable(){

            @Override
            public void run2() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setCacheLoader((CacheLoader)new CacheServerCacheLoader());
                    JUnit4CacheTestCase.beginCacheXml();
                    ClientServerTestCase.this.createRootRegion(rName, factory.create());
                    ClientServerTestCase.this.startBridgeServer(port);
                    ClientServerTestCase.this.finishCacheXml(rName + "-" + port);
                    Region region = ClientServerTestCase.this.getRootRegion(rName);
                    Assertions.assertThat(region).isNotNull();
                    region.put((Object)ClientServerTestCase.BridgeServerKey, (Object)port);
                }
                catch (Exception e) {
                    ClientServerTestCase.this.getSystem().getLogWriter().severe((Throwable)e);
                    Assertions.fail((String)("Failed to start CacheServer " + e));
                }
            }
        });
    }

    protected static int[] createUniquePorts() {
        return AvailablePortHelper.getRandomAvailableTCPPorts((int)1);
    }

    public static class CacheServerCacheLoader
    extends TestCacheLoader<Object, Object> {
        @Override
        public Object load2(LoaderHelper helper) {
            Object ret;
            if (helper.getArgument() instanceof Integer) {
                try {
                    Thread.sleep(((Integer)helper.getArgument()).intValue());
                }
                catch (InterruptedException ugh) {
                    Assertions.fail((String)"interrupted");
                }
            }
            if ((ret = helper.getKey()) instanceof String && ret != null && ret.equals(ClientServerTestCase.NON_EXISTENT_KEY)) {
                return null;
            }
            return ret;
        }
    }
}

