/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.templates;

import org.apache.geode.LogWriter;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlErrorHandler
implements ErrorHandler {
    private static final Logger logger = LogService.getLogger();
    private final LogWriter systemLogWriter;
    private final String xmlFileName;

    public XmlErrorHandler(LogWriter systemLogWriter, String xmlFileName) {
        this.systemLogWriter = systemLogWriter;
        this.xmlFileName = xmlFileName;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw new SAXParseException("Error while parsing XML at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), null, exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw new SAXParseException("Fatal error while parsing XML at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), null, exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.systemLogWriter.warning("Warning while parsing XML [" + this.xmlFileName + "] at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), (Throwable)exception);
    }
}

