/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache30.CacheSerializableRunnable;
import org.apache.geode.test.dunit.VM;

public class QueryTestUtils
implements Serializable {
    private static Cache cache;
    public HashMap<String, String> queries = new HashMap();
    public HashMap<String, String> bindQueries = new HashMap();
    private static QueryTestUtils instance;

    public static QueryTestUtils getInstance() {
        return instance;
    }

    public QueryTestUtils() {
        this.initializeQueryMap();
        this.initializeBindQueryMap();
    }

    public void initializeBindQueryMap() {
        this.bindQueries.put("1", "$1 AND $2");
        this.bindQueries.put("2", "$1 IN $2");
        this.bindQueries.put("3", "$1 IN $3");
        this.bindQueries.put("4", "$1 IN SET(1, 'a', $2, $3, $4, $5)");
        this.bindQueries.put("5", "$1 OR $2");
        this.bindQueries.put("6", "$1[$2]");
        this.bindQueries.put("7", "$1[0][0]");
        this.bindQueries.put("8", "$3 IN $2");
        this.bindQueries.put("9", "(SELECT DISTINCT * FROM /root/exampleRegion WHERE ID < $1).size");
        this.bindQueries.put("10", "/exampleRegion.containsValue($1)");
        this.bindQueries.put("11", "IMPORT org.apache.geode.cache.\"query\".data.Student;IMPORT org.apache.geode.cache.\"query\".data.Student$Subject;Select distinct * from  $1 as it1 ,  it1.subjects  type Student$Subject  where subject='Hindi'");
        this.bindQueries.put("12", "IMPORT org.apache.geode.cache.\"query\".data.Student;IMPORT org.apache.geode.cache.\"query\".data.Student$Subject;Select distinct * from  $1 as it1 ,  it1.subjects x  type Student$Subject  where x.subject='Hindi'");
        this.bindQueries.put("13", "IMPORT org.apache.geode.cache.\"query\".data.Student;IMPORT org.apache.geode.cache.\"query\".data.Student$Subject;Select distinct * from  $1 as it1 , (list<Student$Subject>) it1.subjects   where subject='Hindi'");
        this.bindQueries.put("14", "IMPORT org.apache.geode.cache.\"query\".data.Student;IMPORT org.apache.geode.cache.\"query\".data.Student$Teacher;Select distinct * from  $1 as it1 ,  it1.teachers  type Student$Teacher  where teacher='Y'");
        this.bindQueries.put("15", "IMPORT org.apache.geode.cache.\"query\".data.Student;IMPORT org.apache.geode.cache.\"query\".data.Student$Teacher;Select distinct * from  $1 as it1 ,  it1.teachers x  type Student$Teacher  where x.teacher='Y'");
        this.bindQueries.put("16", "IMPORT org.apache.geode.cache.\"query\".data.Student;IMPORT org.apache.geode.cache.\"query\".data.Student$Teacher;Select distinct * from  $1 as it1 , (list<Student$Teacher>) it1.teachers  where teacher='Y'");
        this.bindQueries.put("17", "IS_DEFINED($1)");
        this.bindQueries.put("18", "IS_UNDEFINED($1)");
        this.bindQueries.put("19", "NOT $1");
        this.bindQueries.put("20", "NOT $2");
        this.bindQueries.put("21", "NOT $3");
        this.bindQueries.put("22", "NOT $4");
        this.bindQueries.put("23", "SELECT  distinct ID, description, createTime FROM /exampleRegion1 pf1 where pf1.ID != $1 limit 10");
        this.bindQueries.put("24", "SELECT  distinct ID, description, createTime FROM /exampleRegion1 pf1 where pf1.ID != $1 order by ID");
        this.bindQueries.put("25", "SELECT * FROM /exampleRegion pf WHERE pf = $1");
        this.bindQueries.put("26", "SELECT * FROM /exampleRegion pf WHERE pf > $1");
        this.bindQueries.put("27", "SELECT * FROM /exampleRegion.keys k WHERE k.ID = $1");
        this.bindQueries.put("28", "SELECT * FROM /exampleRegion.keys key WHERE key.ID > $1");
        this.bindQueries.put("29", "SELECT * FROM /exampleRegion.values pf WHERE pf < $1");
        this.bindQueries.put("30", "SELECT * FROM /root/exampleRegion WHERE ID < $1 and Ticker = $2");
        this.bindQueries.put("31", "SELECT * FROM /root/exampleRegion WHERE ID = $1 and Ticker = $2");
        this.bindQueries.put("32", "SELECT DISTINCT * FROM $1 z where z.status = 'active'");
        this.bindQueries.put("33", "SELECT DISTINCT * FROM /exampleRegion WHERE ID < $1 ORDER BY $2");
        this.bindQueries.put("34", "SELECT DISTINCT * FROM /exampleRegion where ID = $1");
        this.bindQueries.put("35", "SELECT DISTINCT * FROM /exampleRegion where status = $1");
        this.bindQueries.put("36", "SELECT DISTINCT * FROM /exampleRegion where status.equals($1)");
        this.bindQueries.put("37", "SELECT DISTINCT * FROM /root/exampleRegion WHERE ID < $1 ORDER BY $2");
        this.bindQueries.put("38", "SELECT DISTINCT * FROM /root/exampleRegion WHERE ID < $1 ORDER BY ID");
        this.bindQueries.put("39", "SELECT DISTINCT booleanValue from $1 TYPE boolean");
        this.bindQueries.put("40", "SELECT DISTINCT booleanValue from (set<boolean>) $1");
        this.bindQueries.put("41", "SELECT DISTINCT byteValue from $1 TYPE byte");
        this.bindQueries.put("42", "SELECT DISTINCT byteValue from (set<byte>) $1");
        this.bindQueries.put("43", "SELECT DISTINCT charValue from $1 TYPE char");
        this.bindQueries.put("44", "SELECT DISTINCT charValue from (set<char>) $1");
        this.bindQueries.put("45", "SELECT DISTINCT doubleValue from $1 TYPE double");
        this.bindQueries.put("46", "SELECT DISTINCT doubleValue from (set<double>) $1");
        this.bindQueries.put("47", "SELECT DISTINCT floatValue from $1 TYPE float");
        this.bindQueries.put("48", "SELECT DISTINCT floatValue from (set<float>) $1");
        this.bindQueries.put("49", "SELECT DISTINCT intern from $1 TYPE string");
        this.bindQueries.put("50", "SELECT DISTINCT intern from (set<string>) $1");
        this.bindQueries.put("51", "SELECT DISTINCT longValue from $1 TYPE long");
        this.bindQueries.put("52", "SELECT DISTINCT longValue from (set<long>) $1");
        this.bindQueries.put("53", "SELECT DISTINCT shortValue from $1 TYPE short");
        this.bindQueries.put("54", "SELECT DISTINCT shortValue from (set<short>) $1");
        this.bindQueries.put("55", "SELECT ID, status FROM /exampleRegion.keys WHERE ID = $1");
        this.bindQueries.put("56", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.status like $1 AND ps.ID > 2 AND ps.ID < 150");
        this.bindQueries.put("57", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.status like $1");
        this.bindQueries.put("58", "SELECT e.key, e.value FROM /exampleRegion.entrySet e WHERE e.key IN $1");
        this.bindQueries.put("59", "SELECT e.value FROM /exampleRegion.entrySet e WHERE e.key IN $1");
        this.bindQueries.put("60", "SELECT itr.value FROM /root/exampleRegion.entries itr where itr.key = $1");
        this.bindQueries.put("61", "SELECT k.ID, k.status FROM /exampleRegion.keys k WHERE k.ID = $1 and k.status = $2");
        this.bindQueries.put("62", "SELECT key.ID FROM /exampleRegion.keys key WHERE key.ID = $1");
        this.bindQueries.put("63", "Select distinct * from /exampleRegion.keys keys where keys.hashCode >= $1");
        this.bindQueries.put("64", "Select distinct intValue from $1 TYPE int");
        this.bindQueries.put("65", "Select distinct intValue from (array<int>) $1");
        this.bindQueries.put("66", "Select distinct intValue from (list<int>) $1");
        this.bindQueries.put("67", "Select distinct keys.hashCode  from /exampleRegion.keys() keys where keys.hashCode >= $1");
        this.bindQueries.put("68", "Select distinct value.secId from /exampleRegion , getPositions($1)");
        this.bindQueries.put("69", "import org.apache.geode.cache.\"query\".data.Position;select distinct * from $1 r, r.positions.values pVal TYPE Position where r.status = 'active' AND pVal.mktValue >= 25.00");
        this.bindQueries.put("70", "import org.apache.geode.cache.\"query\".data.Position;select distinct r from $1 r, r.positions.values pVal TYPE Position where pVal.mktValue < $2");
        this.bindQueries.put("71", "import org.apache.geode.cache.\"query\".data.Position;select distinct r.ID, status, mktValue from $1 r, r.positions.values pVal TYPE Position where r.status = 'active' AND pVal.mktValue >= 25.00");
        this.bindQueries.put("72", "import java.util.Map$Entry as Entry;select distinct value.secId from /exampleRegion, getPositions(23) type Entry");
        this.bindQueries.put("73", "select * from $1");
        this.bindQueries.put("74", "select ALL * from $1");
        this.bindQueries.put("75", "select distinct * from $1 where status = 'active'");
        this.bindQueries.put("76", "select distinct * from $1");
        this.bindQueries.put("77", "select distinct * from /exampleRegion pf where pf.getCW(pf.ID) != $1");
        this.bindQueries.put("78", "select distinct * from /exampleRegion pf where pf.getCW(pf.ID) < $1");
        this.bindQueries.put("79", "select distinct * from /exampleRegion pf where pf.getCW(pf.ID) > $1");
        this.bindQueries.put("80", "select distinct * from /root/exampleRegion where ticker = $1");
        this.bindQueries.put("81", "select p from /exampleRegion.values p where p like $1");
        this.bindQueries.put("82", "select p.positions.get('acc') from $1 p");
    }

    public void initializeQueryMap() {
        this.queries.put("1", "SELECT DISTINCT * FROM /exampleRegion WHERE status = 'active'");
        this.queries.put("2", "SELECT * FROM /exampleRegion WHERE \"type\" = 'type1' and status = 'active'");
        this.queries.put("3", "SELECT key, positions FROM /exampleRegion.entrySet, value.positions.values positions WHERE positions.mktValue >= 25.00");
        this.queries.put("4", "SELECT DISTINCT entry.value FROM /exampleRegion.entries entry WHERE entry.key = '1'");
        this.queries.put("5", "SELECT * FROM /exampleRegion.entries entry WHERE entry.value.ID > 1");
        this.queries.put("6", "SELECT entry.value FROM /exampleRegion.entries entry WHERE entry.key = '1'");
        this.queries.put("7", "SELECT * FROM /exampleRegion.keySet key WHERE key = '1'");
        this.queries.put("8", "SELECT * FROM /exampleRegion.values portfolio WHERE portfolio.status = 'active'");
        this.queries.put("9", "SELECT entry.key, entry.value FROM /exampleRegion.entries entry WHERE entry.value['version'] = '100'");
        this.queries.put("10", "SELECT DISTINCT * FROM /exampleRegion WHERE ID < 101 ORDER BY ID");
        this.queries.put("11", "SELECT DISTINCT * FROM /exampleRegion WHERE ID < 101 ORDER BY ID asc");
        this.queries.put("12", "SELECT DISTINCT * FROM /exampleRegion WHERE ID < 101 ORDER BY ID desc");
        this.queries.put("13", "SELECT * FROM /exampleRegion p WHERE p.status LIKE 'active'");
        this.queries.put("14", "SELECT * FROM /exampleRegion p WHERE p.status LIKE 'activ%'");
        this.queries.put("15", "SELECT * FROM /exampleRegion p, p.positions.values AS pos WHERE pos.secId != '1'");
        this.queries.put("16", "SELECT DISTINCT * FROM /exampleRegion WHERE TRUE");
        this.queries.put("17", "SELECT * FROM /exampleRegion portfolio WHERE portfolio.ID IN SET(1, 2)");
        this.queries.put("18", "SELECT * FROM /exampleRegion portfolio, portfolio.positions.values positions WHERE portfolio.Pk IN SET ('1', '2') AND positions.secId = '1'");
        this.queries.put("19", "SELECT * FROM /exampleRegion portfolio, portfolio.positions.values positions WHERE portfolio.Pk IN SET ('1', '2') OR positions.secId IN SET ('1', '2', '3')");
        this.queries.put("20", "SELECT * FROM /exampleRegion portfolio, portfolio.positions.values positions WHERE portfolio.Pk IN SET ('1', '2') OR positions.secId IN SET ('1', '2', '3') and portfolio.status = 'active'");
        this.queries.put("21", "SELECT * FROM /exampleRegion portfolio WHERE portfolio.ID <> 2");
        this.queries.put("22", "SELECT * FROM /exampleRegion portfolio WHERE portfolio.ID != 2");
        this.queries.put("23", "(SELECT * FROM /exampleRegion).size");
        this.queries.put("24", "(SELECT * FROM /exampleRegion p WHERE p.ID = 1).size");
        this.queries.put("25", "SELECT * FROM /exampleRegion p WHERE p.status.length > 1");
        this.queries.put("26", "select * from /exampleRegion sp where sp = set ('20', '21', '22')");
        this.queries.put("27", "select * from /exampleRegion sp where sp.containsAll(set('20', '21', '22'))");
        this.queries.put("28", "select * from /exampleRegion sp where sp IN SET (set('20', '21', '22'), set('10', '11', '12'))");
        this.queries.put("29", "select distinct r.name, pVal, r.\"type\"   from /exampleRegion r , r.positions.values pVal where  ( r.name IN Set('name_11' , 'name_12') OR false ) AND pVal.mktValue = 1.00");
        this.queries.put("30", "select distinct r.name, pVal, r.\"type\"   from /exampleRegion r , r.positions.values pVal where  ( r.undefinedTestField.toString = UNDEFINED  AND true ) AND pVal.mktValue = 1.00");
        this.queries.put("31", "select distinct r.name, pVal, r.\"type\"   from /exampleRegion r , r.positions.values pVal where  ( r.undefinedTestField.toString = UNDEFINED  OR false )");
        this.queries.put("32", "select distinct r.name, pVal, r.\"type\"   from /exampleRegion r , r.positions.values pVal where  (r.name='name_11' OR r.name='name_12') AND pVal.mktValue >=1.00");
        this.queries.put("33", "(select distinct * from /exampleRegion).size");
        this.queries.put("34", "/exampleRegion.fullPath");
        this.queries.put("35", "/exampleRegion.size > 0");
        this.queries.put("36", "/exampleRegion.size");
        this.queries.put("37", "2 IN SET(1,2,3)");
        this.queries.put("38", "IMPORT org.apache.geode.cache.\"query\".data.Manager;SELECT DISTINCT manager_id FROM (set<Manager>)/exampleRegion where empId > 0");
        this.queries.put("39", "IMPORT org.apache.geode.cache.\"query\".data.Portfolio; SELECT DISTINCT * FROM (set<Portfolio>)/exampleRegion where iD > 0");
        this.queries.put("40", "IMPORT org.apache.geode.cache.\"query\".data.Position;IMPORT org.apache.geode.cache.\"query\".data.Portfolio;SELECT DISTINCT secId FROM (set<Portfolio>)/exampleRegion, (set<Position>)positions.values WHERE iD > 0");
        this.queries.put("41", "IMPORT org.apache.geode.cache.\"query\".data.Position;SELECT DISTINCT pos.secId FROM /exampleRegion, pos IN positions.values TYPE Position WHERE iD > 0");
        this.queries.put("42", "IMPORT org.apache.geode.cache.\"query\".data.Position;SELECT DISTINCT secId FROM /exampleRegion,  positions.values pos TYPE Position WHERE iD > 0");
        this.queries.put("43", "IMPORT org.apache.geode.cache.\"query\".data.Position;SELECT DISTINCT secId FROM /exampleRegion, (set<Position>)positions.values WHERE iD > 0");
        this.queries.put("44", "IMPORT org.apache.geode.cache.\"query\".data.Position;SELECT DISTINCT secId FROM /exampleRegion, positions.values AS pos TYPE Position WHERE iD > 0");
        this.queries.put("45", "SELECT   DISTINCT iD as portfolio_id, pos.secId as sec_id from /exampleRegion p , p.positions.values pos  where p.status= 'active'");
        this.queries.put("46", "SELECT  distinct * FROM /exampleRegion order by pkid desc");
        this.queries.put("47", "SELECT  distinct * FROM /exampleRegion pf1  order by pkid asc");
        this.queries.put("48", "SELECT  distinct * FROM /exampleRegion pf1 order by pkid");
        this.queries.put("49", "SELECT  distinct * FROM /exampleRegion pf1 where ID != 10 order by ID asc, pkid asc limit 10");
        this.queries.put("50", "SELECT  distinct * FROM /exampleRegion pf1 where ID != 10 order by ID desc");
        this.queries.put("51", "SELECT  distinct * FROM /exampleRegion pf1 where ID != 10 order by ID desc, pkid desc limit 10");
        this.queries.put("52", "SELECT  distinct * FROM /exampleRegion pf1 where ID > 0 order by pkid asc");
        this.queries.put("53", "SELECT  distinct * FROM /exampleRegion pf1 where ID > 0 order by pkid");
        this.queries.put("54", "SELECT  distinct * FROM /exampleRegion pf1 where ID > 10 and ID < 20 order by ID asc, pkid asc limit 5");
        this.queries.put("55", "SELECT  distinct * FROM /exampleRegion pf1 where ID > 10 and ID < 20 order by ID desc");
        this.queries.put("56", "SELECT  distinct * FROM /exampleRegion pf1 where pkid < '7' and ID > 10 and ID < 20 order by ID asc, pkid asc limit 5");
        this.queries.put("57", "SELECT  distinct * FROM /exampleRegion pf1 where pkid > '1' and pkid <='9' and ID >= 10 and ID <= 20 order by ID asc, pkid asc");
        this.queries.put("58", "SELECT  distinct * FROM /exampleRegion pf1 where pkid > '17' and ID > 10 order by ID asc, pkid desc limit 5");
        this.queries.put("59", "SELECT  distinct ID, description, createTime FROM /exampleRegion pf1 where ID > 10 and ID < 20 order by ID desc, pkid asc limit 5");
        this.queries.put("60", "SELECT  distinct ID, description, createTime FROM /exampleRegion pf1 where ID > 10 order by ID desc limit 5");
        this.queries.put("61", "SELECT  distinct ID, description, createTime FROM /exampleRegion pf1 where ID > 10 order by ID desc, pkid desc limit 5");
        this.queries.put("62", "SELECT  distinct ID, description, createTime FROM /exampleRegion pf1 where ID > 10 order by ID desc, pkid desc");
        this.queries.put("63", "SELECT  distinct ID, description, createTime FROM /exampleRegion pf1 where ID >= 10 and ID <= 20 order by ID asc, pkid desc");
        this.queries.put("64", "SELECT  distinct ID, description, createTime FROM /exampleRegion pf1 where ID >= 10 and ID <= 20 order by ID desc limit 5");
        this.queries.put("65", "SELECT  distinct ID, description, createTime FROM /exampleRegion pf1 where ID >= 10 and ID <= 20 order by ID desc");
        this.queries.put("66", "SELECT  distinct ID, description, createTime FROM /exampleRegion pf1 where ID >= 10 and ID <= 20 order by ID desc, pkid desc limit 5");
        this.queries.put("67", "SELECT  distinct ID, description, createTime FROM /exampleRegion pf1 where pf1.ID != '10' order by ID desc limit 5");
        this.queries.put("68", "SELECT  distinct ID, description, createTime FROM /exampleRegion pf1 where pkid > 'a' and ID >= 10 and ID <= 20 order by ID desc, pkid asc limit 5");
        this.queries.put("69", "SELECT  distinct ID, pkid FROM /exampleRegion pf1 where ID < 1000 order by pkid");
        this.queries.put("70", "SELECT  distinct ID, pkid FROM /exampleRegion pf1 where ID > 0 order by pkid");
        this.queries.put("71", "SELECT  distinct ID, pkid FROM /exampleRegion pf1 where ID > 0 order by pkid, ID asc");
        this.queries.put("72", "SELECT  distinct ID, pkid FROM /exampleRegion pf1 where ID > 0 order by pkid, ID desc");
        this.queries.put("73", "SELECT  distinct pkid FROM /exampleRegion pf1 order by pkid");
        this.queries.put("74", "SELECT  distinct pkid FROM /exampleRegion pf1 where ID > 0 order by pkid asc");
        this.queries.put("75", "SELECT  distinct pkid FROM /exampleRegion pf1 where ID > 0 order by pkid desc");
        this.queries.put("76", "SELECT  distinct pkid FROM /exampleRegion pf1 where ID > 0 order by pkid");
        this.queries.put("77", "SELECT  distinct pkid FROM /exampleRegion pf1 where pkid != 'XXXX' order by pkid asc");
        this.queries.put("78", "SELECT  distinct pkid FROM /exampleRegion pf1 where pkid != 'XXXX' order by pkid desc");
        this.queries.put("79", "SELECT * FROM /exampleRegion p where p.intVar < 9");
        this.queries.put("80", "SELECT * FROM /exampleRegion pf WHERE pf = 'XX1'");
        this.queries.put("81", "SELECT * FROM /exampleRegion pf WHERE pf IN SET( 'XX5', 'XX6', 'XX7')");
        this.queries.put("82", "SELECT * FROM /exampleRegion");
        this.queries.put("83", "SELECT * FROM /exampleRegion.keys k WHERE k.ID = 1");
        this.queries.put("84", "SELECT * FROM /exampleRegion.keys key WHERE key.ID = 1");
        this.queries.put("85", "SELECT * FROM /exampleRegion.keys key WHERE key.ID > 5");
        this.queries.put("86", "SELECT * FROM /exampleRegion.values pf WHERE pf IN SET( 'XX5', 'XX6', 'XX7')");
        this.queries.put("87", "SELECT * from /exampleRegion");
        this.queries.put("88", "SELECT ALL * FROM /exampleRegion");
        this.queries.put("89", "SELECT DISTINCT  q.cusip, q.quoteType, q.dealerPortfolio, q.channelName, q.dealerCode, q.priceType, q.price, q.lowerQty, q.upperQty, q.ytm, r.minQty, r.maxQty, r.incQty FROM /exampleRegion q, /exampleRegion r WHERE q.cusip = r.cusip AND q.quoteType = r.quoteType");
        this.queries.put("90", "SELECT DISTINCT * FROM (SELECT DISTINCT * FROM /exampleRegion AS ptf, positions AS pos) WHERE pos.value.secId = 'IBM'");
        this.queries.put("91", "SELECT DISTINCT * FROM (SELECT DISTINCT * FROM /exampleRegion ptf, positions pos) WHERE pos.value.secId = 'IBM'");
        this.queries.put("92", "SELECT DISTINCT * FROM (SELECT DISTINCT * FROM /exampleRegion ptf, positions pos) p WHERE p.get('pos').value.secId = 'IBM'");
        this.queries.put("93", "SELECT DISTINCT * FROM (SELECT DISTINCT * FROM /exampleRegion ptf, positions pos) p WHERE p.pos.value.secId = 'IBM'");
        this.queries.put("94", "SELECT DISTINCT * FROM (SELECT DISTINCT * FROM /exampleRegion ptf, positions pos) p WHERE pos.value.secId = 'IBM'");
        this.queries.put("95", "SELECT DISTINCT * FROM (SELECT DISTINCT * FROM /exampleRegion, positions) WHERE positions.value.secId = 'IBM'");
        this.queries.put("96", "SELECT DISTINCT * FROM (SELECT DISTINCT * FROM /exampleRegion, positions) p WHERE p.positions.value.secId = 'IBM'");
        this.queries.put("97", "SELECT DISTINCT * FROM (SELECT DISTINCT * FROM ptf IN /exampleRegion, pos IN positions) WHERE pos.value.secId = 'IBM'");
        this.queries.put("98", "SELECT DISTINCT * FROM (SELECT DISTINCT pos AS myPos FROM /exampleRegion ptf, positions pos) WHERE myPos.value.secId = 'IBM'");
        this.queries.put("99", "SELECT DISTINCT * FROM /exampleRegion  pf WHERE pf.ID > 10 limit 5");
        this.queries.put("100", "SELECT DISTINCT * FROM /exampleRegion  pf, pf.collectionHolderMap.keySet  WHERE pf.ID > 10 limit 20");
        this.queries.put("101", "SELECT DISTINCT * FROM /exampleRegion WHERE NOT(SELECT DISTINCT * FROM positions.values p WHERE p.secId = 'IBM').isEmpty");
        this.queries.put("102", "SELECT DISTINCT * FROM /exampleRegion as a, a.collectionHolderMap['0'].arr as b where a.status = 'active' and a.ID = 0");
        this.queries.put("103", "SELECT DISTINCT * FROM /exampleRegion c WHERE c.name = 'INDIA'");
        this.queries.put("104", "SELECT DISTINCT * FROM /exampleRegion c, c.states s, s.districts d WHERE d.name = 'PUNEDIST' AND s.name = 'GUJARAT'");
        this.queries.put("105", "SELECT DISTINCT * FROM /exampleRegion c, c.states s, s.districts d, d.cities ct WHERE ct.name = 'MUMBAI'");
        this.queries.put("106", "SELECT DISTINCT * FROM /exampleRegion c, c.states s, s.districts d, d.cities ct, d.villages v WHERE c.name = 'INDIA'");
        this.queries.put("107", "SELECT DISTINCT * FROM /exampleRegion c, c.states s, s.districts d, d.villages v, d.cities ct WHERE ct.name = 'PUNE' AND s.name = 'MAHARASHTRA'");
        this.queries.put("108", "SELECT DISTINCT * FROM /exampleRegion c, c.states s, s.districts d, d.villages v, d.cities ct WHERE v.name = 'MAHARASHTRA_VILLAGE1'");
        this.queries.put("109", "SELECT DISTINCT * FROM /exampleRegion c, c.states s, s.districts d, d.villages v, d.cities ct WHERE v.name='MAHARASHTRA_VILLAGE1' AND ct.name = 'PUNE'");
        this.queries.put("110", "SELECT DISTINCT * FROM /exampleRegion itr1  WHERE itr1.liist[0] >= 2");
        this.queries.put("111", "SELECT DISTINCT * FROM /exampleRegion itr1  WHERE itr1.maap.get('key2') >= 16");
        this.queries.put("112", "SELECT DISTINCT * FROM /exampleRegion itr1  WHERE itr1.maap.get('key2') >= 3");
        this.queries.put("113", "SELECT DISTINCT * FROM /exampleRegion itr1  WHERE itr1.maap['key2'] >= 16");
        this.queries.put("114", "SELECT DISTINCT * FROM /exampleRegion itr1  WHERE itr1.maap['key2'] >= 3  and  itr1.maap['key3'] < 18");
        this.queries.put("115", "SELECT DISTINCT * FROM /exampleRegion itr1  WHERE itr1.maap['key2'] >= 3 and itr1.maap['key2'] <=18");
        this.queries.put("116", "SELECT DISTINCT * FROM /exampleRegion itr1  WHERE itr1.maap['key2'] >= 3");
        this.queries.put("117", "SELECT DISTINCT * FROM /exampleRegion itr1  WHERE itr1.maap['key3'] >= 3  and  itr1.maap['key3'] >= 13");
        this.queries.put("118", "SELECT DISTINCT * FROM /exampleRegion itr1  WHERE itr1.maap['key3'] >= 3");
        this.queries.put("119", "SELECT DISTINCT * FROM /exampleRegion itr1  WHERE itr1.maap['key4'] >= 16");
        this.queries.put("120", "SELECT DISTINCT * FROM /exampleRegion num WHERE num.id1 >= -200");
        this.queries.put("121", "SELECT DISTINCT * FROM /exampleRegion p  WHERE p.ID <= 10 order by p.ID asc limit 1");
        this.queries.put("122", "SELECT DISTINCT * FROM /exampleRegion p  WHERE p.ID <= 10 order by p.ID desc limit 1");
        this.queries.put("123", "SELECT DISTINCT * FROM /exampleRegion p  WHERE p.ID <= 10 order by p.pkid desc limit 1");
        this.queries.put("124", "SELECT DISTINCT * FROM /exampleRegion pf WHERE pf.ID > 0 limit 5");
        this.queries.put("125", "SELECT DISTINCT * FROM /exampleRegion pf where pf.description = 'XXXX'  and pf.status='active' and pf.createTime = 5");
        this.queries.put("126", "SELECT DISTINCT * FROM /exampleRegion pf where pf.description = 'XXXX'  and pf.status='active'");
        this.queries.put("127", "SELECT DISTINCT * FROM /exampleRegion pf,  positions.values pos where pf.ID > 0 and pf.ID < 250  and pf.status='active' and  pos.secId != null");
        this.queries.put("128", "SELECT DISTINCT * FROM /exampleRegion pf,  positions.values pos where pf.status='active' and pos.secId= 'IBM' and pf.ID = 0");
        this.queries.put("129", "SELECT DISTINCT * FROM /exampleRegion pf, /exampleRegion emp WHERE pf.ID = emp.empId");
        this.queries.put("130", "SELECT DISTINCT * FROM /exampleRegion pf, pf.positions pos, /exampleRegion emp WHERE pf.iD = emp.empId and pf.status='active' and emp.age > 900");
        this.queries.put("131", "SELECT DISTINCT * FROM /exampleRegion pf, pf.positions pos, /exampleRegion emp WHERE pf.iD = emp.empId");
        this.queries.put("132", "SELECT DISTINCT * FROM /exampleRegion pf, pf.positions.values WHERE pf.ID > 0 limit 5");
        this.queries.put("133", "SELECT DISTINCT * FROM /exampleRegion pf, pf.positions.values position WHERE (pf.ID > 0 OR position.secId = 'SUN') OR false");
        this.queries.put("134", "SELECT DISTINCT * FROM /exampleRegion pf, pf.positions.values position WHERE (true = null OR position.secId = 'SUN') AND true");
        this.queries.put("135", "SELECT DISTINCT * FROM /exampleRegion pf, pf.positions.values position WHERE (true = null OR position.secId = 'SUN') OR true");
        this.queries.put("136", "SELECT DISTINCT * FROM /exampleRegion pf, pf.positions.values position WHERE true = null OR position.secId = 'SUN'");
        this.queries.put("137", "SELECT DISTINCT * FROM /exampleRegion value  where value.length > 6");
        this.queries.put("138", "SELECT DISTINCT * FROM /exampleRegion value");
        this.queries.put("139", "SELECT DISTINCT * FROM /exampleRegion where (status = 'active' OR ID = 2) AND P1.secId  = 'IBM'");
        this.queries.put("140", "SELECT DISTINCT * FROM /exampleRegion where FALSE");
        this.queries.put("141", "SELECT DISTINCT * FROM /exampleRegion where NOT (status = 'active') AND ID = 2");
        this.queries.put("142", "SELECT DISTINCT * FROM /exampleRegion where NOT (status = 'active') OR ID = 2");
        this.queries.put("143", "SELECT DISTINCT * FROM /exampleRegion where NULL");
        this.queries.put("144", "SELECT DISTINCT * FROM /exampleRegion where P1.secId != 'IBM'");
        this.queries.put("145", "SELECT DISTINCT * FROM /exampleRegion where P1.secId > 'IBM'");
        this.queries.put("146", "SELECT DISTINCT * FROM /exampleRegion where P1.secId >= 'IBM'");
        this.queries.put("147", "SELECT DISTINCT * FROM /exampleRegion where P1.secId!='DELL'");
        this.queries.put("148", "SELECT DISTINCT * FROM /exampleRegion where P1.secId<'DELL'");
        this.queries.put("149", "SELECT DISTINCT * FROM /exampleRegion where P1.secId<='DELL'");
        this.queries.put("150", "SELECT DISTINCT * FROM /exampleRegion where P1.secId<>'DELL'");
        this.queries.put("151", "SELECT DISTINCT * FROM /exampleRegion where P1.secId='DELL'");
        this.queries.put("152", "SELECT DISTINCT * FROM /exampleRegion where P1.secId>'DELL'");
        this.queries.put("153", "SELECT DISTINCT * FROM /exampleRegion where P1.secId>='DELL'");
        this.queries.put("154", "SELECT DISTINCT * FROM /exampleRegion where P1.secType = 'a'");
        this.queries.put("155", "SELECT DISTINCT * FROM /exampleRegion where P2!=null");
        this.queries.put("156", "SELECT DISTINCT * FROM /exampleRegion where P2.secId = UNDEFINED");
        this.queries.put("157", "SELECT DISTINCT * FROM /exampleRegion where P2.secId = null");
        this.queries.put("158", "SELECT DISTINCT * FROM /exampleRegion where P2.secId!= UNDEFINED");
        this.queries.put("159", "SELECT DISTINCT * FROM /exampleRegion where P2.secId< UNDEFINED");
        this.queries.put("160", "SELECT DISTINCT * FROM /exampleRegion where P2.secId<= UNDEFINED");
        this.queries.put("161", "SELECT DISTINCT * FROM /exampleRegion where P2.secId<> UNDEFINED");
        this.queries.put("162", "SELECT DISTINCT * FROM /exampleRegion where P2.secId= UNDEFINED");
        this.queries.put("163", "SELECT DISTINCT * FROM /exampleRegion where P2.secId> UNDEFINED");
        this.queries.put("164", "SELECT DISTINCT * FROM /exampleRegion where P2.secId>= UNDEFINED");
        this.queries.put("165", "SELECT DISTINCT * FROM /exampleRegion where P2<=null");
        this.queries.put("166", "SELECT DISTINCT * FROM /exampleRegion where P2<>null");
        this.queries.put("167", "SELECT DISTINCT * FROM /exampleRegion where P2<null");
        this.queries.put("168", "SELECT DISTINCT * FROM /exampleRegion where P2=null");
        this.queries.put("169", "SELECT DISTINCT * FROM /exampleRegion where P2>=null");
        this.queries.put("170", "SELECT DISTINCT * FROM /exampleRegion where P2>null");
        this.queries.put("171", "SELECT DISTINCT * FROM /exampleRegion where TRUE");
        this.queries.put("172", "SELECT DISTINCT * FROM /exampleRegion where UNDEFINED");
        this.queries.put("173", "SELECT DISTINCT * FROM /exampleRegion where ID != 2");
        this.queries.put("174", "SELECT DISTINCT * FROM /exampleRegion where ID <> 2");
        this.queries.put("175", "SELECT DISTINCT * FROM /exampleRegion where ID >= 2");
        this.queries.put("176", "SELECT DISTINCT * FROM /exampleRegion where ID!=2");
        this.queries.put("177", "SELECT DISTINCT * FROM /exampleRegion where ID<2");
        this.queries.put("178", "SELECT DISTINCT * FROM /exampleRegion where ID<=2");
        this.queries.put("179", "SELECT DISTINCT * FROM /exampleRegion where ID<>2");
        this.queries.put("180", "SELECT DISTINCT * FROM /exampleRegion where ID=2");
        this.queries.put("181", "SELECT DISTINCT * FROM /exampleRegion where ID>2");
        this.queries.put("182", "SELECT DISTINCT * FROM /exampleRegion where ID>=2");
        this.queries.put("183", "SELECT DISTINCT * FROM /exampleRegion where status != 'active'");
        this.queries.put("184", "SELECT DISTINCT * FROM /exampleRegion where status < 'active'");
        this.queries.put("185", "SELECT DISTINCT * FROM /exampleRegion where status <= 'active'");
        this.queries.put("186", "SELECT DISTINCT * FROM /exampleRegion where status <> 'active'");
        this.queries.put("187", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' AND ( ID = 2 OR P1.secId  = 'IBM')");
        this.queries.put("188", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' AND NOT( ID = 2 )");
        this.queries.put("189", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' AND P1.secType = 'a'");
        this.queries.put("190", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' AND ID = 1 OR P1.secType = 'a'");
        this.queries.put("191", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' AND ID = 2 AND P1.secId  = 'IBM'");
        this.queries.put("192", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' AND ID = 2 OR P1.secId  = 'IBM'");
        this.queries.put("193", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' AND ID = 2");
        this.queries.put("194", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' AND ID =1 AND P1.secType = 'a'");
        this.queries.put("195", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' OR NOT( ID = 2 )");
        this.queries.put("196", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' OR P1.secType = 'a'");
        this.queries.put("197", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' OR ID = 1 AND P1.secType = 'a'");
        this.queries.put("198", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' OR ID = 2 AND P1.secId  = 'IBM'");
        this.queries.put("199", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' OR ID = 2 OR P1.secId  = 'IBM'");
        this.queries.put("200", "SELECT DISTINCT * FROM /exampleRegion where status = 'active' OR ID = 2");
        this.queries.put("201", "SELECT DISTINCT * FROM /exampleRegion where status = 'active'");
        this.queries.put("202", "SELECT DISTINCT * FROM /exampleRegion where status = 'inactive'");
        this.queries.put("203", "SELECT DISTINCT * FROM /exampleRegion where status > 'active'");
        this.queries.put("204", "SELECT DISTINCT * FROM /exampleRegion where status >= 'active'");
        this.queries.put("205", "SELECT DISTINCT * FROM /exampleRegion where status='active'");
        this.queries.put("206", "SELECT DISTINCT * FROM /exampleRegion where\"AND\"()");
        this.queries.put("207", "SELECT DISTINCT * FROM /exampleRegion where\"DISTINCT\"()");
        this.queries.put("208", "SELECT DISTINCT * FROM /exampleRegion where\"ELEMENT\"()");
        this.queries.put("209", "SELECT DISTINCT * FROM /exampleRegion where\"FALSE\"");
        this.queries.put("210", "SELECT DISTINCT * FROM /exampleRegion where\"FALSE\"()");
        this.queries.put("211", "SELECT DISTINCT * FROM /exampleRegion where\"FROM\"()");
        this.queries.put("212", "SELECT DISTINCT * FROM /exampleRegion where\"NOT\"()");
        this.queries.put("213", "SELECT DISTINCT * FROM /exampleRegion where\"OR\"()");
        this.queries.put("214", "SELECT DISTINCT * FROM /exampleRegion where\"SELECT\"()");
        this.queries.put("215", "SELECT DISTINCT * FROM /exampleRegion where\"TRUE\"");
        this.queries.put("216", "SELECT DISTINCT * FROM /exampleRegion where\"TRUE\"()");
        this.queries.put("217", "SELECT DISTINCT * FROM /exampleRegion where\"TYPE\"()");
        this.queries.put("218", "SELECT DISTINCT * FROM /exampleRegion where\"UNDEFINED\"()");
        this.queries.put("219", "SELECT DISTINCT * FROM /exampleRegion where\"WHERE\"()");
        this.queries.put("220", "SELECT DISTINCT * FROM /exampleRegion where\"and\"");
        this.queries.put("221", "SELECT DISTINCT * FROM /exampleRegion where\"distinct\"");
        this.queries.put("222", "SELECT DISTINCT * FROM /exampleRegion where\"element\"");
        this.queries.put("223", "SELECT DISTINCT * FROM /exampleRegion where\"from\"");
        this.queries.put("224", "SELECT DISTINCT * FROM /exampleRegion where\"not\"");
        this.queries.put("225", "SELECT DISTINCT * FROM /exampleRegion where\"or\"");
        this.queries.put("226", "SELECT DISTINCT * FROM /exampleRegion where\"select\"");
        this.queries.put("227", "SELECT DISTINCT * FROM /exampleRegion where\"undefined\"");
        this.queries.put("228", "SELECT DISTINCT * FROM /exampleRegion where\"where\"");
        this.queries.put("229", "SELECT DISTINCT * FROM /exampleRegion x where status = ELEMENT(SELECT DISTINCT * FROM /exampleRegion p where p.ID = 1).status");
        this.queries.put("230", "SELECT DISTINCT * FROM /exampleRegion x where status = ELEMENT(SELECT DISTINCT * FROM /exampleRegion p where p.ID = x.ID).status");
        this.queries.put("231", "SELECT DISTINCT * FROM /exampleRegion x where status = ELEMENT(SELECT DISTINCT * FROM /exampleRegion p where x.ID = p.ID).status");
        this.queries.put("232", "SELECT DISTINCT * FROM /exampleRegion");
        this.queries.put("233", "SELECT DISTINCT * FROM /exampleRegion er,  positions.values where er.status='active'");
        this.queries.put("234", "SELECT DISTINCT * FROM /exampleRegion er, positions WHERE er.ID = 3");
        this.queries.put("235", "SELECT DISTINCT * FROM NULL");
        this.queries.put("236", "SELECT DISTINCT * FROM UNDEFINED");
        this.queries.put("237", "SELECT DISTINCT * from /exampleRegion order by status, ID desc");
        this.queries.put("238", "SELECT DISTINCT * from /exampleRegion p order by p.getID()");
        this.queries.put("239", "SELECT DISTINCT * from /exampleRegion p order by p.getP1().getSecId()");
        this.queries.put("240", "SELECT DISTINCT * from /exampleRegion p order by p.getP1().secId");
        this.queries.put("241", "SELECT DISTINCT * from /exampleRegion p order by p.getP1().secId, p.ID desc, p.ID LIMIT 9");
        this.queries.put("242", "SELECT DISTINCT * from /exampleRegion p order by p.ID");
        this.queries.put("243", "SELECT DISTINCT * from /exampleRegion p order by p.names[1]");
        this.queries.put("244", "SELECT DISTINCT * from /exampleRegion p order by p.position1.secId");
        this.queries.put("245", "SELECT DISTINCT * from /exampleRegion p order by p.status, p.ID");
        this.queries.put("246", "SELECT DISTINCT * from /exampleRegion p, p.positions.values order by p.ID");
        this.queries.put("247", "SELECT DISTINCT * from /exampleRegion pf , pf.positions.values pos where pos.getSecId = 'IBM' and pf.status = 'inactive'");
        this.queries.put("248", "SELECT DISTINCT * from /exampleRegion pf, pf.positions.values pos where pos.secId = 'IBM'");
        this.queries.put("249", "SELECT DISTINCT c.name, s.name FROM /exampleRegion c, c.states s, s.districts d, d.cities ct WHERE ct.name = 'MUMBAI' AND s.name = 'GUJARAT'");
        this.queries.put("250", "SELECT DISTINCT c.name, s.name FROM /exampleRegion c, c.states s, s.districts d, d.cities ct WHERE ct.name = 'MUMBAI' OR s.name = 'GUJARAT'");
        this.queries.put("251", "SELECT DISTINCT c.name, s.name, ct.name FROM /exampleRegion c, c.states s, s.districts d, d.cities ct, d.getVillages() v WHERE v.getName() = 'PUNJAB_VILLAGE1'");
        this.queries.put("252", "SELECT DISTINCT c.name, s.name, d.name, ct.name FROM /exampleRegion c, c.states s, s.districts d, d.cities ct WHERE ct.name = 'MUMBAI' OR ct.name = 'CHENNAI'");
        this.queries.put("253", "SELECT DISTINCT c1.name, s1.name, ct1.name FROM /exampleRegion c1, c1.states s1, s1.districts d1, d1.cities ct1, d1.getVillages() v1 WHERE v1.getName() = 'PUNJAB_VILLAGE1'");
        this.queries.put("254", "SELECT DISTINCT d.getName(), d.getCities(), d.getVillages() FROM /exampleRegion c, c.states s, s.districts d WHERE d.name = 'MUMBAIDIST'");
        this.queries.put("255", "SELECT DISTINCT e.key from /exampleRegion.entrySet e order by e.key.ID desc, e.key.pkid desc");
        this.queries.put("256", "SELECT DISTINCT e.key from /exampleRegion.entrySet e order by e.key.ID, e.key.pkid desc");
        this.queries.put("257", "SELECT DISTINCT e.key, e.value from /exampleRegion.entrySet e order by e.key.ID, e.value.status desc");
        this.queries.put("258", "SELECT DISTINCT e.key.ID from /exampleRegion.entries e order by e.key.ID");
        this.queries.put("259", "SELECT DISTINCT e.key.ID, e.value.status from /exampleRegion.entries e order by e.key.ID");
        this.queries.put("260", "SELECT DISTINCT e.key.ID, e.value.status from /exampleRegion.entrySet e order by e.key.ID desc , e.value.status desc");
        this.queries.put("261", "SELECT DISTINCT e.key.ID, e.value.status from /exampleRegion.entrySet e order by e.key.ID, e.value.status desc");
        this.queries.put("262", "SELECT DISTINCT r.iD, p.value.secId FROM /exampleRegion r, getPositions('true') p where r.status = 'active' and r.iD = 0");
        this.queries.put("263", "SELECT DISTINCT er.ID, value.secId FROM /exampleRegion er, getPositions value where er.status = 'active' and er.ID = 0");
        this.queries.put("264", "SELECT DISTINCT key from /exampleRegion.keys key order by key.status");
        this.queries.put("265", "SELECT DISTINCT key.ID from /exampleRegion.keys key order by key.ID");
        this.queries.put("266", "SELECT DISTINCT key.ID, key.status from /exampleRegion.keys key order by key.status desc, key.ID");
        this.queries.put("267", "SELECT DISTINCT key.ID, key.status from /exampleRegion.keys key order by key.status");
        this.queries.put("268", "SELECT DISTINCT key.ID, key.status from /exampleRegion.keys key order by key.status, key.ID desc");
        this.queries.put("269", "SELECT DISTINCT key.ID, key.status from /exampleRegion.keys key order by key.status, key.ID");
        this.queries.put("270", "SELECT DISTINCT name FROM /exampleRegion , secIds name where length > 0");
        this.queries.put("271", "SELECT DISTINCT p, pos from /exampleRegion p, p.positions.values pos order by p.ID");
        this.queries.put("272", "SELECT DISTINCT p, pos from /exampleRegion p, p.positions.values pos order by p.ID, pos.secId");
        this.queries.put("273", "SELECT DISTINCT p, pos from /exampleRegion p, p.positions.values pos order by pos.secId");
        this.queries.put("274", "SELECT DISTINCT p.getID() from /exampleRegion p order by p.getID()");
        this.queries.put("275", "SELECT DISTINCT p.ID from /exampleRegion p order by p.ID");
        this.queries.put("276", "SELECT DISTINCT p.ID, p.status from /exampleRegion p order by p.ID");
        this.queries.put("277", "SELECT DISTINCT p.ID from /exampleRegion p, p.positions.values order by p.ID");
        this.queries.put("278", "SELECT DISTINCT p.ID, p.position1.secId from /exampleRegion p order by p.position1.secId");
        this.queries.put("279", "SELECT DISTINCT p.ID, p.position1.secId from /exampleRegion p order by p.position1.secId, p.ID");
        this.queries.put("280", "SELECT DISTINCT p.ID, p.status from /exampleRegion p order by p.ID desc, p.status asc");
        this.queries.put("281", "SELECT DISTINCT p.ID, p.status from /exampleRegion p, p.positions.values order by p.status");
        this.queries.put("282", "SELECT DISTINCT p.ID, p.status from /exampleRegion p, p.positions.values order by p.status, p.ID");
        this.queries.put("283", "SELECT DISTINCT p.ID, pos.secId from /exampleRegion p, p.positions.values pos order by p.ID desc, pos.secId desc");
        this.queries.put("284", "SELECT DISTINCT p.ID, pos.secId from /exampleRegion p, p.positions.values pos order by p.ID desc, pos.secId");
        this.queries.put("285", "SELECT DISTINCT p.ID, pos.secId from /exampleRegion p, p.positions.values pos order by p.ID, pos.secId");
        this.queries.put("286", "SELECT DISTINCT p.ID, pos.secId from /exampleRegion p, p.positions.values pos order by pos.secId");
        this.queries.put("287", "SELECT DISTINCT p.ID, pos.secId from /exampleRegion p, p.positions.values pos order by pos.secId, p.ID");
        this.queries.put("288", "SELECT DISTINCT p.key, p.value FROM /exampleRegion.entrySet p  WHERE p.value.ID <= 10 order by p.value.createTime asc limit 1");
        this.queries.put("289", "SELECT DISTINCT p.key, p.value FROM /exampleRegion.entrySet p  WHERE p.value.ID <= 10 order by p.value.createTime desc limit 1");
        this.queries.put("290", "SELECT DISTINCT p.names[1] from /exampleRegion p order by p.names[1]");
        this.queries.put("291", "SELECT DISTINCT p.position1.secId, p.ID from /exampleRegion p order by p.position1.secId desc, p.ID");
        this.queries.put("292", "SELECT DISTINCT p.position1.secId, p.ID from /exampleRegion p order by p.position1.secId");
        this.queries.put("293", "SELECT DISTINCT p.status, p.ID from /exampleRegion p order by p.status asc, p.ID");
        this.queries.put("294", "SELECT DISTINCT p.status, p.ID from /exampleRegion p order by p.status");
        this.queries.put("295", "SELECT DISTINCT p.status, p.ID from /exampleRegion p order by p.status, p.ID");
        this.queries.put("296", "SELECT DISTINCT pf FROM /exampleRegion pf,  positions.values pos where pf.description = 'XXXX'  and pos.secId= 'IBM'");
        this.queries.put("297", "SELECT DISTINCT pos.secId FROM /exampleRegion er,  positions.values AS pos  WHERE er.ID > 0");
        this.queries.put("298", "SELECT DISTINCT pos.secId FROM /exampleRegion, pos IN positions.values  WHERE pos.ID > 0");
        this.queries.put("299", "SELECT DISTINCT pos.secId from /exampleRegion p, p.positions.values pos order by pos.secId");
        this.queries.put("300", "SELECT DISTINCT s.name, s.getDistricts(), ct.getName() FROM /exampleRegion c, c.getStates() s, s.getDistricts() d, d.getCities() ct WHERE ct.getName() = 'PUNE' OR ct.name = 'CHANDIGARH' OR s.getName() = 'GUJARAT'");
        this.queries.put("301", "SELECT DISTINCT status, ID from /exampleRegion order by status");
        this.queries.put("302", "SELECT DISTINCT status, ID from /exampleRegion order by status, ID");
        this.queries.put("303", "SELECT ID FROM /exampleRegion pf WHERE pf.ID = 1");
        this.queries.put("304", "SELECT ID FROM /exampleRegion pf WHERE pf.ID > 10");
        this.queries.put("305", "SELECT ID FROM /exampleRegion pf WHERE pf.ID > 5");
        this.queries.put("306", "SELECT ID FROM /exampleRegion.keys key WHERE key.ID = 1");
        this.queries.put("307", "SELECT ID FROM /exampleRegion.keys key WHERE key.ID > 5");
        this.queries.put("308", "SELECT k.ID, k.status FROM /exampleRegion.keys k WHERE k.ID = 1 and k.status = 'active'");
        this.queries.put("309", "SELECT key.ID FROM /exampleRegion.keys key WHERE key.ID > 5 and key.status = 'active'");
        this.queries.put("310", "SELECT pkid FROM /exampleRegion ps WHERE ps.pkid = 'abc'");
        this.queries.put("311", "Select * from /exampleRegion pf where pf.ID < 2");
        this.queries.put("312", "Select * from /exampleRegion pf where pf.ID = 2");
        this.queries.put("313", "Select * from /exampleRegion pf where pf.ID > 1");
        this.queries.put("314", "Select * from /exampleRegion pf where pf.position1.secId > '2'");
        this.queries.put("315", "Select * from /exampleRegion.keys key where key.ID = 2");
        this.queries.put("316", "Select distinct  * from /exampleRegion.keySet keys where keys = '4'");
        this.queries.put("317", "Select distinct  security from /exampleRegion  pos , secIds security where length > 2 and pos.ID > 0");
        this.queries.put("318", "Select distinct * from /exampleRegion e, /exampleRegion a, e.getPhoneNo(a.zipCode) ea where e.name ='empName'");
        this.queries.put("319", "Select distinct * from /exampleRegion pf where pf.getID() = -1");
        this.queries.put("320", "Select distinct * from /exampleRegion pf where pf.getID() = -2147483648");
        this.queries.put("321", "Select distinct * from /exampleRegion pf where pf.getID() = 3 and pf.getDoubleMinValue() = 4.9E-324");
        this.queries.put("322", "Select distinct * from /exampleRegion pf where pf.getID() = 3 and pf.getFloatMinValue() = 1.4E-45f");
        this.queries.put("323", "Select distinct * from /exampleRegion pf where pf.getID() = 3 and pf.getLongMinValue() = -9223372036854775808l");
        this.queries.put("324", "Select distinct * from /exampleRegion pf, /exampleRegion e  where e.name ='empName' and pf.status='active'");
        this.queries.put("325", "Select distinct * from /exampleRegion pf, /exampleRegion e  where e.name ='empName'");
        this.queries.put("326", "Select distinct * from /exampleRegion pf, pf.positions.values pos where pf.status = 'active' and pos.secId = 'IBM'");
        this.queries.put("327", "Select distinct * from /exampleRegion pf,/exampleRegion e  where pf.status='active'");
        this.queries.put("328", "Select distinct * from /exampleRegion pf1 where pf1.getID() > 3");
        this.queries.put("329", "Select distinct * from /exampleRegion pf1 where pf1.pkid > '3'");
        this.queries.put("330", "Select distinct * from /exampleRegion, /exampleRegion");
        this.queries.put("331", "Select distinct * from /exampleRegion.entrySet pf where pf.value.getID() = 4");
        this.queries.put("332", "Select distinct e.value.secId from /exampleRegion, getPositions(23) e");
        this.queries.put("333", "Select distinct ID from /exampleRegion");
        this.queries.put("334", "Select distinct p from /exampleRegion p order by p");
        this.queries.put("335", "Select distinct pf from /exampleRegion pf , pf.positions.values ps where ps.secId='SUN'");
        this.queries.put("336", "Select distinct security from /exampleRegion , secIds security where security.length > 2 AND (security.intern <> 'SUN' AND security.intern <> 'DELL' )");
        this.queries.put("337", "Select distinct security  from /exampleRegion, secIds security where security.length > 1");
        this.queries.put("338", "Select distinct pos.secId from /exampleRegion , getPositions(23) pos");
        this.queries.put("339", "Select distinct pos.secId from /exampleRegion, positions pos");
        this.queries.put("340", "Select p.get('acc') from /exampleRegion p");
        this.queries.put("341", "Select p.get('account') from /exampleRegion p");
        this.queries.put("342", "Select p.shortID from /exampleRegion p where p.shortID < 5");
        this.queries.put("343", "Select pf.ID from /exampleRegion pf where pf.ID > 2 and pf.ID < 100");
        this.queries.put("344", "Select status from /exampleRegion pf where status='active'");
        this.queries.put("345", "'a' IN SET('x','y','z')");
        this.queries.put("346", "import org.apache.geode.cache.\"query\".data.Portfolio; select distinct * from /exampleRegion, (select distinct * from /exampleRegion p TYPE Portfolio, p.positions where value!=null)");
        this.queries.put("347", "import org.apache.geode.cache.\"query\".data.Position;select distinct value.secId from /exampleRegion, (map<string, Position>)getPositions(23)");
        this.queries.put("348", "select  * from /exampleRegion pf where pf.getID  > 1 and pf.getID < 12000");
        this.queries.put("349", "select  * from /exampleRegion pf where pf.status != 'active' and pf.status != null");
        this.queries.put("350", "select  distinct p.status  from /exampleRegion p  where   p.ID IN  SET( 0) AND p.createTime IN SET( 4l ) AND  p.\"type\" IN SET( 'type0') AND p.status IN SET( 'active')");
        this.queries.put("351", "select  distinct p.status  from /exampleRegion p  where  (p.createTime IN SET( 10l ) OR  p.status IN SET( 'active') )AND  p.ID >  0 AND  p.createTime = 10l");
        this.queries.put("352", "select  distinct p.status  from /exampleRegion p  where  (p.createTime IN SET( 10l ) OR  p.status IN SET( 'active') )AND  p.ID >  0");
        this.queries.put("353", "select  distinct p.status  from /exampleRegion p  where  p.createTime = 10l AND  p.status IN SET( 'active') AND  true");
        this.queries.put("354", "select  distinct p.status  from /exampleRegion p  where  p.createTime > 0 AND p.createTime <11 AND  p.ID IN  SET( 0)");
        this.queries.put("355", "select  distinct p.status  from /exampleRegion p  where  p.ID = 11 AND   p.createTime IN  SET( 10L)");
        this.queries.put("356", "select  distinct p.status  from /exampleRegion p  where  p.ID > 11 AND  p.ID < 19 and  p.createTime IN  SET( 10L)");
        this.queries.put("357", "select  distinct p.status  from /exampleRegion p  where  p.ID > 11 AND  p.ID < 20 AND  p.createTime <>9L");
        this.queries.put("358", "select  distinct p.status  from /exampleRegion p  where  true");
        this.queries.put("359", "select  p.status as sts, p as pos from /exampleRegion p  where  p.ID IN  ( Select x.ID from /exampleRegion x where x.ID > 10)");
        this.queries.put("360", "select  p.status as sts, p as pos from /exampleRegion p  where  p.ID IN  SET( 0,1,2,3,4,5)");
        this.queries.put("361", "select  p.status as sts, p as pos from /exampleRegion p  where  p.ID IN  SET( 0,1,2,3,4,5,101,102,103,104,105) AND p.createTime > 9l");
        this.queries.put("362", "select  p.status as sts, p as pos from /exampleRegion p  where ( p.ID IN  SET( 0,1,2,3) and p.createTime > 0L) OR (p.ID IN  SET( 2,3) and p.createTime > 5L)");
        this.queries.put("363", "select  p.status as sts, p as pos from /exampleRegion p  where p.ID > 0 and p.createTime > 0");
        this.queries.put("364", "select  p.status as sts, p as pos from /exampleRegion p  where p.ID IN  SET( 0,1,2,3) and p.createTime > 0");
        this.queries.put("365", "select  p.status from /exampleRegion p  where p.ID > 0 and p.createTime > 0");
        this.queries.put("366", "select  p.status from /exampleRegion p where p.ID > 0");
        this.queries.put("367", "select  p.status from /exampleRegion p, p.positions pos where p.ID > 0");
        this.queries.put("368", "select * from /exampleRegion p where NOT (p.ID IN SET(1, 2))");
        this.queries.put("369", "select * from /exampleRegion sf where sf.shortField < 10");
        this.queries.put("370", "select * from /exampleRegion this where FALSE");
        this.queries.put("371", "select * from /exampleRegion this where NOT isActive");
        this.queries.put("372", "select * from /exampleRegion this where NULL");
        this.queries.put("373", "select * from /exampleRegion this where P1.secId = 'SUN'");
        this.queries.put("374", "select * from /exampleRegion this where TRUE");
        this.queries.put("375", "select * from /exampleRegion this where UNDEFINED");
        this.queries.put("376", "select * from /exampleRegion this where ID < 1");
        this.queries.put("377", "select * from /exampleRegion this where ID < 5");
        this.queries.put("378", "select * from /exampleRegion this where ID <= 1");
        this.queries.put("379", "select * from /exampleRegion this where ID <= 5");
        this.queries.put("380", "select * from /exampleRegion this where ID = 0 OR ID = 1");
        this.queries.put("381", "select * from /exampleRegion this where ID = 5");
        this.queries.put("382", "select * from /exampleRegion this where ID > 2");
        this.queries.put("383", "select * from /exampleRegion this where ID > 4 AND ID < 9");
        this.queries.put("384", "select * from /exampleRegion this where ID > 5 and ID <=15");
        this.queries.put("385", "select * from /exampleRegion this where ID >= 2");
        this.queries.put("386", "select * from /exampleRegion this where isActive");
        this.queries.put("387", "select * from /exampleRegion this where isActive()");
        this.queries.put("388", "select * from /exampleRegion this where pk = '2'");
        this.queries.put("389", "select * from /exampleRegion this where pk = '7'");
        this.queries.put("390", "select * from /exampleRegion this where status <> 'active'");
        this.queries.put("391", "select * from /exampleRegion this where status = 'active' AND ( ID = 1 OR P1.secId = 'SUN')");
        this.queries.put("392", "select * from /exampleRegion this where status = 'active' AND ID = 0");
        this.queries.put("393", "select * from /exampleRegion this where status = 'active' AND ID = 1");
        this.queries.put("394", "select * from /exampleRegion this where status = 'active' OR ID = 1");
        this.queries.put("395", "select * from /exampleRegion this where status = 'active'");
        this.queries.put("396", "select * from /exampleRegion this where testMethod(true)");
        this.queries.put("397", "select * from /exampleRegion this where this = 'value'");
        this.queries.put("398", "select * from /exampleRegion this where toString()='doOpDuringBucketRemove.VALUE'");
        this.queries.put("399", "select * from /exampleRegion where 3 >= length");
        this.queries.put("400", "select * from /exampleRegion where age < 50");
        this.queries.put("401", "select * from /exampleRegion where intVar = 0");
        this.queries.put("402", "select * from /exampleRegion.entries sf where sf.value.shortField < 10");
        this.queries.put("403", "select ALL * from /exampleRegion where 3 >= length");
        this.queries.put("404", "select distinct  key.status as st from /exampleRegion key where key.ID > 5 order by key.status");
        this.queries.put("405", "select distinct  p.position1.secId  as st from /exampleRegion p order by p.position1.secId");
        this.queries.put("406", "select distinct  p.status, p.ID from /exampleRegion p order by p.status");
        this.queries.put("407", "select distinct  status, ID from /exampleRegion order by status");
        this.queries.put("408", "select distinct 'a' from /exampleRegion p");
        this.queries.put("409", "select distinct 'a',1, p from /exampleRegion p");
        this.queries.put("410", "select distinct 'a',1, p from UNDEFINED");
        this.queries.put("411", "select distinct 'a',1, p from null");
        this.queries.put("412", "select distinct * from /exampleRegion a, /exampleRegion p, /exampleRegion e, a.street s  where s.street ='DPStreet1'");
        this.queries.put("413", "select distinct * from /exampleRegion a, /exampleRegion p, /exampleRegion e, a.street s where p.status='active' and s.street ='DPStreet1'");
        this.queries.put("414", "select distinct * from /exampleRegion itr1,itr1.phoneNo itr2,itr1.street itr3 where itr2.mobile>333");
        this.queries.put("415", "select distinct * from /exampleRegion itr1,itr1.street itr2,itr1.phoneNo itr3 where itr3.mobile>333");
        this.queries.put("416", "select distinct * from /exampleRegion p order by p.getID()");
        this.queries.put("417", "select distinct * from /exampleRegion p order by p.getP1().secId");
        this.queries.put("418", "select distinct * from /exampleRegion p order by status, ID desc");
        this.queries.put("419", "select distinct * from /exampleRegion p where p.ID > 1   and  p.ID < 3");
        this.queries.put("420", "select distinct * from /exampleRegion p");
        this.queries.put("421", "select distinct * from /exampleRegion p, /exampleRegion e  where p.pkid = '1'");
        this.queries.put("422", "select distinct * from /exampleRegion p, /exampleRegion e");
        this.queries.put("423", "select distinct * from /exampleRegion p, /exampleRegion e, /exampleRegion a, a.street s where s.street ='DPStreet1'");
        this.queries.put("424", "select distinct * from /exampleRegion p, /exampleRegion p1 where p.position1.Id = p1.position1.Id and p1.position1.secId in set('MSFT')");
        this.queries.put("425", "select distinct * from /exampleRegion p, p.positions where p.ID = 1");
        this.queries.put("426", "select distinct * from /exampleRegion p, p.positions,/exampleRegion e where p.ID =  e.empId");
        this.queries.put("427", "select distinct * from /exampleRegion p, p.positions,/exampleRegion e, /exampleRegion p1 where p.ID = 1 and p1.ID = 2 and e.empId = 1");
        this.queries.put("428", "select distinct * from /exampleRegion p, p.positions,/exampleRegion e, /exampleRegion p1 where p.ID =p1.ID   and e.empId = 1 and p1.status = 'active' and p.status='active'");
        this.queries.put("429", "select distinct * from /exampleRegion p, p.positions,/exampleRegion e, /exampleRegion p1 where p.ID =p1.ID   and e.empId = p1.ID");
        this.queries.put("430", "select distinct * from /exampleRegion p, p.positions.values order by p.ID");
        this.queries.put("431", "select distinct * from /exampleRegion p, p.positions.values val order by p.ID, val.secId desc");
        this.queries.put("432", "select distinct * from /exampleRegion p, p.positions.values where p.ID < 3");
        this.queries.put("433", "select distinct * from /exampleRegion p, p.positions.values where p.pkid != '53'");
        this.queries.put("434", "select distinct * from /exampleRegion pf where false and ID = 0");
        this.queries.put("435", "select distinct * from /exampleRegion pf where ID = 0 or false");
        this.queries.put("436", "select distinct * from /exampleRegion pf where nvl(pf.position2, pf.position1).secId = 'SUN'");
        this.queries.put("437", "select distinct * from /exampleRegion pf where nvl(pf.position2,'foundNull') = 'foundNull'");
        this.queries.put("438", "select distinct * from /exampleRegion pf where true and ID = 0");
        this.queries.put("439", "select distinct * from /exampleRegion pf where true or ID = 0");
        this.queries.put("440", "select distinct * from /exampleRegion pf, positions.values pos  where  (pf.ID > 1 or pf.status = 'active') or (false AND pos.secId ='IBM')");
        this.queries.put("441", "select distinct * from /exampleRegion pf, positions.values pos  where true = true and pf.ID > 1 and pos.secId ='IBM'");
        this.queries.put("442", "select distinct * from /exampleRegion pf, positions.values pos where  (pf.ID > 1 or pf.status = 'active') or (true AND pos.secId ='IBM')");
        this.queries.put("443", "select distinct * from /exampleRegion pf, positions.values pos where  (true AND pos.secId ='SUN') or (pf.ID > 1 and pf.status != 'active')");
        this.queries.put("444", "select distinct * from /exampleRegion pf, positions.values pos where (ID = 2 or false) or (pf.status = 'active' and (pos.secId != 'IBM' or true))");
        this.queries.put("445", "select distinct * from /exampleRegion pf, positions.values pos where (pf.ID < 1 and pf.status = 'active') and (false or pos.secId = 'IBM')");
        this.queries.put("446", "select distinct * from /exampleRegion pf, positions.values pos where false and pos.secId ='IBM'");
        this.queries.put("447", "select distinct * from /exampleRegion pf, positions.values pos where true = false and pf.ID > 1 and pos.secId ='IBM'");
        this.queries.put("448", "select distinct * from /exampleRegion pf, positions.values pos where true = true and pf.ID > 1 or pos.secId ='IBM'");
        this.queries.put("449", "select distinct * from /exampleRegion pf, positions.values pos where true = true and pos.secId ='IBM'");
        this.queries.put("450", "select distinct * from /exampleRegion s  where 3 >= s.length");
        this.queries.put("451", "select distinct * from /exampleRegion where 3 >= length");
        this.queries.put("452", "select distinct * from /exampleRegion where NOT isActive");
        this.queries.put("453", "select distinct * from /exampleRegion where ID != 53");
        this.queries.put("454", "select distinct * from /exampleRegion where ID < 1");
        this.queries.put("455", "select distinct * from /exampleRegion where ID >= 2");
        this.queries.put("456", "select distinct * from /exampleRegion where isActive");
        this.queries.put("457", "select distinct * from /exampleRegion where isActive()");
        this.queries.put("458", "select distinct * from /exampleRegion where status <> 'active'");
        this.queries.put("459", "select distinct * from /exampleRegion where status = 'active' AND ( ID = 1 OR P1.secId = 'SUN')");
        this.queries.put("460", "select distinct * from /exampleRegion where status = 'active' AND ID = 0");
        this.queries.put("461", "select distinct * from /exampleRegion where status = 'active' AND ID = 1");
        this.queries.put("462", "select distinct * from /exampleRegion where status = 'active' OR ID = 1");
        this.queries.put("463", "select distinct * from /exampleRegion where status = 'active'");
        this.queries.put("464", "select distinct * from /exampleRegion where testMethod(true)");
        this.queries.put("465", "select distinct * from /exampleRegion x, x.positions.values where x.pk = '1'");
        this.queries.put("466", "select distinct * from /exampleRegion x, x.positions.values where x.pkid = '1'");
        this.queries.put("467", "select distinct * from /exampleRegion");
        this.queries.put("468", "select distinct * from /exampleRegion.entries where key = '1'");
        this.queries.put("469", "select distinct * from /exampleRegion.entries where value.ID = 1 and key = '1'");
        this.queries.put("470", "select distinct * from /exampleRegion.entries where value.status = 'active'");
        this.queries.put("471", "select distinct * from /exampleRegion.entries x, x.value.positions.values where x.key = '1'");
        this.queries.put("472", "select distinct * from /exampleRegion.entries x, x.value.positions.values where x.value.pkid = '1'");
        this.queries.put("473", "select distinct * from /exampleRegion.keySet where toString = '1'");
        this.queries.put("474", "select distinct * from /exampleRegion.keys where toString = '1'");
        this.queries.put("475", "select distinct * from /exampleRegion.values where ID = 1");
        this.queries.put("476", "select distinct * from /exampleRegion.values where status = 'active'");
        this.queries.put("477", "select distinct * from null");
        this.queries.put("478", "select distinct 1 from /exampleRegion p");
        this.queries.put("479", "select distinct 1 from UNDEFINED");
        this.queries.put("480", "select distinct 1 from null");
        this.queries.put("481", "select distinct e.key from /exampleRegion.entrySet e order by e.key.ID desc, e.key.pkid desc");
        this.queries.put("482", "select distinct e.key, e.value from /exampleRegion.entrySet e order by e.key.ID, e.value.status desc");
        this.queries.put("483", "select distinct e.key.ID from /exampleRegion.entries e order by e.key.ID");
        this.queries.put("484", "select distinct e.key.ID, e.value.status from /exampleRegion.entries e order by e.key.ID");
        this.queries.put("485", "select distinct e.key.ID, e.value.status from /exampleRegion.entrySet e order by e.key.ID desc , e.value.status desc");
        this.queries.put("486", "select distinct getID, status from /exampleRegion pf where getID < 10 order by getID asc");
        this.queries.put("487", "select distinct getID, status from /exampleRegion pf where getID < 10 order by getID desc");
        this.queries.put("488", "select distinct iD, status from /exampleRegion order by iD");
        this.queries.put("489", "select distinct key from /exampleRegion.entrySet , value.positions.values   where value.ID = 1 and key = '1'");
        this.queries.put("490", "select distinct key.ID from /exampleRegion.keys key order by key.ID");
        this.queries.put("491", "select distinct key.ID, key.status from /exampleRegion.keys key order by key.status desc, key.ID");
        this.queries.put("492", "select distinct key.ID, key.status from /exampleRegion.keys key order by key.status, key.ID desc");
        this.queries.put("493", "select distinct key.ID, key.status from /exampleRegion.keys key order by key.status, key.ID");
        this.queries.put("494", "select distinct key.ID,key.status as st from /exampleRegion key where key.status = 'inactive' order by key.status desc, key.ID");
        this.queries.put("495", "select distinct nm from /exampleRegion prt,names nm where prt.ID>0");
        this.queries.put("496", "select distinct nvl(pf.position2, 'inProjection') from /exampleRegion pf where nvl(pf.position2, pf.position1).secId = 'SUN'");
        this.queries.put("497", "select distinct nvl(pf.position2, 'inProjection') from /exampleRegion pf where nvl(pf.position2,'foundNull') = 'foundNull'");
        this.queries.put("498", "select distinct p from /exampleRegion p where p.ID > 0");
        this.queries.put("499", "select distinct p, pos from /exampleRegion p, p.positions.values pos order by p.ID");
        this.queries.put("500", "select distinct p.ID, pos.secId from /exampleRegion p, p.positions.values pos order by pos.secId, p.ID");
        this.queries.put("501", "select distinct p.names[1] from /exampleRegion p order by p.names[1]");
        this.queries.put("502", "select distinct p.position1.secId as st from /exampleRegion p where p.ID > 0 and p.position1.secId != 'IBM' order by p.position1.secId");
        this.queries.put("503", "select distinct p.position1.secId, p.ID from /exampleRegion p order by p.position1.secId");
        this.queries.put("504", "select distinct p.status as STATUS, SECID: p.P1.SecId, ID from /exampleRegion p ");
        this.queries.put("505", "select distinct p.status as st from /exampleRegion p where ID > 0 and status = 'inactive' order by p.status");
        this.queries.put("506", "select distinct p.status from /exampleRegion p order by p.status");
        this.queries.put("507", "select distinct p.status from /exampleRegion p where p.ID > 0");
        this.queries.put("508", "select distinct p.status, p.ID from /exampleRegion p order by p.status asc, p.ID");
        this.queries.put("509", "select distinct p.status, p.ID from /exampleRegion p order by p.status, p.ID");
        this.queries.put("510", "select distinct p.status,p.ID from /exampleRegion p where p.ID > 0");
        this.queries.put("511", "select distinct portfolio: p ,p.P1.SecId from /exampleRegion p where p.ID > 0 ");
        this.queries.put("512", "select distinct pos.secId from /exampleRegion p, p.positions.values pos order by pos.secId");
        this.queries.put("513", "select distinct positions.values.toArray[0], positions.values.toArray[0],status from /exampleRegion");
        this.queries.put("514", "select distinct prt from /exampleRegion prt, names where prt.names[3]='ddd'");
        this.queries.put("515", "select distinct status as st from /exampleRegion where ID > 0 order by status");
        this.queries.put("516", "select distinct status from /exampleRegion where ID > 0 order by status");
        this.queries.put("517", "select distinct status, getID from /exampleRegion pf where getID < 10 order by status asc, getID desc");
        this.queries.put("518", "select distinct status, ID from /exampleRegion order by status, ID");
        this.queries.put("519", "SELECT * FROM /exampleRegion WHERE \"type\" = 'type1'");
        this.queries.put("520", "select count(*) from /exampleRegion");
        this.queries.put("521", "SELECT * from /exampleRegion P1, P1.positions.values WHERE P1.ID = 5");
        this.queries.put("522", "SELECT * from /exampleRegion P1, /exampleRegion2 P2 WHERE P1.ID = 5");
        this.queries.put("523", "SELECT * from /numericRegion n WHERE n.max1 = 50");
        this.queries.put("524", "SELECT * from /numericRegion n WHERE n.max1 = 50.0");
        this.queries.put("525", "SELECT * from /numericRegion n WHERE n.max1 = 50.0f");
        this.queries.put("526", "SELECT * from /numericRegion n WHERE n.max1 = 50.0d");
        this.queries.put("527", "SELECT * from /numericRegion n WHERE n.max1 > 50");
        this.queries.put("528", "SELECT * from /numericRegion n WHERE n.max1 > 50.0");
        this.queries.put("529", "SELECT * from /numericRegion n WHERE n.max1 > 50.0f");
        this.queries.put("530", "SELECT * from /numericRegion n WHERE n.max1 > 50.0d");
        this.queries.put("531", "SELECT * from /numericRegion n WHERE n.max1 < 50");
        this.queries.put("532", "SELECT * from /numericRegion n WHERE n.max1 < 50.0");
        this.queries.put("533", "SELECT * from /numericRegion n WHERE n.max1 < 50.0f");
        this.queries.put("534", "SELECT * from /numericRegion n WHERE n.max1 < 50.0d");
        this.queries.put("535", "SELECT * from /numericRegion n WHERE n.max1 <= 50");
        this.queries.put("536", "SELECT * from /numericRegion n WHERE n.max1 <= 50.0");
        this.queries.put("537", "SELECT * from /numericRegion n WHERE n.max1 <= 50.0f");
        this.queries.put("538", "SELECT * from /numericRegion n WHERE n.max1 <= 50.0d");
        this.queries.put("539", "SELECT * from /numericRegion n WHERE n.max1 >= 50");
        this.queries.put("540", "SELECT * from /numericRegion n WHERE n.max1 >= 50.0");
        this.queries.put("541", "SELECT * from /numericRegion n WHERE n.max1 >= 50.0f");
        this.queries.put("542", "SELECT * from /numericRegion n WHERE n.max1 >= 50.0d");
        this.queries.put("543", "select distinct * from /portfolios p where p.ID > -1 order by p.ID");
        this.queries.put("544", "select distinct * from /portfolios p where p.ID > -1 order by p.ID limit 100");
        this.queries.put("545", "select distinct * from /portfolios p where p.ID > -1");
        this.queries.put("546", "select distinct * from /portfolios p where p.ID > -1 limit 100");
        this.queries.put("701", "SELECT ID, status FROM /exampleRegion portfolio WHERE NOT (SELECT DISTINCT * FROM portfolio.positions.values positions WHERE positions.secId='AOL' OR positions.secId='SAP').isEmpty");
        this.queries.put("702", "SELECT * FROM /exampleRegion p where p.status = ELEMENT(SELECT DISTINCT * FROM /exampleRegion p2 WHERE p2.ID = 0).status");
        this.queries.put("703", "IMPORT org.apache.geode.cache.\"query\".data.Portfolio; SELECT * FROM /exampleRegion, (SELECT DISTINCT * from /exampleRegion p TYPE Portfolio, p.positions WHERE value!=null)");
        this.queries.put("704", "SELECT DISTINCT * FROM (SELECT DISTINCT * FROM /exampleRegion portfolios, positions pos) WHERE pos.value.secId = 'IBM'");
        this.queries.put("705", "SELECT * FROM /exampleRegion portfolio WHERE portfolio.ID IN (SELECT p2.ID  FROM /exampleRegion2 p2 where p2.ID > 1)");
        this.queries.put("706", "SELECT * FROM /root/exampleRegion p where NOT(SELECT DISTINCT * FROM positions.values pos  WHERE pos.secId in SET('YHOO', 'SUN', 'IBM', 'YHOO', 'GOOG',  'MSFT', 'AOL', 'APPL', 'ORCL', 'SAP', 'DELL', 'RHAT', 'NOVL', 'HP')).isEmpty");
        this.queries.put("707", "SELECT DISTINCT * FROM /exampleRegion pf, (SELECT DISTINCT * FROM /exampleRegion ptf, ptf.positions pos where pf.ID != 1 and pos.value.sharesOutstanding > 2000) as x WHERE x.secId = 'IBM'");
        this.queries.put("708", "SELECT DISTINCT * FROM /exampleRegion pf, (SELECT DISTINCT * FROM /exampleRegion ptf, ptf.positions pos where pf.ID != 1 and pos.value.sharesOutstanding > 2000)as y WHERE y.value.secId = 'HP'");
        this.queries.put("709", "SELECT DISTINCT * FROM /exampleRegion where NOT(SELECT DISTINCT * FROM /exampleRegion p where p.ID = 0).isEmpty");
        this.queries.put("710", "SELECT DISTINCT * FROM /root/exampleRegion p, (SELECT DISTINCT pos FROM /root/exampleRegion x, x.positions.values pos WHERE  x.ID = p.ID) as itrX");
        this.queries.put("711", "SELECT DISTINCT * FROM /root/exampleRegion p, p.positions.values outerPos, (SELECT DISTINCT key from /exampleRegion.keys key)");
        this.queries.put("712", "SELECT DISTINCT c.name, s.name, ct.name FROM /exampleRegion c, c.states s, (SELECT DISTINCT * FROM /exampleRegion c, c.states s, s.districts d, d.cities ct WHERE s.name = 'PUNJAB') itr1, s.districts d, d.cities ct WHERE ct.name = 'CHANDIGARH'");
        this.queries.put("713", "SELECT DISTINCT c.name, s.name, ct.name FROM /exampleRegion c, c.states s, s.districts d, d.cities ct WHERE ct.name = element (SELECT DISTINCT ct.name FROM /exampleRegion c, c.states s, s.districts d, d.cities ct WHERE s.name = 'MAHARASHTRA' AND ct.name = 'PUNE')");
        this.queries.put("714", "SELECT DISTINCT c1.name, s1.name, ct1.name FROM /exampleRegion c1, c1.states s1, (SELECT DISTINCT * FROM /exampleRegion2 c2, c2.states s2, s2.districts d2, d2.cities ct2 WHERE s2.name = 'PUNJAB') itr1, s1.districts d1, d1.cities ct1 WHERE ct1.name = 'CHANDIGARH'");
        this.queries.put("715", "SELECT DISTINCT c1.name, s1.name, ct1.name FROM /exampleRegion c1, c1.states s1, s1.districts d1, d1.cities ct1 WHERE ct1.name = element (SELECT DISTINCT ct3.name FROM /exampleRegion3 c3, c3.states s3, s3.districts d3, d3.cities ct3 WHERE s3.name = 'MAHARASHTRA' AND ct3.name = 'PUNE')");
        this.queries.put("716", "Select distinct * from /exampleRegion pfos, pfos.positions.values outerPos, (SELECT DISTINCT key");
        this.queries.put("717", "Select distinct structset.sos, structset.key from /exampleRegion pfos, pfos.positions.values outerPos, (SELECT DISTINCT key: key, sos: pos.sharesOutstanding from /exampleRegion.entries pf, pf.value.positions.values pos where outerPos.secId != 'IBM' AND pf.key IN (select distinct * from pf.value.collectionHolderMap['0'].arr)) structset where structset.sos > 2000");
        this.queries.put("718", "select  DISTINCT * from  ( SELECT   DISTINCT p.ID as portfolio_id, pos.secId as sec_id from /exampleRegion p , p.positions.values pos where p.status= 'active')");
        this.queries.put("719", "select distinct * from /exampleRegion p, (select distinct pos  as poos from /exampleRegion x, x.positions.values pos where pos.secId = 'YHOO') as k");
        this.queries.put("720", "select distinct * from /exampleRegion p, (select distinct pos as poos from /exampleRegion x, p.positions.values pos where x.ID = p.ID) as k");
        this.queries.put("721", "select distinct * from /exampleRegion p, (select distinct val from positions.values as val where val.secId = 'YHOO') as k");
        this.queries.put("722", "select distinct * from /exampleRegion p, (select distinct x as pf , myPos as poos from /exampleRegion x, x.positions.values as myPos) as k   where k.poos.secId = 'YHOO'");
        this.queries.put("723", "select distinct * from /exampleRegion p, (select distinct x.ID as ID  from /exampleRegion x where x.ID = p.ID) as k");
        this.queries.put("800", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.status like  '%'");
        this.queries.put("801", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.status like  'a%bc%'");
        this.queries.put("802", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.status like  'abc%' AND ps.ID > 2 AND ps.ID < 150");
        this.queries.put("803", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.status like  'abc%' OR ps.ID > 6");
        this.queries.put("804", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.status like  'abc%'");
        this.queries.put("805", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.status like  'abcd'");
        this.queries.put("806", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.status like  'abcd\\%'");
        this.queries.put("807", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.status like  'abcd\\_'");
        this.queries.put("808", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.status like 'a_bc'");
        this.queries.put("809", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.status like 'abc_'");
        this.queries.put("810", "SELECT pkid FROM /exampleRegion ps WHERE ps.pkid like '%b%' and ps.pkid like '_bc'");
        this.queries.put("811", "SELECT pkid FROM /exampleRegion ps WHERE ps.pkid like '%b%' and ps.status = 'like'");
        this.queries.put("812", "SELECT pkid FROM /exampleRegion ps WHERE ps.pkid like '%b%' and ps.status like '%ike'");
        this.queries.put("813", "SELECT pkid FROM /exampleRegion ps WHERE ps.pkid like 'abc%'");
        this.queries.put("814", "SELECT pkid FROM /exampleRegion ps WHERE ps.pkid like 'ml%' or ps.status = 'like'");
        this.queries.put("815", "select p from /exampleRegion.values p where p like '%%ti%'");
        this.queries.put("816", "select p from /exampleRegion.values p where p like '%'");
        this.queries.put("817", "select p from /exampleRegion.values p where p like '%c%iv%'");
        this.queries.put("818", "select p from /exampleRegion.values p where p like '%ctiv%'");
        this.queries.put("819", "select p from /exampleRegion.values p where p like '%ctive'");
        this.queries.put("820", "select p from /exampleRegion.values p where p like '1inact\\_+ive'");
        this.queries.put("821", "select p from /exampleRegion.values p where p like '?act?ve'");
        this.queries.put("822", "select p from /exampleRegion.values p where p like 'X%X'");
        this.queries.put("823", "select p from /exampleRegion.values p where p like 'X__X'");
        this.queries.put("824", "select p from /exampleRegion.values p where p like 'Y\\%Y'");
        this.queries.put("825", "select p from /exampleRegion.values p where p like 'Z\\\\%Z'");
        this.queries.put("826", "select p from /exampleRegion.values p where p like '^+act.ve+^'");
        this.queries.put("827", "select p from /exampleRegion.values p where p like '__tive'");
        this.queries.put("828", "select p from /exampleRegion.values p where p like '_c_iv_'");
        this.queries.put("829", "select p from /exampleRegion.values p where p like '_ctiv%'");
        this.queries.put("830", "select p from /exampleRegion.values p where p like '_ctive'");
        this.queries.put("831", "select p from /exampleRegion.values p where p like 'a%e'");
        this.queries.put("832", "select p from /exampleRegion.values p where p like 'a%iv_'");
        this.queries.put("833", "select p from /exampleRegion.values p where p like 'a_tiv%'");
        this.queries.put("834", "select p from /exampleRegion.values p where p like 'ac%'");
        this.queries.put("835", "select p from /exampleRegion.values p where p like 'ac(tiv)e'");
        this.queries.put("836", "select p from /exampleRegion.values p where p like 'ac+t+ve'");
        this.queries.put("837", "select p from /exampleRegion.values p where p like 'ac\\%'");
        this.queries.put("838", "select p from /exampleRegion.values p where p like 'ac\\tive'");
        this.queries.put("839", "select p from /exampleRegion.values p where p like 'ac_ive'");
        this.queries.put("840", "select p from /exampleRegion.values p where p like 'ac_tive'");
        this.queries.put("841", "select p from /exampleRegion.values p where p like 'act%%ve'");
        this.queries.put("842", "select p from /exampleRegion.values p where p like 'act()ive'");
        this.queries.put("843", "select p from /exampleRegion.values p where p like 'act)ve^'");
        this.queries.put("844", "select p from /exampleRegion.values p where p like 'act**ve'");
        this.queries.put("845", "select p from /exampleRegion.values p where p like 'act*+|ve'");
        this.queries.put("846", "select p from /exampleRegion.values p where p like 'act/exampleRegion'");
        this.queries.put("847", "select p from /exampleRegion.values p where p like 'act[]ve'");
        this.queries.put("848", "select p from /exampleRegion.values p where p like 'act][ve'");
        this.queries.put("849", "select p from /exampleRegion.values p where p like 'act^[a-z]ve'");
        this.queries.put("850", "select p from /exampleRegion.values p where p like 'act__e'");
        this.queries.put("851", "select p from /exampleRegion.values p where p like 'activ_'");
        this.queries.put("852", "select p from /exampleRegion.values p where p like 'active'");
        this.queries.put("853", "select p from /exampleRegion.values p where p like 'acxtxve'");
        this.queries.put("854", "select p from /exampleRegion.values p where p like 'inact\\%+ive'");
        this.queries.put("855", "select p from /exampleRegion.values p where p like 'inactive'");
        this.queries.put("856", "select p from /exampleRegion.values p where p like '|+act(ve'");
        this.queries.put("857", "SELECT  *  FROM /exampleRegion ps WHERE ps.status like '%b%' and ps.pkid = '1'");
        this.queries.put("858", "SELECT  *  FROM /exampleRegion ps WHERE ps.status like '%b%' or ps.ID > 0");
        this.queries.put("859", "SELECT  *  FROM /exampleRegion ps WHERE ps.status like '%b%' or ps.pkid = '2'");
        this.queries.put("860", "SELECT  *  FROM /exampleRegion ps WHERE ps.status like '%b%'");
        this.queries.put("861", "SELECT  *  FROM /exampleRegion ps WHERE ps.status like '_b_' or ps.pkid = '2'");
        this.queries.put("862", "SELECT * FROM /exampleRegion ps WHERE ps.pkid like '%b%' and ps.status like '%ctiv%'");
        this.queries.put("863", "SELECT * FROM /exampleRegion ps WHERE ps.pkid like '_bc'");
        this.queries.put("864", "SELECT distinct *  FROM /exampleRegion ps WHERE ps.pkid like '%b%'");
        this.queries.put("900", "SELECT DISTINCT  key.ID, key.status as st from /exampleRegion.keys key where key.status = 'inactive' order by key.status desc, key.ID LIMIT 1");
        this.queries.put("901", "SELECT DISTINCT  key.ID, key.status as st from /exampleRegion.keys key where key.status = 'inactive' order by key.status desc, key.ID LIMIT 9");
        this.queries.put("902", "SELECT DISTINCT  key.status as st, key.ID from /exampleRegion.keys key where key.ID > 5 order by key.status, key.ID desc LIMIT 1");
        this.queries.put("903", "SELECT DISTINCT  key.status as st, key.ID from /exampleRegion.keys key where key.ID > 5 order by key.status, key.ID desc LIMIT 4");
        this.queries.put("904", "SELECT DISTINCT  key.status as st, key.ID from /exampleRegion.keys key where key.ID > 5 order by key.status, key.ID desc LIMIT 9");
        this.queries.put("905", "SELECT DISTINCT  p.position1.secId , p.ID as st from /exampleRegion p order by p.position1.secId, p.ID LIMIT 1");
        this.queries.put("906", "SELECT DISTINCT  p.position1.secId , p.ID as st from /exampleRegion p order by p.position1.secId, p.ID LIMIT 9");
        this.queries.put("907", "SELECT DISTINCT * from /exampleRegion p order by p.getID() LIMIT 9");
        this.queries.put("908", "SELECT DISTINCT * from /exampleRegion p, p.positions.values val order by p.ID, val.secId LIMIT 1");
        this.queries.put("909", "SELECT DISTINCT * from /exampleRegion p, p.positions.values val order by p.ID, val.secId LIMIT 9");
        this.queries.put("910", "SELECT DISTINCT e.key from /exampleRegion.entrySet e order by e.key.ID, e.key.pkid desc LIMIT 1");
        this.queries.put("911", "SELECT DISTINCT e.key from /exampleRegion.entrySet e order by e.key.ID, e.key.pkid desc LIMIT 4");
        this.queries.put("912", "SELECT DISTINCT e.key from /exampleRegion.entrySet e order by e.key.ID, e.key.pkid desc LIMIT 9");
        this.queries.put("913", "SELECT DISTINCT e.key.ID, e.value.status from /exampleRegion.entrySet e order by e.key.ID, e.value.status desc LIMIT 1");
        this.queries.put("914", "SELECT DISTINCT e.key.ID, e.value.status from /exampleRegion.entrySet e order by e.key.ID, e.value.status desc LIMIT 4");
        this.queries.put("915", "SELECT DISTINCT e.key.ID, e.value.status from /exampleRegion.entrySet e order by e.key.ID, e.value.status desc LIMIT 9");
        this.queries.put("916", "SELECT DISTINCT iD, status from /exampleRegion order by iD LIMIT 1");
        this.queries.put("917", "SELECT DISTINCT iD, status from /exampleRegion order by iD LIMIT 4");
        this.queries.put("918", "SELECT DISTINCT iD, status from /exampleRegion order by iD LIMIT 9");
        this.queries.put("919", "SELECT DISTINCT iD, status from /exampleRegion order by iD");
        this.queries.put("920", "SELECT DISTINCT key from /exampleRegion.keys key order by key.status, key.ID LIMIT 1");
        this.queries.put("921", "SELECT DISTINCT key from /exampleRegion.keys key order by key.status, key.ID LIMIT 4");
        this.queries.put("922", "SELECT DISTINCT key from /exampleRegion.keys key order by key.status, key.ID LIMIT 9");
        this.queries.put("923", "SELECT DISTINCT key.ID from /exampleRegion.keys key order by key.ID LIMIT 1");
        this.queries.put("924", "SELECT DISTINCT key.ID from /exampleRegion.keys key order by key.ID LIMIT 4");
        this.queries.put("925", "SELECT DISTINCT key.ID from /exampleRegion.keys key order by key.ID LIMIT 9");
        this.queries.put("926", "SELECT DISTINCT key.ID, key.status from /exampleRegion.keys key order by key.status desc, key.ID LIMIT 9");
        this.queries.put("927", "SELECT DISTINCT key.ID, key.status from /exampleRegion.keys key order by key.status, key.ID asc LIMIT 1");
        this.queries.put("928", "SELECT DISTINCT key.ID, key.status from /exampleRegion.keys key order by key.status, key.ID asc LIMIT 4");
        this.queries.put("929", "SELECT DISTINCT key.ID, key.status from /exampleRegion.keys key order by key.status, key.ID asc LIMIT 9");
        this.queries.put("930", "SELECT DISTINCT p, pos from /exampleRegion p, p.positions.values pos order by p.ID, pos.secId desc LIMIT 1");
        this.queries.put("931", "SELECT DISTINCT p, pos from /exampleRegion p, p.positions.values pos order by p.ID, pos.secId desc LIMIT 4");
        this.queries.put("932", "SELECT DISTINCT p, pos from /exampleRegion p, p.positions.values pos order by p.ID, pos.secId desc LIMIT 9");
        this.queries.put("933", "SELECT DISTINCT p, pos from /exampleRegion p, p.positions.values pos order by pos.secId, p.ID LIMIT 1");
        this.queries.put("934", "SELECT DISTINCT p, pos from /exampleRegion p, p.positions.values pos order by pos.secId, p.ID LIMIT 4");
        this.queries.put("935", "SELECT DISTINCT p, pos from /exampleRegion p, p.positions.values pos order by pos.secId, p.ID LIMIT 9");
        this.queries.put("936", "SELECT DISTINCT p.ID, p.status from /exampleRegion p order by p.ID LIMIT 9");
        this.queries.put("937", "SELECT DISTINCT p.position1.secId as st, p.ID as ied from /exampleRegion p where p.ID > 0 and p.position1.secId != 'IBM' order by p.position1.secId, p.ID LIMIT 1");
        this.queries.put("938", "SELECT DISTINCT p.position1.secId as st, p.ID as ied from /exampleRegion p where p.ID > 0 and p.position1.secId != 'IBM' order by p.position1.secId, p.ID LIMIT 4");
        this.queries.put("939", "SELECT DISTINCT p.position1.secId as st, p.ID as ied from /exampleRegion p where p.ID > 0 and p.position1.secId != 'IBM' order by p.position1.secId, p.ID LIMIT 9");
        this.queries.put("940", "SELECT DISTINCT p.position1.secId, p.ID from /exampleRegion p order by p.position1.secId, p.ID desc LIMIT 1");
        this.queries.put("941", "SELECT DISTINCT p.position1.secId, p.ID from /exampleRegion p order by p.position1.secId, p.ID desc LIMIT 4");
        this.queries.put("942", "SELECT DISTINCT p.position1.secId, p.ID from /exampleRegion p order by p.position1.secId, p.ID desc LIMIT 9");
        this.queries.put("943", "SELECT DISTINCT p.status as st, p.ID as ID from /exampleRegion p where ID > 0 and status = 'inactive' order by p.status, p.ID desc LIMIT 1");
        this.queries.put("944", "SELECT DISTINCT p.status as st, p.ID as ID from /exampleRegion p where ID > 0 and status = 'inactive' order by p.status, p.ID desc LIMIT 4");
        this.queries.put("945", "SELECT DISTINCT p.status as st, p.ID as ID from /exampleRegion p where ID > 0 and status = 'inactive' order by p.status, p.ID desc LIMIT 9");
        this.queries.put("946", "SELECT DISTINCT p.status from /exampleRegion p order by p.status LIMIT 9");
        this.queries.put("947", "SELECT DISTINCT p.status, p.ID from /exampleRegion p order by p.status asc, p.ID LIMIT 1");
        this.queries.put("948", "SELECT DISTINCT p.status, p.ID from /exampleRegion p order by p.status asc, p.ID LIMIT 4");
        this.queries.put("949", "SELECT DISTINCT p.status, p.ID from /exampleRegion p order by p.status asc, p.ID LIMIT 9");
        this.queries.put("950", "SELECT DISTINCT pf.ID , pf.createTime FROM /exampleRegion  pf WHERE pf.ID > 10 limit 5");
        this.queries.put("951", "SELECT DISTINCT pf.ID FROM /exampleRegion  pf WHERE pf.ID > 10 limit 5");
        this.queries.put("952", "SELECT DISTINCT pf.ID FROM /exampleRegion pf WHERE pf.ID > 0 limit 5");
        this.queries.put("953", "SELECT DISTINCT pf.ID, pf.createTime FROM /exampleRegion pf WHERE pf.ID > 0 limit 5");
        this.queries.put("954", "SELECT DISTINCT status , ID as ied from /exampleRegion where ID > 0 order by status, ID desc LIMIT 1");
        this.queries.put("955", "SELECT DISTINCT status , ID as ied from /exampleRegion where ID > 0 order by status, ID desc LIMIT 4");
        this.queries.put("956", "SELECT DISTINCT status , ID as ied from /exampleRegion where ID > 0 order by status, ID desc LIMIT 9");
        this.queries.put("957", "SELECT DISTINCT status as st from /exampleRegion order by status LIMIT 1");
        this.queries.put("958", "SELECT DISTINCT status as st from /exampleRegion order by status LIMIT 4");
        this.queries.put("959", "SELECT DISTINCT status as st from /exampleRegion order by status LIMIT 9");
        this.queries.put("960", "SELECT * FROM /exampleRegion p WHERE p.ID > 0 LIMIT 2");
        this.queries.put("961", "select * from /exampleRegion this where ID > 2 limit 100");
        this.queries.put("1000", "SELECT DISTINCT * FROM /exampleRegion where IS_DEFINED(P2.secId)");
        this.queries.put("1001", "SELECT DISTINCT * FROM /exampleRegion where IS_UNDEFINED(P2.secId)");
        this.queries.put("1002", "null IN SET('x','y','z')");
        this.queries.put("1003", "null IN SET(null)");
        this.queries.put("1004", "nvl('notNull', 'foundNull')");
        this.queries.put("1005", "nvl(NULL, 'foundNull')");
        this.queries.put("1006", "select distinct * from UNDEFINED");
        this.queries.put("1007", "to_date('05/09/10', 'yy/dd/yy')");
        this.queries.put("1008", "to_date('05/10/09', 'yy/dd/MM')");
        this.queries.put("1009", "to_date('050910', 'yyddMM')");
        this.queries.put("1010", "to_date('051009', 'yyMMdd')");
        this.queries.put("1011", "to_date('09/05/10', 'dd/MM/yy')");
        this.queries.put("1012", "to_date('09/10/05', 'MM/dd/yy')");
        this.queries.put("1013", "to_date('09/10/2005', 'dd/MM/yyyy')");
        this.queries.put("1014", "to_date('09/2005/10', 'dd/yyyy/MM')");
        this.queries.put("1015", "to_date('090510', 'ddyyMM')");
        this.queries.put("1016", "to_date('091005', 'ddMMyy')");
        this.queries.put("1017", "to_date('09102005', 'ddMMyy')");
        this.queries.put("1018", "to_date('09102005', 'ddMMyyyy')");
        this.queries.put("1019", "to_date('09200510', 'ddyyyyMM')");
        this.queries.put("1020", "to_date('10/05/09', 'MM/dd/yy')");
        this.queries.put("1021", "to_date('10/09/05', 'MM/dd/yy')");
        this.queries.put("1022", "to_date('10/09/2005', 'MM/dd/yyyy')");
        this.queries.put("1023", "to_date('10/2005/09', 'MM/yyyy/dd')");
        this.queries.put("1024", "to_date('100509', 'MMyydd')");
        this.queries.put("1025", "to_date('100905', 'MMddyy')");
        this.queries.put("1026", "to_date('10092005', 'MMddyy')");
        this.queries.put("1027", "to_date('10092005', 'MMddyyyy')");
        this.queries.put("1028", "to_date('10092005121314', 'MMddyyyyHHmmss')");
        this.queries.put("1029", "to_date('10092005121314567', 'MMddyyyyHHmmssSSS')");
        this.queries.put("1030", "to_date('10200509', 'MMyyyydd')");
        this.queries.put("1031", "to_date('2005/09/10', 'yyyy/dd/MM')");
        this.queries.put("1032", "to_date('2005/09/10', 'yyyy/MM/dd')");
        this.queries.put("1033", "to_date('20050910', 'yyyyddMM')");
        this.queries.put("1034", "to_date('20051009', 'yyyyMMdd')");
        this.queries.put("1035", "ELEMENT(SELECT DISTINCT * FROM /exampleRegion value  where value.length > 6)");
        this.queries.put("1036", "ELEMENT(SELECT DISTINCT * FROM /exampleRegion where ID <= 1).status");
        this.queries.put("1037", "ELEMENT(SELECT DISTINCT * FROM /exampleRegion where ID =1).status");
        this.queries.put("1038", "SELECT DISTINCT * FROM /exampleRegion where status = ELEMENT(SELECT DISTINCT * FROM /exampleRegion p where ID = 0).status");
        this.queries.put("1039", "SELECT DISTINCT * FROM /exampleRegion where status = ELEMENT(SELECT DISTINCT * FROM /exampleRegion p where p.ID = 0).status");
        this.queries.put("1040", "UNDEFINED IN SET(1,2,3)");
        this.queries.put("1041", "UNDEFINED IN SET(UNDEFINED)");
        this.queries.put("1042", "UNDEFINED IN SET(UNDEFINED,UNDEFINED)");
        this.queries.put("1100", "SELECT * FROM /exampleRegion portfolio1, /exampleRegion2 portfolio2 WHERE portfolio1.status = portfolio2.status");
        this.queries.put("1101", "SELECT portfolio1.ID, portfolio2.status FROM /exampleRegion portfolio1, /exampleRegion2 portfolio2");
        this.queries.put("1102", "SELECT * FROM /exampleRegion portfolio1, portfolio1.positions.values positions1, /exampleRegion2 portfolio2,");
        this.queries.put("1103", "SELECT * FROM /exampleRegion portfolio1, portfolio1.positions.values positions1, /exampleRegion2 portfolio2,");
        this.queries.put("1104", "SELECT * FROM (SELECT * FROM /exampleRegion2 m) r2, (SELECT * FROM /exampleRegion e WHERE e.pkid IN  r2.sp) p");
        this.queries.put("1105", "SELECT * FROM (SELECT * FROM /exampleRegion2 m WHERE m.ID IN SET (1, 5, 10)) r2, (SELECT * FROM /exampleRegion e WHERE e.pkid IN  r2.sp) p");
        this.queries.put("1106", "SELECT DISTINCT * FROM /exampleRegion c1, /exampleRegion2 c2 WHERE c1.name = 'INDIA' AND c2.name = 'ISRAEL'");
        this.queries.put("1107", "SELECT DISTINCT * FROM /exampleRegion c1, /exampleRegion2 c3, c1.states s1, c3.states s3, s1.districts d1, s3.getDistrictsWithSameName(d1) d3 WHERE c1.name = 'INDIA' OR c3.name = 'ISRAEL' OR d3.name = 'MUMBAIDIST' OR d3.name = 'PUNEDIST'");
        this.queries.put("1108", "SELECT DISTINCT * FROM /exampleRegion c1, c1.states s1, s1.districts d1, /exampleRegion2 c2, c2.states s2, s2.districts d2, /exampleRegion2 c3, c3.states s3, s3.districts d3 WHERE d3.name = 'PUNEDIST' AND s2.name = 'GUJARAT'");
        this.queries.put("1109", "SELECT DISTINCT * FROM /exampleRegion c1, c1.states s1, s1.districts d1, d1.cities ct1, d1.villages v1, /exampleRegion2 c2, c2.states s2, s2.districts d2, d2.cities ct2, d2.villages v2 WHERE c1.name = 'INDIA' AND c2.name = 'ISRAEL'");
        this.queries.put("1110", "SELECT DISTINCT * FROM /exampleRegion c1, c1.states s1, s1.districts d1, d1.villages v1, d1.cities ct1, /exampleRegion2 c2, c2.states s2, s2.districts d2, d2.villages v2, d2.cities ct2 WHERE v1.name = 'MAHARASHTRA_VILLAGE1' AND ct2.name = 'MUMBAI'");
        this.queries.put("1111", "SELECT DISTINCT * FROM /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion e WHERE pf1.status = 'active'");
        this.queries.put("1112", "SELECT DISTINCT * FROM /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion e1 WHERE pf1.status = 'active' AND e1.empId < 10");
        this.queries.put("1113", "SELECT DISTINCT * FROM /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion e1 WHERE pf1.status = 'active' AND pf2.status = 'active' AND e1.empId < 10");
        this.queries.put("1114", "SELECT DISTINCT * FROM /exampleRegion pf1, /exampleRegion2 pf2, pf1.positions.values posit1, pf2.positions.values posit2 WHERE posit1.secId='IBM' AND posit2.secId='IBM'");
        this.queries.put("1115", "SELECT DISTINCT * FROM /exampleRegion pf1, pf1.collectionHolderMap.values coll1, pf1.positions.values posit1, /exampleRegion2 pf2, pf2.collectionHolderMap.values coll2, pf2.positions.values posit2  WHERE posit1.secId='IBM' AND posit2.secId='IBM'");
        this.queries.put("1116", "SELECT DISTINCT * FROM /exampleRegion pf1, pf1.positions.values posit1, /exampleRegion2 pf2, /exampleRegion e WHERE posit1.secId='IBM'");
        this.queries.put("1117", "SELECT DISTINCT * FROM /exampleRegion pf1, pf1.positions.values posit1, /exampleRegion2 pf2, pf2.positions.values posit2 WHERE pf2.status='active' AND posit1.secId='IBM'");
        this.queries.put("1118", "SELECT DISTINCT * FROM /exampleRegion pf1,/exampleRegion2 pf2, pf1.positions.values posit1, pf2.positions.values posit2 WHERE posit1.secId='IBM' OR posit2.secId='IBM'");
        this.queries.put("1119", "SELECT DISTINCT * FROM /exampleRegion pf1,/exampleRegion2 pf2, pf1.positions.values posit1, pf2.positions.values posit2, pf1.collectionHolderMap.values coll1,pf2.collectionHolderMap.values coll2  WHERE posit1.secId='IBM' OR posit2.secId='IBM'");
        this.queries.put("1120", "SELECT DISTINCT * FROM /exampleRegion2,  positions.values where status='active'");
        this.queries.put("1121", "SELECT DISTINCT * FROM /root/exampleRegion p, /root/exampleRegion2 p2 WHERE  p.status = 'active'");
        this.queries.put("1122", "SELECT DISTINCT c1.name, s1.name, d2.name, ct2.name FROM /exampleRegion c1, c1.states s1, s1.districts d1, d1.cities ct1, /exampleRegion2 c2, c2.states s2, s2.districts d2, d2.cities ct2 WHERE ct1.name = 'MUMBAI' OR ct2.name = 'CHENNAI'");
        this.queries.put("1123", "SELECT DISTINCT c1.name, s1.name, d2.name, ct2.name FROM /exampleRegion c1, c1.states s1, s1.districts d1, d1.cities ct1,/exampleRegion2 c2, c2.states s2, s2.districts d2, d2.cities ct2 WHERE ct1.name = 'MUMBAI' OR ct2.name = 'CHENNAI'");
        this.queries.put("1124", "SELECT DISTINCT coll1 as collHldrMap1 , coll2 as CollHldrMap2 FROM /exampleRegion pf1, /exampleRegion2 pf2, pf1.positions.values posit1, pf2.positions.values posit2, pf1.collectionHolderMap.values coll1,pf2.collectionHolderMap.values coll2  WHERE posit1.secId='IBM' OR posit2.secId='IBM'");
        this.queries.put("1125", "SELECT DISTINCT coll1 as collHldrMap1 , coll2 as CollHldrMap2 FROM /exampleRegion pf1, /exampleRegion2 pf2, pf1.positions.values posit1,pf2.positions.values posit2,pf1.collectionHolderMap.values coll1, pf2.collectionHolderMap.values coll2 WHERE posit1.secId='IBM' OR posit2.secId='IBM'");
        this.queries.put("1126", "SELECT DISTINCT p.ID FROM /root/exampleRegion p, /root/exampleRegion2 p2 WHERE  p.ID = p2.ID and p.ID > 100 and p2.ID < 1");
        this.queries.put("1127", "SELECT p.ID FROM /root/exampleRegion p, /root/exampleRegion2 p2 WHERE  p.ID = p2.ID and p.status = 'active' and p2.status = 'active'");
        this.queries.put("1128", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists, dists.cities ct1, dists.villages villgs1, /exampleRegion2 c2, /exampleRegion3 c3 where c1.name = c2.name and ct1.name != 'PUNE' and villgs1.name = 'MAHARASHTRA_VILLAGE1'");
        this.queries.put("1129", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists, dists.cities ct1, dists.villages villgs1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where c1.name = c2.name or ct1.name != 'PUNE' or villgs1.name = 'MAHARASHTRA_VILLAGE1'");
        this.queries.put("1130", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, c2.states s2, /exampleRegion3 c3, c3.states sts3, sts3.districts dists3, dists3.cities ct3, dists3.villages villgs3 where c1.name = c2.name and ct1.name != 'PUNE' and villgs1.name = 'MAHARASHTRA_VILLAGE1' and villgs1.name = villgs3.name and s2.name = 'PUNJAB' and ct1.name = ct3.name and dists3.name = 'MUMBAIDIST'");
        this.queries.put("1131", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, c2.states s2, /exampleRegion3 c3, c3.states sts3, sts3.districts dists3, dists3.cities ct3, dists3.villages villgs3 where c1.name = c2.name and ct1.name != 'PUNE' or villgs1.name = 'MAHARASHTRA_VILLAGE1' or villgs1.name = villgs3.name or s2.name = 'PUNJAB' or ct1.name = ct3.name and dists3.name = 'MUMBAIDIST'");
        this.queries.put("1132", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, c2.states s2, /exampleRegion3 c3, c3.states sts3, sts3.districts dists3, dists3.cities ct3, dists3.villages villgs3 where c1.name = c2.name and sts1.name != 'PUNJAB' and ct1.name != 'PUNE' and villgs1.name = 'MAHARASHTRA_VILLAGE1' and villgs1.name = villgs3.name and sts3.name != sts1.name and s2.name = 'PUNJAB' and ct1.name = ct3.name and dists3.name = 'MUMBAIDIST' and dists3.name != s2.name");
        this.queries.put("1133", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, c2.states s2, /exampleRegion3 c3, c3.states sts3, sts3.districts dists3, dists3.cities ct3, dists3.villages villgs3 where c1.name = c2.name or ct1.name != 'PUNE' and villgs1.name = 'MAHARASHTRA_VILLAGE1' or villgs1.name = villgs3.name or s2.name = 'PUNJAB' or ct1.name = ct3.name and dists3.name = 'MUMBAIDIST'");
        this.queries.put("1134", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, c2.states s2, /exampleRegion3 c3, c3.states sts3, sts3.districts dists3, dists3.cities ct3, dists3.villages villgs3 where c1.name = c2.name or ct1.name != 'PUNE' or villgs1.name = 'MAHARASHTRA_VILLAGE1' or villgs1.name = villgs3.name or s2.name = 'PUNJAB' or ct1.name = ct3.name or dists3.name = 'MUMBAIDIST'");
        this.queries.put("1135", "Select distinct * from /exampleRegion pf, /exampleRegion2, /exampleRegion3, /exampleRegion where pf.status='active'");
        this.queries.put("1136", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' and (c1.name = c2.name or pfo3.status != 'inactive') and pfo3.status = pfos.status");
        this.queries.put("1137", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' and c1.name = c2.name or c3.name = 'INDIA' and pfo3.status != 'inactive' or pfo3.\"type\" = 'type1' and pfo3.status = pfos.status");
        this.queries.put("1138", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' and c1.name = c2.name or pfo3.status != 'inactive' and pfo3.status = pfos.status");
        this.queries.put("1139", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' or c1.name = c2.name or c3.name = 'INDIA' and pfo3.status != 'inactive' or pfo3.\"type\" = 'type1' and pfo3.status = pfos.status");
        this.queries.put("1140", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' or c1.name = c2.name or pfo3.status != 'inactive' or pfo3.status = pfos.status");
        this.queries.put("1141", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, c1.states s1, /exampleRegion2 c2, c2.states s2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' and ((c1.name = c2.name or pfo3.status != 'inactive') and pfo3.status = pfos.status) or s1.name = 'MAHARASHTRA' and s2.name != 'MAHARASHTRA'");
        this.queries.put("1142", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where (Pos1.secId = 'YHOO' and c1.name = c2.name or pfo3.status != 'inactive') and pfo3.status = pfos.status and villgs1.name = 'MAHARASHTRA_VILLAGE1'");
        this.queries.put("1143", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' and c1.name = c2.name or pfo3.status != 'inactive' and pfo3.status = pfos.status and villgs1.name = 'MAHARASHTRA_VILLAGE1' or pfos.ID != 0");
        this.queries.put("1144", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' and c1.name = c2.name or pfo3.status != 'inactive' and pfo3.status = pfos.status and villgs1.name = 'MAHARASHTRA_VILLAGE1'");
        this.queries.put("1145", "Select distinct * from /exampleRegion, /exampleRegion2");
        this.queries.put("1146", "Select distinct * from /exampleRegion, /exampleRegion2, /exampleRegion3, /exampleRegion");
        this.queries.put("1147", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and false and c1.name = 'INDIA' and pf2.ID = 2");
        this.queries.put("1148", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and false and pf1.ID = pf2.ID and c1.name = 'INDIA' and pf2.ID = 2");
        this.queries.put("1149", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and false and pf1.ID = pf2.ID or c1.name = 'INDIA' or pf2.ID = 2");
        this.queries.put("1150", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and false and pf1.ID = pf2.ID");
        this.queries.put("1151", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and false or c1.name = 'INDIA' or pf2.ID = 2");
        this.queries.put("1152", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and false");
        this.queries.put("1153", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and true and c1.name = 'INDIA' and pf2.ID = 2");
        this.queries.put("1154", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and true or c1.name = 'INDIA' or pf1.ID = 2");
        this.queries.put("1155", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and true or pf1.ID = pf2.ID and c1.name = 'INDIA' and pf2.ID = 2");
        this.queries.put("1156", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and true or pf1.ID = pf2.ID or c1.name = 'INDIA' or pf2.ID = 2");
        this.queries.put("1157", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and true or pf1.ID = pf2.ID");
        this.queries.put("1158", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and true");
        this.queries.put("1159", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name");
        this.queries.put("1160", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or false or c1.name = c2.name and c1.name = 'INDIA' and pf1.ID = 2");
        this.queries.put("1161", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or false or c1.name = c2.name or c1.name = 'INDIA' or pf1.ID = 2");
        this.queries.put("1162", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or false or c1.name = c2.name or pf2.ID = 1 or c1.name = 'INDIA' and c1.name = 'INDIA' and pf2.ID = 2");
        this.queries.put("1163", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or false or c1.name = c2.name or pf2.ID = 1 or c1.name = 'INDIA'");
        this.queries.put("1164", "select distinct * from /exampleRegion pf1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or false or c1.name = c2.name");
        this.queries.put("1165", "select distinct * from /exampleRegion pf1, pf1.positions.values pos1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status and c1.name = c2.name or pos1.secId = 'IBM' and c1.name = 'INDIA' and pf2.ID = 2");
        this.queries.put("1166", "select distinct * from /exampleRegion pf1, pf1.positions.values pos1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status and c1.name = c2.name or pos1.secId = 'IBM' or c1.name = 'INDIA' or pf2.ID = 2");
        this.queries.put("1167", "select distinct * from /exampleRegion pf1, pf1.positions.values pos1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status and c1.name = c2.name or pos1.secId = 'IBM' or false and pf1.ID = pf2.ID and c1.name = 'INDIA' and pf2.ID = 2");
        this.queries.put("1168", "select distinct * from /exampleRegion pf1, pf1.positions.values pos1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status and c1.name = c2.name or pos1.secId = 'IBM' or false and pf1.ID = pf2.ID or c1.name = 'INDIA' or pf1.ID = 2");
        this.queries.put("1169", "select distinct * from /exampleRegion pf1, pf1.positions.values pos1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status and c1.name = c2.name or pos1.secId = 'IBM' or false and pf1.ID = pf2.ID");
        this.queries.put("1170", "select distinct * from /exampleRegion pf1, pf1.positions.values pos1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status and c1.name = c2.name or pos1.secId = 'IBM'");
        this.queries.put("1171", "select distinct * from /exampleRegion pf1, pf1.positions.values pos1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and pos1.secId = 'IBM' and true and c1.name = 'INDIA' and pf2.ID = 2");
        this.queries.put("1172", "select distinct * from /exampleRegion pf1, pf1.positions.values pos1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and pos1.secId = 'IBM' and true or pf1.ID != 3");
        this.queries.put("1173", "select distinct * from /exampleRegion pf1, pf1.positions.values pos1, /exampleRegion2 pf2, /exampleRegion c1, /exampleRegion2 c2 where pf1.status = pf2.status or c1.name = c2.name and pos1.secId = 'IBM' and true");
        this.queries.put("1174", "select distinct * from /root/exampleRegion, /root/exampleRegion2");
        this.queries.put("1175", "select distinct a, b.price from /root/exampleRegion a, /root/exampleRegion2 b where a.price = b.price and a.price = 50");
        this.queries.put("1176", "select distinct a, b.price from /root/exampleRegion a, /root/exampleRegion2 b where a.price = b.price");
        this.queries.put("1177", "SELECT DISTINCT * FROM /exampleRegion pf, pf.positions pos, /exampleRegion3 pf3, /exampleRegion emp WHERE pf.iD = emp.empId and pf.status='active' and emp.age > 50 and pf3.status='active'");
        this.queries.put("1178", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists, dists.cities ct1, dists.villages villgs1, /exampleRegion2 c2, /exampleRegion3 c3 where c1.name = c2.name and ct1.name != 'PUNE' and villgs1.name = 'MAHARASHTRA_VILLAGE1'");
        this.queries.put("1179", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists, dists.cities ct1, dists.villages villgs1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where c1.name = c2.name or ct1.name != 'PUNE' or villgs1.name = 'MAHARASHTRA_VILLAGE1'");
        this.queries.put("1180", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, c2.states s2, /exampleRegion3 c3, c3.states sts3, sts3.districts dists3, dists3.cities ct3, dists3.villages villgs3 where c1.name = c2.name and ct1.name != 'PUNE' and villgs1.name = 'MAHARASHTRA_VILLAGE1' and villgs1.name = villgs3.name and s2.name = 'PUNJAB' and ct1.name = ct3.name and dists3.name = 'MUMBAIDIST'");
        this.queries.put("1181", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, c2.states s2, /exampleRegion3 c3, c3.states sts3, sts3.districts dists3, dists3.cities ct3, dists3.villages villgs3 where c1.name = c2.name and ct1.name != 'PUNE' or villgs1.name = 'MAHARASHTRA_VILLAGE1' or villgs1.name = villgs3.name or s2.name = 'PUNJAB' or ct1.name = ct3.name and dists3.name = 'MUMBAIDIST'");
        this.queries.put("1182", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, c2.states s2, /exampleRegion3 c3, c3.states sts3, sts3.districts dists3, dists3.cities ct3, dists3.villages villgs3 where c1.name = c2.name and sts1.name != 'PUNJAB' and ct1.name != 'PUNE' and villgs1.name = 'MAHARASHTRA_VILLAGE1' and villgs1.name = villgs3.name and sts3.name != sts1.name and s2.name = 'PUNJAB' and ct1.name = ct3.name and dists3.name = 'MUMBAIDIST' and dists3.name != s2.name");
        this.queries.put("1183", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, c2.states s2, /exampleRegion3 c3, c3.states sts3, sts3.districts dists3, dists3.cities ct3, dists3.villages villgs3 where c1.name = c2.name or ct1.name != 'PUNE' and villgs1.name = 'MAHARASHTRA_VILLAGE1' or villgs1.name = villgs3.name or s2.name = 'PUNJAB' or ct1.name = ct3.name and dists3.name = 'MUMBAIDIST'");
        this.queries.put("1184", "Select distinct * from /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, c2.states s2, /exampleRegion3 c3, c3.states sts3, sts3.districts dists3, dists3.cities ct3, dists3.villages villgs3 where c1.name = c2.name or ct1.name != 'PUNE' or villgs1.name = 'MAHARASHTRA_VILLAGE1' or villgs1.name = villgs3.name or s2.name = 'PUNJAB' or ct1.name = ct3.name or dists3.name = 'MUMBAIDIST'");
        this.queries.put("1185", "Select distinct * from /exampleRegion pf, /exampleRegion2, /exampleRegion3, /exampleRegion where pf.status='active'");
        this.queries.put("1186", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' and (c1.name = c2.name or pfo3.status != 'inactive') and pfo3.status = pfos.status");
        this.queries.put("1187", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' and c1.name = c2.name or c3.name = 'INDIA' and pfo3.status != 'inactive' or pfo3.\"type\" = 'type1' and pfo3.status = pfos.status");
        this.queries.put("1188", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' and c1.name = c2.name or pfo3.status != 'inactive' and pfo3.status = pfos.status");
        this.queries.put("1189", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' or c1.name = c2.name or c3.name = 'INDIA' and pfo3.status != 'inactive' or pfo3.\"type\" = 'type1' and pfo3.status = pfos.status");
        this.queries.put("1190", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' or c1.name = c2.name or pfo3.status != 'inactive' or pfo3.status = pfos.status");
        this.queries.put("1191", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, c1.states s1, /exampleRegion2 c2, c2.states s2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' and ((c1.name = c2.name or pfo3.status != 'inactive') and pfo3.status = pfos.status) or s1.name = 'MAHARASHTRA' and s2.name != 'MAHARASHTRA'");
        this.queries.put("1192", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where (Pos1.secId = 'YHOO' and c1.name = c2.name or pfo3.status != 'inactive') and pfo3.status = pfos.status and villgs1.name = 'MAHARASHTRA_VILLAGE1'");
        this.queries.put("1193", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' and c1.name = c2.name or pfo3.status != 'inactive' and pfo3.status = pfos.status and villgs1.name = 'MAHARASHTRA_VILLAGE1' or pfos.ID != 0");
        this.queries.put("1194", "Select distinct * from /exampleRegion pfos, pfos.positions.values Pos1, /exampleRegion c1, c1.states sts1, sts1.districts dists1, dists1.cities ct1, dists1.villages villgs1, /exampleRegion2 c2, /exampleRegion3 c3, /exampleRegion3 pfo3 where Pos1.secId = 'YHOO' and c1.name = c2.name or pfo3.status != 'inactive' and pfo3.status = pfos.status and villgs1.name = 'MAHARASHTRA_VILLAGE1'");
        this.queries.put("1195", "Select distinct * from /exampleRegion, /exampleRegion2, /exampleRegion3, /exampleRegion");
        this.queries.put("1196", "Select distinct * from /exampleRegion3 pf, pf.positions");
        this.queries.put("1197", "Select distinct * from /exampleRegion3, /exampleRegion");
        this.queries.put("1198", "select distinct * from /root/exampleRegion3");
        this.queries.put("1199", "select * from /region1 r1, /region2 r2 wherer1.ID = r2.id");
        this.queries.put("1200", "select * from /region1 r1, /region2 r2 wherer1.ID = r2.id AND r1.ID > 5");
        this.queries.put("1201", "select * from /region1 r1, /region2 r2 wherer1.ID = r2.id AND r1.status = 'active'");
        this.queries.put("1202", "select distinct * from /region1 r1, /region2 r2 wherer1.ID = r2.id ORDER BY r1.ID");
        this.queries.put("1203", "select distinct * from /region1 r1, /region2 r2 wherer1.ID = r2.id ORDER BY r2.id");
        this.queries.put("1204", "select distinct * from /region1 r1, /region2 r2 wherer1.ID = r2.id ORDER BY r2.status");
        this.queries.put("1205", "select * from /region1 r1, /region2 r2 wherer1.ID = r2.id AND r1.status != r2.status");
        this.queries.put("1206", "select * from /region1 r1, /region2 r2 wherer1.ID = r2.id AND r1.status = r2.status");
        this.queries.put("1207", "select * from /region1 r1, /region2 r2 wherer1.ID = r2.id AND r1.positions.size = r2.positions.size");
        this.queries.put("1208", "select * from /region1 r1, /region2 r2 wherer1.ID = r2.id AND r1.positions.size > r2.positions.size");
        this.queries.put("1209", "select * from /region1 r1, /region2 r2 wherer1.ID = r2.id AND r1.positions.size < r2.positions.size");
        this.queries.put("1210", "select * from /region1 r1, /region2 r2 wherer1.ID = r2.id AND r1.positions.size = r2.positions.size AND r2.positions.size > 0");
        this.queries.put("1211", "select * from /region1 r1, /region2 r2 wherer1.ID = r2.id AND (r1.positions.size > r2.positions.size OR r2.positions.size > 0)");
        this.queries.put("1212", "select * from /region1 r1, /region2 r2 wherer1.ID = r2.id AND (r1.positions.size < r2.positions.size OR r1.positions.size > 0)");
        this.queries.put("1199", "select * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id");
        this.queries.put("1200", "select * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id AND r1.ID > 5");
        this.queries.put("1201", "select * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id AND r1.status = 'active'");
        this.queries.put("1202", "select distinct * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id ORDER BY r1.ID");
        this.queries.put("1203", "select distinct * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id ORDER BY pos2.id");
        this.queries.put("1204", "select distinct * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id ORDER BY r2.status");
        this.queries.put("1205", "select * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id AND r1.status != r2.status");
        this.queries.put("1206", "select * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id AND r1.status = r2.status");
        this.queries.put("1207", "select * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id AND r1.positions.size = r2.positions.size");
        this.queries.put("1208", "select * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id AND r1.positions.size > r2.positions.size");
        this.queries.put("1209", "select * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id AND r1.positions.size < r2.positions.size");
        this.queries.put("1210", "select * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id AND r1.positions.size = r2.positions.size AND r2.positions.size > 0");
        this.queries.put("1211", "select * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id AND (r1.positions.size > r2.positions.size OR r2.positions.size > 0)");
        this.queries.put("1212", "select * from /region1 r1, /region2 r2, r2.positions.values pos2 wherer1.ID = pos2.id AND (r1.positions.size < r2.positions.size OR r1.positions.size > 0)");
    }

    public static QueryService getQueryService() {
        return cache.getQueryService();
    }

    public void createServer(VM server, final Properties prop) {
        CacheSerializableRunnable createCacheServer = new CacheSerializableRunnable("Create Cache Server"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                QueryTestUtils.this.createCache(prop);
            }
        };
        server.invoke(createCacheServer);
    }

    public void createCache(Properties prop) {
        cache = null != prop && !prop.isEmpty() ? new CacheFactory(prop).create() : new CacheFactory().set("mcast-port", "0").create();
    }

    public static void setCache(Cache cache) {
        QueryTestUtils.cache = cache;
    }

    public void createPartitionRegion(final String name, final Class constraint, VM vm) {
        vm.invoke(new CacheSerializableRunnable("Create Partition region"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                QueryTestUtils.this.createPartitionRegion(name, constraint);
            }
        });
    }

    public void createPartitionRegion(String name, Class constraint) {
        ExpirationAttributes expiration = ExpirationAttributes.DEFAULT;
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        RegionFactory factory = cache.createRegionFactory(RegionShortcut.PARTITION).setPartitionAttributes(paf.create());
        if (constraint != null) {
            factory.setValueConstraint(constraint);
        }
        factory.create(name);
    }

    public void createReplicateRegion(final String name, VM vm) {
        vm.invoke(new CacheSerializableRunnable("Create Replicated region"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                QueryTestUtils.this.getLogger().fine("### Create replicated region. ###");
                QueryTestUtils.this.createReplicateRegion(name);
            }
        });
    }

    public void createReplicateRegion(String name) {
        cache.createRegionFactory(RegionShortcut.REPLICATE).create(name);
    }

    public void createHashIndex(VM vm, final String name, final String field, final String region) {
        vm.invoke(new CacheSerializableRunnable("Create Replicated region"){

            @Override
            public void run2() throws CacheException {
                QueryTestUtils.this.createHashIndex(name, field, region);
            }
        });
    }

    public Index createHashIndex(String name, String field, String region) {
        try {
            return cache.getQueryService().createHashIndex(name, field, region);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Index creation failed for index on region: " + region + "." + field, e);
        }
    }

    public void createIndex(VM vm, final String name, final String field, final String region) throws CacheException {
        vm.invoke(new CacheSerializableRunnable("Create Index"){

            @Override
            public void run2() throws CacheException {
                QueryTestUtils.this.createIndex(name, field, region);
            }
        });
    }

    public Index createIndex(String name, String field, String region) throws CacheException {
        try {
            return cache.getQueryService().createIndex(name, field, region);
        }
        catch (Exception e) {
            throw new RuntimeException("Index creation failed for index on region: " + region + "." + field, e);
        }
    }

    public void removeIndex(String name, String region) {
        try {
            QueryService qs = QueryTestUtils.getQueryService();
            qs.removeIndex(qs.getIndex(cache.getRegion(region), name));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Index removal failed for index: " + name + " on region: " + region, e);
        }
    }

    public void createLocalRegion(final String name, VM vm) {
        vm.invoke(new CacheSerializableRunnable("Create Local region"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                QueryTestUtils.this.getLogger().fine("### Create Local region. ###");
                QueryTestUtils.this.createLocalRegion(name);
            }
        });
    }

    public void createLocalRegion(String name) {
        cache.createRegionFactory(RegionShortcut.LOCAL).create(name);
    }

    public void createSubRegion(final String rootName, final String name, final RegionAttributes regionAttributes, VM vm) {
        vm.invoke(new CacheSerializableRunnable("Creating subregion"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                QueryTestUtils.this.getLogger().fine("### Create subregion. ###");
                Region root = cache.getRegion(rootName);
                if (root == null) {
                    root = cache.createRegionFactory().create(rootName);
                }
                RegionAttributes ra = null;
                if (regionAttributes == null) {
                    ra = new AttributesFactory().create();
                }
                root.createSubregion(name, ra);
            }
        });
    }

    public void closeServer(VM server) {
        server.invoke(new CacheSerializableRunnable("Closing Cache Server"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                QueryTestUtils.this.getLogger().fine("### Close Cache Server. ###");
                QueryTestUtils.this.closeCache();
            }
        });
    }

    public void closeCache() {
        if (!cache.isClosed()) {
            cache.close();
        }
    }

    public Object[] executeQueries(String[] qarr) throws Exception {
        QueryService qs = cache.getQueryService();
        Object[] result = new Object[qarr.length];
        String query = null;
        int j = 0;
        for (int i = 0; i < qarr.length; ++i) {
            query = this.queries.get(qarr[i]);
            result[j++] = qs.newQuery(query).execute();
        }
        return result;
    }

    public void executeQueriesWithoutDistinct(VM vm, final String[] qarr) {
        vm.invoke(new CacheSerializableRunnable("Executing query without distinct"){

            @Override
            public void run2() {
                QueryTestUtils.this.executeQueriesWithoutDistinct(qarr);
            }
        });
    }

    public Object[] executeQueriesWithoutDistinct(String[] qarr) {
        QueryService qs = cache.getQueryService();
        Object[] result = new Object[qarr.length];
        String query = null;
        int j = 0;
        for (int i = 0; i < qarr.length; ++i) {
            query = this.queries.get(qarr[i]);
            if (query.indexOf("distinct") > -1) {
                query = query.replace("distinct", "");
            }
            if (query.indexOf("DISTINCT") > -1) {
                query = query.replace("DISTINCT", "");
            }
            try {
                result[j++] = qs.newQuery(query).execute();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public void executeQueriesWithDistinct(VM vm, final String[] qarr) {
        vm.invoke(new CacheSerializableRunnable("Executing query with distinct"){

            @Override
            public void run2() {
                QueryTestUtils.this.executeQueriesWithDistinct(qarr);
            }
        });
    }

    public Object[] executeQueriesWithDistinct(String[] qarr) {
        QueryService qs = cache.getQueryService();
        Object[] result = new Object[qarr.length];
        String query = null;
        int j = 0;
        for (String aQarr : qarr) {
            query = this.queries.get(aQarr);
            if (!query.toLowerCase().contains("distinct")) {
                query = query.replaceFirst("select", "select distinct");
            }
            try {
                result[j++] = qs.newQuery(query).execute();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private LogWriter getLogger() {
        if (cache == null) {
            return null;
        }
        return cache.getLogger();
    }

    public Cache getCache() {
        return cache;
    }

    public static void createCacheInVM(VM vm, Properties props) {
        vm.invoke(() -> QueryTestUtils.getInstance().createCache(props));
    }

    public static void closeCacheInVM(VM vm) {
        vm.invoke(() -> cache.close());
    }

    public Region getRegion(String regionName) {
        return cache.getRegion(regionName);
    }

    public void populateRegion(String regionName, Map<?, ?> entries) {
        Region r = cache.getRegion("/" + regionName);
        entries.entrySet().forEach(e -> r.put(e.getKey(), e.getValue()));
    }

    public static void populateRegion(VM vm, String regionName, Map<?, ?> entries) {
        vm.invoke(() -> QueryTestUtils.getInstance().populateRegion(regionName, entries));
    }

    public static File createTestRootDiskStore(String testName) throws IOException {
        File diskDir = new File(testName).getAbsoluteFile();
        FileUtils.deleteDirectory((File)diskDir);
        diskDir.mkdir();
        diskDir.deleteOnExit();
        return diskDir;
    }

    public static File createRootDiskStoreInVM(VM vm, String rootDiskStoreName) {
        return (File)vm.invoke(() -> QueryTestUtils.createTestRootDiskStore(rootDiskStoreName));
    }

    static {
        instance = new QueryTestUtils();
    }
}

