/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.test.dunit.AsyncInvocation;
import org.apache.geode.test.dunit.DUnitEnv;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.NamedCallable;
import org.apache.geode.test.dunit.NamedRunnable;
import org.apache.geode.test.dunit.RMIException;
import org.apache.geode.test.dunit.SerializableCallableIF;
import org.apache.geode.test.dunit.SerializableRunnableIF;
import org.apache.geode.test.dunit.VMEventListener;
import org.apache.geode.test.dunit.internal.ChildVMLauncher;
import org.apache.geode.test.dunit.internal.DUnitLauncher;
import org.apache.geode.test.dunit.internal.MethodInvokerResult;
import org.apache.geode.test.dunit.internal.ProcessHolder;
import org.apache.geode.test.dunit.internal.RemoteDUnitVMIF;
import org.apache.geode.test.dunit.internal.VMEventNotifier;
import org.apache.geode.test.version.VersionManager;
import org.apache.logging.log4j.Logger;

public class VM
implements Serializable {
    private static final Logger logger = LogService.getLogger();
    public static final int CONTROLLER_VM = -1;
    public static final int DEFAULT_VM_COUNT = DUnitLauncher.NUM_VMS;
    private final Host host;
    private int id;
    private String version;
    private RemoteDUnitVMIF client;
    private volatile boolean available;
    private volatile transient ProcessHolder processHolder;
    private final transient ChildVMLauncher childVMLauncher;

    public static int getCurrentVMNum() {
        return DUnitEnv.get().getVMID();
    }

    public static boolean isControllerVM() {
        return VM.getCurrentVMNum() == -1;
    }

    public static boolean isVM() {
        return VM.getCurrentVMNum() != -1;
    }

    public static VM getVM(int whichVM) {
        return Host.getHost(0).getVM(whichVM);
    }

    public static List<VM> getAllVMs() {
        return Host.getHost(0).getAllVMs();
    }

    public static int getVMCount() {
        return Host.getHost(0).getVMCount();
    }

    public static VM getLocator() {
        return Host.getLocator();
    }

    public static VM getController() {
        return VM.getVM(-1);
    }

    public static String getHostName() {
        return Host.getHost(0).getHostName();
    }

    public static String getVMName(String version, int pid) {
        if (pid == -2) {
            return "locator";
        }
        if (pid < 0 || VersionManager.isCurrentVersion((String)version)) {
            return "vm" + pid;
        }
        return "vm" + pid + "_v" + version;
    }

    public static VM[] toArray(VM ... vms) {
        return vms;
    }

    public static VM[] toArray(List<VM> vmList) {
        return vmList.toArray(new VM[0]);
    }

    public static VM[] toArray(List<VM> vmList, VM ... vms) {
        return (VM[])ArrayUtils.addAll((Object[])vmList.toArray(new VM[0]), (Object[])vms);
    }

    public static VM[] toArray(VM[] vmArray, VM ... vms) {
        return (VM[])ArrayUtils.addAll((Object[])vmArray, (Object[])vms);
    }

    public static void addVMEventListener(VMEventListener listener) {
        VM.getVMEventNotifier().addVMEventListener(listener);
    }

    public static void removeVMEventListener(VMEventListener listener) {
        VM.getVMEventNotifier().removeVMEventListener(listener);
    }

    private static VMEventNotifier getVMEventNotifier() {
        return Host.getHost(0).getVMEventNotifier();
    }

    public VM(Host host, int id, RemoteDUnitVMIF client, ProcessHolder processHolder, ChildVMLauncher childVMLauncher) {
        this(host, "10240.0.0", id, client, processHolder, childVMLauncher);
    }

    public VM(Host host, String version, int id, RemoteDUnitVMIF client, ProcessHolder processHolder, ChildVMLauncher childVMLauncher) {
        this.host = host;
        this.id = id;
        this.version = version;
        this.client = client;
        this.processHolder = processHolder;
        this.childVMLauncher = childVMLauncher;
        this.available = true;
    }

    public Host getHost() {
        return this.host;
    }

    public String getVersion() {
        return this.version;
    }

    public int getId() {
        return this.id;
    }

    public int getPid() {
        return (Integer)this.invoke(() -> ProcessUtils.identifyPid());
    }

    @Deprecated
    public <V> V invoke(Class<?> targetClass, String methodName) {
        this.checkAvailability(targetClass.getName(), methodName);
        return this.executeMethodOnClass(targetClass, methodName, new Object[0]);
    }

    @Deprecated
    public <V> AsyncInvocation<V> invokeAsync(Class<?> targetClass, String methodName) {
        return this.invokeAsync(targetClass, methodName, null);
    }

    @Deprecated
    public <V> V invoke(Class<?> targetClass, String methodName, Object[] args) {
        this.checkAvailability(targetClass.getName(), methodName);
        return this.executeMethodOnClass(targetClass, methodName, args);
    }

    @Deprecated
    public <V> AsyncInvocation<V> invokeAsync(Object targetObject, String methodName, Object[] args) {
        return new AsyncInvocation<Object>(targetObject, methodName, () -> this.invoke(targetObject, methodName, args)).start();
    }

    @Deprecated
    public <V> AsyncInvocation<V> invokeAsync(Class<?> targetClass, String methodName, Object[] args) {
        return new AsyncInvocation<Object>(targetClass, methodName, () -> this.invoke(targetClass, methodName, args)).start();
    }

    public <V> AsyncInvocation<V> invokeAsync(SerializableRunnableIF runnable) {
        return this.invokeAsync(runnable, "run", new Object[0]);
    }

    public <V> AsyncInvocation<V> invokeAsync(String name, SerializableRunnableIF runnable) {
        return this.invokeAsync(new NamedRunnable(name, runnable), "run", new Object[0]);
    }

    public <V> AsyncInvocation<V> invokeAsync(String name, SerializableCallableIF<V> callable) {
        return this.invokeAsync(new NamedCallable<V>(name, callable), "call", new Object[0]);
    }

    public <V> AsyncInvocation<V> invokeAsync(SerializableCallableIF<V> callable) {
        return this.invokeAsync(callable, "call", new Object[0]);
    }

    public void invoke(String name, SerializableRunnableIF runnable) {
        this.checkAvailability(NamedRunnable.class.getName(), "run");
        this.executeMethodOnObject(new NamedRunnable(name, runnable), "run", new Object[0]);
    }

    public void invoke(SerializableRunnableIF runnable) {
        this.checkAvailability(runnable.getClass().getName(), "run");
        this.executeMethodOnObject(runnable, "run", new Object[0]);
    }

    public <V> V invoke(String name, SerializableCallableIF<V> callable) {
        this.checkAvailability(NamedCallable.class.getName(), "call");
        return this.executeMethodOnObject(new NamedCallable<V>(name, callable), "call", new Object[0]);
    }

    public <V> V invoke(SerializableCallableIF<V> callable) {
        this.checkAvailability(callable.getClass().getName(), "call");
        return this.executeMethodOnObject(callable, "call", new Object[0]);
    }

    @Deprecated
    public <V> V invoke(Object targetObject, String methodName) {
        this.checkAvailability(targetObject.getClass().getName(), methodName);
        return this.executeMethodOnObject(targetObject, methodName, new Object[0]);
    }

    @Deprecated
    public <V> V invoke(Object targetObject, String methodName, Object[] args) {
        this.checkAvailability(targetObject.getClass().getName(), methodName);
        return this.executeMethodOnObject(targetObject, methodName, args);
    }

    public synchronized void makeAvailable() {
        if (!this.available) {
            this.available = true;
            this.bounce();
        }
    }

    public void bounce() {
        this.bounce(this.version, false);
    }

    public void bounceForcibly() {
        this.bounce(this.version, true);
    }

    public void bounce(String targetVersion) {
        this.bounce(targetVersion, false);
    }

    private synchronized void bounce(String targetVersion, boolean force) {
        this.checkAvailability(this.getClass().getName(), "bounceVM");
        logger.info("Bouncing {} old pid is {}", (Object)this.id, (Object)this.getPid());
        VM.getVMEventNotifier().notifyBeforeBounceVM(this);
        this.available = false;
        try {
            if (force) {
                this.processHolder.killForcibly();
            } else {
                SerializableRunnableIF runnable = () -> new Thread(() -> {
                    try {
                        Thread.sleep(100L);
                        System.exit(0);
                    }
                    catch (InterruptedException e) {
                        logger.error("VM bounce thread interrupted before exiting.", (Throwable)e);
                    }
                }).start();
                this.executeMethodOnObject(runnable, "run", new Object[0]);
            }
            this.processHolder.waitFor();
            this.processHolder = this.childVMLauncher.launchVM(targetVersion, this.id, true);
            this.version = targetVersion;
            this.client = this.childVMLauncher.getStub(this.id);
            this.available = true;
            logger.info("Bounced {} new pid is {}", (Object)this.id, (Object)this.getPid());
            VM.getVMEventNotifier().notifyAfterBounceVM(this);
        }
        catch (IOException | InterruptedException | NotBoundException e) {
            throw new Error("Unable to restart VM " + this.id, e);
        }
    }

    private void checkAvailability(String className, String methodName) {
        if (!this.available) {
            throw new RMIException(this, className, methodName, new IllegalStateException("VM not available: " + this));
        }
    }

    public File getWorkingDirectory() {
        return DUnitEnv.get().getWorkingDirectory(this.getVersion(), this.getId());
    }

    public String toString() {
        return "VM " + this.getId() + " running on " + this.getHost() + (VersionManager.isCurrentVersion((String)this.version) ? "" : " with version " + this.version);
    }

    private <V> V executeMethodOnObject(Object targetObject, String methodName, Object[] args) {
        try {
            MethodInvokerResult result = this.client.executeMethodOnObject(targetObject, methodName, args);
            if (result.exceptionOccurred()) {
                throw new RMIException(this, targetObject.getClass().getName(), methodName, result.getException(), result.getStackTrace());
            }
            return (V)result.getResult();
        }
        catch (RemoteException exception) {
            throw new RMIException(this, targetObject.getClass().getName(), methodName, exception);
        }
    }

    private <V> V executeMethodOnClass(Class<?> targetClass, String methodName, Object[] args) {
        try {
            MethodInvokerResult result = this.client.executeMethodOnClass(targetClass.getName(), methodName, args);
            if (result.exceptionOccurred()) {
                throw new RMIException(this, targetClass.getName(), methodName, result.getException(), result.getStackTrace());
            }
            return (V)result.getResult();
        }
        catch (RemoteException exception) {
            throw new RMIException(this, targetClass.getName(), methodName, exception);
        }
    }
}

