/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Properties;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.junit.rules.Locator;
import org.apache.geode.test.junit.rules.MemberStarterRule;
import org.junit.Assert;

public class LocatorStarterRule
extends MemberStarterRule<LocatorStarterRule>
implements Locator {
    private transient InternalLocator locator;

    @Override
    public void before() {
        super.before();
        if (this.jmxPort < 0) {
            this.withJMXManager(false);
        }
        if (this.autoStart) {
            this.startLocator();
        }
    }

    @Override
    public InternalLocator getLocator() {
        return this.locator;
    }

    @Override
    protected void stopMember() {
        if (this.locator != null) {
            this.locator.stop();
        }
    }

    public void startLocator() {
        try {
            this.locator = (InternalLocator)org.apache.geode.distributed.Locator.startLocatorAndDS((int)this.memberPort, null, (Properties)this.properties);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.memberPort = this.locator.getPort();
        DistributionConfigImpl config = this.locator.getConfig();
        this.jmxPort = config.getJmxManagerPort();
        this.httpPort = config.getHttpServicePort();
        if (config.getEnableClusterConfiguration()) {
            GeodeAwaitility.await().untilAsserted(() -> Assert.assertTrue((boolean)this.locator.isSharedConfigurationRunning()));
        }
    }

    public LocatorStarterRule withoutClusterConfigurationService() {
        this.properties.put("enable-cluster-configuration", "false");
        return this;
    }

    public LocatorStarterRule withoutManagementRestService() {
        this.properties.put("enable-management-rest-service", "false");
        return this;
    }

    @Override
    public InternalCache getCache() {
        return this.locator.getCache();
    }

    @Override
    public void waitTilFullyReconnected() {
        try {
            GeodeAwaitility.await().until(() -> {
                InternalLocator intLocator = ClusterStartupRule.getLocator();
                InternalCache cache = ClusterStartupRule.getCache();
                return intLocator != null && cache != null && intLocator.getDistributedSystem().isConnected() && intLocator.isReconnected();
            });
        }
        catch (Exception e) {
            InternalLocator intLocator = ClusterStartupRule.getLocator();
            InternalCache cache = ClusterStartupRule.getCache();
            DistributedSystem ds = intLocator.getDistributedSystem();
            System.out.println("locator is: " + (intLocator != null ? "not null" : "null"));
            System.out.println("cache is: " + (cache != null ? "not null" : "null"));
            if (ds != null) {
                System.out.println("distributed system is: " + (ds.isConnected() ? "connected" : "not connected"));
            } else {
                System.out.println("distributed system is: null");
            }
            System.out.println("locator is reconnected: " + intLocator.isReconnected());
            throw e;
        }
    }
}

