/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.generator;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.security.generator.LdapUserCredentialGenerator;
import org.apache.geode.security.generator.PKCSCredentialGenerator;
import org.apache.geode.security.templates.DummyAuthenticator;
import org.apache.geode.security.templates.LdapUserAuthenticator;
import org.apache.geode.security.templates.PKCSAuthenticator;
import org.apache.logging.log4j.Logger;

public abstract class CredentialGenerator {
    private static final Logger logger = LogService.getLogger();
    private Properties systemProperties = null;
    protected Properties javaProperties = null;

    public static CredentialGenerator create(ClassCode classCode) {
        switch (classCode.classType) {
            case 2: {
                return new LdapUserCredentialGenerator();
            }
            case 3: {
                return new PKCSCredentialGenerator();
            }
        }
        return null;
    }

    public void init() throws IllegalArgumentException {
        this.systemProperties = this.initialize();
        logger.info("Generating CredentialGenerator with {}", (Object)this.systemProperties);
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public Properties getJavaProperties() {
        return this.javaProperties;
    }

    public abstract ClassCode classCode();

    public abstract String getAuthInit();

    public abstract String getAuthenticator();

    public abstract Properties getValidCredentials(int var1);

    public abstract Properties getValidCredentials(Principal var1);

    public abstract Properties getInvalidCredentials(int var1);

    protected abstract Properties initialize() throws IllegalArgumentException;

    public static class ClassCode {
        private static byte nextOrdinal = 0;
        private static final byte ID_DUMMY = 1;
        private static final byte ID_LDAP = 2;
        private static final byte ID_PKCS = 3;
        private static final byte ID_SSL = 4;
        private static final ClassCode[] VALUES = new ClassCode[10];
        private static final Map CODE_NAME_MAP = new HashMap();
        public static final ClassCode DUMMY = new ClassCode(DummyAuthenticator.class.getName() + ".create", 1);
        public static final ClassCode LDAP = new ClassCode(LdapUserAuthenticator.class.getName() + ".create", 2);
        public static final ClassCode PKCS = new ClassCode(PKCSAuthenticator.class.getName() + ".create", 3);
        public static final ClassCode SSL = new ClassCode("SSL", 4);
        private final String name;
        private final byte ordinal;
        private final byte classType;

        private ClassCode(String name, byte classType) {
            this.name = name;
            this.classType = classType;
            byte by = nextOrdinal;
            nextOrdinal = (byte)(by + 1);
            this.ordinal = by;
            ClassCode.VALUES[this.ordinal] = this;
            CODE_NAME_MAP.put(name, this);
        }

        public boolean isDummy() {
            return this.classType == 1;
        }

        public boolean isLDAP() {
            return this.classType == 2;
        }

        public boolean isPKCS() {
            return this.classType == 3;
        }

        public boolean isSSL() {
            return this.classType == 4;
        }

        public static ClassCode fromOrdinal(byte ordinal) {
            return VALUES[ordinal];
        }

        public static ClassCode parse(String operationName) {
            return (ClassCode)CODE_NAME_MAP.get(operationName);
        }

        public static List getAll() {
            ArrayList codes = new ArrayList();
            Iterator iter = CODE_NAME_MAP.values().iterator();
            while (iter.hasNext()) {
                codes.add(iter.next());
            }
            return codes;
        }

        public byte toOrdinal() {
            return this.ordinal;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClassCode)) {
                return false;
            }
            ClassCode other = (ClassCode)obj;
            return other.ordinal == this.ordinal;
        }

        public boolean equals(ClassCode opCode) {
            return opCode != null && opCode.ordinal == this.ordinal;
        }

        public int hashCode() {
            return this.ordinal;
        }
    }
}

