/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.test.junit.assertions.CommandResultAssert;
import org.apache.geode.test.junit.categories.GfshTest;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.Server;
import org.apache.geode.test.junit.rules.ServerStarterRule;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={GfshTest.class})
public class QueryCommandIntegrationTestBase {
    private final String DEFAULT_FETCH_SIZE = String.valueOf(100);
    @ClassRule
    public static ServerStarterRule server = ((ServerStarterRule)((ServerStarterRule)new ServerStarterRule().withJMXManager()).withHttpService()).withRegion(RegionShortcut.REPLICATE, "simpleRegion").withRegion(RegionShortcut.REPLICATE, "complexRegion");
    @Rule
    public GfshCommandRule gfsh = new GfshCommandRule();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @BeforeClass
    public static void populateRegions() {
        InternalCache cache = server.getCache();
        Region simpleRegion = cache.getRegion("simpleRegion");
        Region complexRegion = cache.getRegion("complexRegion");
        for (int i = 0; i < 101; ++i) {
            String key = "key" + i;
            simpleRegion.put((Object)key, (Object)("value" + i));
            complexRegion.put((Object)key, (Object)new Customer("name" + i, "Main Street " + i, "Hometown"));
        }
    }

    @Before
    public void before() throws Exception {
        this.connect(server);
    }

    protected void connect(Server server) throws Exception {
        this.gfsh.connectAndVerify(server.getJmxPort(), GfshCommandRule.PortType.jmxManager, new String[0]);
    }

    @Test
    public void doesShowLimitIfLimitNotInQuery() throws Exception {
        this.gfsh.executeAndAssertThat("query --query='select * from /simpleRegion'").containsKeyValuePair("Rows", this.DEFAULT_FETCH_SIZE).containsKeyValuePair("Limit", this.DEFAULT_FETCH_SIZE).hasResult();
    }

    @Test
    public void doesNotShowLimitIfLimitInQuery() throws Exception {
        this.gfsh.executeAndAssertThat("query --query='select * from /simpleRegion limit 50'").containsKeyValuePair("Rows", "50").doesNotContainOutput(new String[]{"Limit"}).hasResult();
    }

    @Test
    public void invalidQueryShouldNotCreateFile() throws Exception {
        File outputFile = this.temporaryFolder.newFile("queryOutput.txt");
        FileUtils.deleteQuietly((File)outputFile);
        this.gfsh.executeAndAssertThat("query --query='invalid query' --file=" + outputFile.getAbsolutePath()).hasNoResult().doesNotContainOutput(new String[]{"Query results output to"});
        Assertions.assertThat((File)outputFile).doesNotExist();
    }

    @Test
    public void queryWithInvalidRegionNameDoesNotCreateFile() throws Exception {
        File outputFile = this.temporaryFolder.newFile("queryOutput.txt");
        FileUtils.deleteQuietly((File)outputFile);
        this.gfsh.executeAndAssertThat("query --query='select * from /nonExistentRegion' --file=" + outputFile.getAbsolutePath()).hasNoResult().doesNotContainOutput(new String[]{"Query results output to"});
        Assertions.assertThat((File)outputFile).doesNotExist();
    }

    @Test
    public void outputToFileStillDisplaysResultMetaData() throws Exception {
        File outputFile = this.temporaryFolder.newFile("queryOutput.txt");
        FileUtils.deleteQuietly((File)outputFile);
        this.gfsh.executeAndAssertThat("query --query='select * from /simpleRegion' --file=" + outputFile.getAbsolutePath()).hasResult().containsOutput(new String[]{"Rows"}).containsOutput(new String[]{"Limit"}).containsOutput(new String[]{"Query results output to"});
    }

    @Test
    public void doesNotOverwriteExistingFile() throws Exception {
        File outputFile = this.temporaryFolder.newFile("queryOutput.txt");
        Assertions.assertThat((File)outputFile).exists();
        this.gfsh.executeAndAssertThat("query --query='select * from /simpleRegion' --file=" + outputFile.getAbsolutePath()).statusIsError().containsOutput(new String[]{"The specified output file already exists."});
    }

    @Test
    public void canOutputSimpleRegionToFile() throws Exception {
        File outputFile = this.temporaryFolder.newFile("queryOutput.txt");
        FileUtils.deleteQuietly((File)outputFile);
        this.gfsh.executeAndAssertThat("query --query='select * from /simpleRegion' --file=" + outputFile.getAbsolutePath()).statusIsSuccess();
        Assertions.assertThat((File)outputFile).exists();
        List lines = Files.readLines((File)outputFile, (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((String)((String)lines.get(3))).isEqualTo((Object)"Result");
        Assertions.assertThat((String)((String)lines.get(4))).isEqualTo((Object)"--------");
        lines.subList(6, lines.size()).forEach(line -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)line).matches((CharSequence)"value\\d+");
        });
    }

    @Test
    public void canOutputComplexRegionToFile() throws Exception {
        File outputFile = this.temporaryFolder.newFile("queryOutput.txt");
        FileUtils.deleteQuietly((File)outputFile);
        this.gfsh.executeAndAssertThat("query --query='select c.name, c.address from /complexRegion c' --file=" + outputFile.getAbsolutePath()).statusIsSuccess().containsOutput(new String[]{outputFile.getAbsolutePath()});
        Assertions.assertThat((File)outputFile).exists();
        List lines = Files.readLines((File)outputFile, (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((String)((String)lines.get(3))).containsPattern((CharSequence)"name\\s+\\|\\s+address");
        lines.subList(5, lines.size()).forEach(line -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)line).matches((CharSequence)"name\\d+.*\"city\":\"Hometown\".*");
        });
    }

    @Test
    public void outputDisplaysResultsFromComplexRegion() throws Exception {
        String result = this.gfsh.execute("query --query='select c.name, c.address from /complexRegion c'");
        String[] resultLines = this.splitOnLineBreaks(result);
        Assertions.assertThat((String)resultLines[0]).containsPattern((CharSequence)"Result\\s+:\\s+true");
        Assertions.assertThat((String)resultLines[1]).containsPattern((CharSequence)"Limit\\s+:\\s+100");
        Assertions.assertThat((String)resultLines[2]).containsPattern((CharSequence)"Rows\\s+:\\s+100");
        Assertions.assertThat((String)resultLines[3]).containsPattern((CharSequence)"name\\s+\\|\\s+address");
        Arrays.asList(resultLines).subList(5, resultLines.length).forEach(line -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)line).matches((CharSequence)"name\\d+.*\"city\":\"Hometown\".*");
        });
    }

    @Test
    public void queryWithGfshEnvVariables() {
        this.gfsh.executeAndAssertThat("set variable --name=DATA_REGION --value=/complexRegion").statusIsSuccess();
        this.gfsh.executeAndAssertThat("set variable --name=QUERY_LIMIT --value=10").statusIsSuccess();
        this.gfsh.executeAndAssertThat("query --query='select c.name, c.address from ${DATA_REGION} c limit ${QUERY_LIMIT}'").hasDataSection("data-info").hasContent().containsEntry((Object)"Rows", (Object)"10");
    }

    @Test
    public void queryWithInvalidRegionNameGivesDescriptiveErrorMessage() throws Exception {
        this.gfsh.executeAndAssertThat("query --query='select * from /nonExistentRegion'").containsKeyValuePair("Result", "false").containsOutput(new String[]{"Cannot find regions <[/nonExistentRegion]> in any of the members"});
    }

    @Test
    public void invalidQueryGivesDescriptiveErrorMessage() {
        ((MapAssert)this.gfsh.executeAndAssertThat("query --query='this is not a valid query'").hasDataSection("data-info").hasContent().containsEntry((Object)"Result", (Object)"false")).containsEntry((Object)"Message", (Object)"Query is invalid due to error : <Syntax error in query: unexpected token: is>");
    }

    @Test
    public void queryGivesDescriptiveErrorMessageIfNoQueryIsSpecified() {
        this.gfsh.executeAndAssertThat("query").containsOutput(new String[]{"You should specify option (--query, --file, --interactive) for this command"});
    }

    @Test
    public void queryReturnsUndefinedQueryResult() {
        this.gfsh.executeAndAssertThat("query --query='select c.unknown from /complexRegion c limit 10'").hasTableSection("query").hasRowSize(10).hasRow(0).containsExactly((Object[])new String[]{"UNDEFINED"});
    }

    @Test
    public void queryReturnsNonSelectResult() {
        CommandResultAssert commandResultAssert = this.gfsh.executeAndAssertThat("query --query=\"(select c.address from /complexRegion c where c.name = 'name1' limit 1).size\"");
        commandResultAssert.hasDataSection("data-info").hasContent().containsEntry((Object)"Rows", (Object)"1");
        commandResultAssert.hasTableSection("query").hasRowSize(1).hasRow(0).contains((Object[])new String[]{"1"});
    }

    private String[] splitOnLineBreaks(String multilineString) {
        return multilineString.split("[\\r\\n]+");
    }

    public static class Address
    implements Serializable {
        public String street;
        public String city;

        public Address(String street, String city) {
            this.street = street;
            this.city = city;
        }
    }

    public static class Customer
    implements Serializable {
        public String name;
        public Address address;

        public Customer(String name, String street, String city) {
            this.name = name;
            this.address = new Address(street, city);
        }

        public String toString() {
            return this.name + this.address;
        }
    }
}

