/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.classloader.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.classloader.ClasspathService;
import org.apache.geode.internal.classloader.DeployJarChildFirstClassLoader;
import org.apache.geode.internal.deployment.JarDeploymentService;
import org.apache.geode.internal.util.CollectionUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.internal.utils.JarFileUtils;
import org.apache.logging.log4j.Logger;

public class LegacyClasspathServiceImpl
implements ClasspathService {
    private static final Logger logger = LogService.getLogger();
    private final Map<String, DeployJarChildFirstClassLoader> artifactIdsToClassLoader = new HashMap<String, DeployJarChildFirstClassLoader>();
    private volatile DeployJarChildFirstClassLoader leafLoader;
    private boolean excludeTCCL;
    private JarDeploymentService jarDeploymentService;

    public void init(boolean excludeTCCL, JarDeploymentService jarDeploymentService) {
        this.excludeTCCL = excludeTCCL;
        this.jarDeploymentService = jarDeploymentService;
        this.rebuildClassLoaderForDeployedJars();
    }

    public synchronized void chainClassloader(File jar) {
        try {
            this.leafLoader = new DeployJarChildFirstClassLoader(this.artifactIdsToClassLoader, new URL[]{jar.toURI().toURL()}, JarFileUtils.toArtifactId((String)jar.getName()), this.getLeafLoader());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public synchronized void unloadClassloaderForArtifact(String artifactId) {
        this.artifactIdsToClassLoader.put(artifactId, null);
    }

    public void close() {
        this.leafLoader = null;
        this.artifactIdsToClassLoader.clear();
    }

    public URL getResource(Class<?> contextClass, String name) {
        URL url;
        if (contextClass != null && (url = contextClass.getResource(name)) != null) {
            return url;
        }
        return this.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputStream getResourceAsStream(Class<?> contextClass, String name) {
        InputStream is;
        if (contextClass != null && (is = contextClass.getResourceAsStream(name)) != null) {
            return is;
        }
        return this.getResourceAsStream(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedHashSet urls = new LinkedHashSet();
        for (ClassLoader classLoader : this.getClassLoaders()) {
            Enumeration<URL> resources = classLoader.getResources(name);
            if (resources == null || !resources.hasMoreElements()) continue;
            CollectionUtils.addAll(urls, resources);
        }
        return Collections.enumeration(urls);
    }

    public URL getResource(String name) {
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (isTraceEnabled) {
            logger.trace("getResource({})", (Object)name);
        }
        for (ClassLoader classLoader : this.getClassLoaders()) {
            if (isTraceEnabled) {
                logger.trace("getResource trying: {}", (Object)classLoader);
            }
            try {
                URL url = classLoader.getResource(name);
                if (url == null) continue;
                if (isTraceEnabled) {
                    logger.trace("getResource found by: {}", (Object)classLoader);
                }
                return url;
            }
            catch (SecurityException securityException) {
            }
        }
        return null;
    }

    public Class<?> forName(String name) throws ClassNotFoundException {
        Class<?> clazz;
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (isTraceEnabled) {
            logger.trace("forName({})", (Object)name);
        }
        if ((clazz = this.forName(name, isTraceEnabled)) != null) {
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> forName(String name, boolean isTraceEnabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            if (isTraceEnabled) {
                logger.trace("forName trying: {}", (Object)classLoader);
            }
            try {
                if (classLoader instanceof DeployJarChildFirstClassLoader && ((DeployJarChildFirstClassLoader)classLoader).thisIsOld()) {
                    return null;
                }
                Class<?> clazz = Class.forName(name, true, classLoader);
                if (isTraceEnabled) {
                    logger.trace("forName found by: {}", (Object)classLoader);
                }
                return clazz;
            }
            catch (ClassNotFoundException | SecurityException exception) {
            }
        }
        return null;
    }

    public Class<?> getProxyClass(Class<?> ... classObjs) {
        IllegalArgumentException ex = null;
        for (ClassLoader classLoader : this.getClassLoaders()) {
            try {
                return Proxy.getProxyClass(classLoader, classObjs);
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException iaex) {
                ex = iaex;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return null;
    }

    public ClassLoader getClassloaderForArtifact(String artifactId) {
        return (ClassLoader)this.artifactIdsToClassLoader.get(artifactId);
    }

    private synchronized void rebuildClassLoaderForDeployedJars() {
        this.leafLoader = null;
        List deployments = this.jarDeploymentService.listDeployed();
        for (Deployment deployment : deployments) {
            this.chainClassloader(deployment.getFile());
        }
    }

    private ClassLoader getLeafLoader() {
        if (this.leafLoader == null) {
            return ClassPathLoader.class.getClassLoader();
        }
        return this.leafLoader;
    }

    private List<ClassLoader> getClassLoaders() {
        ClassLoader tccl;
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        if (!this.excludeTCCL && (tccl = Thread.currentThread().getContextClassLoader()) != null) {
            classLoaders.add(tccl);
        }
        classLoaders.add(this.getLeafLoader());
        return classLoaders;
    }

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "{excludeTCCL=" + this.excludeTCCL + ", jarDeployer=" + String.valueOf(this.jarDeploymentService) + ", classLoaders=[" + this.getClassLoaders().stream().map(Object::toString).collect(Collectors.joining(", ")) + "]}";
    }
}

