/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.BaseCQCommand;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;

public class MonitorCQ
extends BaseCQCommand {
    private static final MonitorCQ singleton = new MonitorCQ();

    public static Command getCommand() {
        return singleton;
    }

    private MonitorCQ() {
    }

    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        int op = clientMessage.getPart(0).getInt();
        if (op < 1) {
            String err = LocalizedStrings.MonitorCQ__0_THE_MONITORCQ_OPERATION_IS_INVALID.toLocalizedString(new Object[]{serverConnection.getName()});
            this.sendCqResponse(47, err, clientMessage.getTransactionId(), null, serverConnection);
            return;
        }
        String regionName = null;
        if (clientMessage.getNumberOfParts() == 2 && (regionName = clientMessage.getPart(1).getString()) == null) {
            String err = LocalizedStrings.MonitorCQ__0_A_NULL_REGION_NAME_WAS_PASSED_FOR_MONITORCQ_OPERATION.toLocalizedString(new Object[]{serverConnection.getName()});
            this.sendCqResponse(47, err, clientMessage.getTransactionId(), null, serverConnection);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received MonitorCq request from {} op: {}{}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)op, (Object)(regionName != null ? " RegionName: " + regionName : ""));
        }
        securityService.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ);
        try {
            CqService cqService = crHelper.getCache().getCqService();
            cqService.start();
            throw new CqException(LocalizedStrings.CqService_INVALID_CQ_MONITOR_REQUEST_RECEIVED.toLocalizedString());
        }
        catch (CqException cqe) {
            this.sendCqResponse(50, "", clientMessage.getTransactionId(), cqe, serverConnection);
        }
        catch (Exception e) {
            String err = LocalizedStrings.MonitorCQ_EXCEPTION_WHILE_HANDLING_THE_MONITOR_REQUEST_OP_IS_0.toLocalizedString(new Object[]{op});
            this.sendCqResponse(50, err, clientMessage.getTransactionId(), e, serverConnection);
        }
    }
}

