/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.cq;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.query.CqClosedException;
import org.apache.geode.cache.query.CqEvent;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqState;
import org.apache.geode.cache.query.CqStatistics;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledRegion;
import org.apache.geode.cache.query.internal.CompiledSelect;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.CqQueryVsdStats;
import org.apache.geode.cache.query.internal.CqStateImpl;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.CqServiceImpl;
import org.apache.geode.cache.query.internal.cq.CqStatisticsImpl;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public abstract class CqQueryImpl
implements InternalCqQuery {
    private static final Logger logger = LogService.getLogger();
    protected String cqName;
    protected String queryString;
    protected static final Object TOKEN = new Object();
    protected LocalRegion cqBaseRegion;
    protected Query query = null;
    protected InternalLogWriter securityLogWriter;
    protected CqServiceImpl cqService;
    protected String regionName;
    protected boolean isDurable = false;
    protected CqStatisticsImpl cqStats;
    protected CqQueryVsdStats stats;
    protected final CqStateImpl cqState = new CqStateImpl();
    protected ExecutionContext queryExecutionContext = null;
    public static TestHook testHook = null;

    public CqQueryImpl() {
    }

    public CqQueryImpl(CqServiceImpl cqService, String cqName, String queryString, boolean isDurable) {
        this.cqName = cqName;
        this.queryString = queryString;
        this.securityLogWriter = (InternalLogWriter)cqService.getCache().getSecurityLoggerI18n();
        this.cqService = cqService;
        this.isDurable = isDurable;
    }

    public String getName() {
        return this.cqName;
    }

    public void setName(String cqName) {
        this.cqName = cqName;
    }

    public void setCqService(CqService cqService) {
        this.cqService = (CqServiceImpl)cqService;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void updateCqCreateStats() {
        DistributedSystem factory = this.cqService.getCache().getDistributedSystem();
        this.stats = new CqQueryVsdStats((StatisticsFactory)factory, this.getServerCqName());
        this.cqStats = new CqStatisticsImpl(this);
        this.cqService.stats.incCqsStopped();
        this.cqService.stats.incCqsCreated();
        this.cqService.stats.incCqsOnClient();
    }

    public void validateCq() {
        List fromClause;
        Cache cache = this.cqService.getCache();
        DefaultQuery locQuery = (DefaultQuery)((GemFireCacheImpl)cache).getLocalQueryService().newQuery(this.queryString);
        this.query = locQuery;
        Object[] parameters = new Object[]{};
        CompiledSelect select = locQuery.getSimpleSelect();
        if (select == null) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_CQ_QUERIES_MUST_BE_A_SELECT_STATEMENT_ONLY.toLocalizedString());
        }
        if (select.isDistinct()) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_SELECT_DISTINCT_QUERIES_NOT_SUPPORTED_IN_CQ.toLocalizedString());
        }
        Set regionsInQuery = locQuery.getRegionsInQuery(parameters);
        if (regionsInQuery.size() > 1 || regionsInQuery.size() < 1) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_CQ_QUERIES_MUST_REFERENCE_ONE_AND_ONLY_ONE_REGION.toLocalizedString());
        }
        this.regionName = (String)regionsInQuery.iterator().next();
        HashSet regions = new HashSet();
        CompiledValue whereClause = select.getWhereClause();
        if (whereClause != null) {
            whereClause.getRegionsInQuery(regions, parameters);
            if (!regions.isEmpty()) {
                throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_THE_WHERE_CLAUSE_IN_CQ_QUERIES_CANNOT_REFER_TO_A_REGION.toLocalizedString());
            }
        }
        if ((fromClause = select.getIterators()).size() > 1) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_CQ_QUERIES_CANNOT_HAVE_MORE_THAN_ONE_ITERATOR_IN_THE_FROM_CLAUSE.toLocalizedString());
        }
        CompiledIteratorDef itrDef = (CompiledIteratorDef)fromClause.get(0);
        if (!(itrDef.getCollectionExpr() instanceof CompiledRegion)) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_CQ_QUERIES_MUST_HAVE_A_REGION_PATH_ONLY_AS_THE_FIRST_ITERATOR_IN_THE_FROM_CLAUSE.toLocalizedString());
        }
        List projs = select.getProjectionAttributes();
        if (projs != null) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_CQ_QUERIES_DO_NOT_SUPPORT_PROJECTIONS.toLocalizedString());
        }
        List orderBys = select.getOrderByAttrs();
        if (orderBys != null) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_CQ_QUERIES_DO_NOT_SUPPORT_ORDER_BY.toLocalizedString());
        }
        this.setQueryExecutionContext((ExecutionContext)new QueryExecutionContext(null, this.cqService.getCache()));
    }

    protected void removeFromCqMap() throws CqException {
        try {
            this.cqService.removeCq(this.getServerCqName());
        }
        catch (Exception ex) {
            StringId errMsg = LocalizedStrings.CqQueryImpl_FAILED_TO_REMOVE_CONTINUOUS_QUERY_FROM_THE_REPOSITORY_CQNAME_0_ERROR_1;
            Object[] errMsgArgs = new Object[]{this.cqName, ex.getLocalizedMessage()};
            String msg = errMsg.toLocalizedString(errMsgArgs);
            logger.error(msg);
            throw new CqException(msg, (Throwable)ex);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Removed CQ from the CQ repository. CQ Name: {}", (Object)this.cqName);
        }
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Query getQuery() {
        return this.query;
    }

    public CqStatistics getStatistics() {
        return this.cqStats;
    }

    public LocalRegion getCqBaseRegion() {
        return this.cqBaseRegion;
    }

    protected abstract void cleanup() throws CqException;

    public String getBaseRegionName() {
        return this.regionName;
    }

    public abstract String getServerCqName();

    public CqState getState() {
        return this.cqState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCqState(int state) {
        if (this.isClosed()) {
            throw new CqClosedException(LocalizedStrings.CqQueryImpl_CQ_IS_CLOSED_CQNAME_0.toLocalizedString(new Object[]{this.cqName}));
        }
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (state == 1) {
                if (this.isRunning()) {
                    // empty if block
                }
                this.cqState.setState(1);
                this.cqService.stats.incCqsActive();
                this.cqService.stats.decCqsStopped();
            } else if (state == 0) {
                this.cqState.setState(0);
                this.cqService.stats.incCqsStopped();
                this.cqService.stats.decCqsActive();
            } else if (state == 3) {
                this.cqState.setState(state);
            }
        }
    }

    public void updateStats(CqEvent cqEvent) {
        this.stats.updateStats(cqEvent);
    }

    public boolean isRunning() {
        return this.cqState.isRunning();
    }

    public boolean isStopped() {
        return this.cqState.isStopped();
    }

    public boolean isClosed() {
        return this.cqState.isClosed();
    }

    public boolean isClosing() {
        return this.cqState.isClosing();
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    public CqQueryVsdStats getVsdStats() {
        return this.stats;
    }

    public ExecutionContext getQueryExecutionContext() {
        return this.queryExecutionContext;
    }

    public void setQueryExecutionContext(ExecutionContext queryExecutionContext) {
        this.queryExecutionContext = queryExecutionContext;
    }

    public static interface TestHook {
        public void pauseUntilReady();

        public void ready();

        public int numQueuedEvents();

        public void setEventCount(int var1);
    }
}

