/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.ListDriversFunction;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class ListDriversCommand
extends GfshCommand {
    static final String LIST_DRIVERS = "list drivers";
    static final String LIST_DRIVERS__HELP = "(Experimental) Lists all drivers currently registered by the cluster's Driver Manager.";
    static final String NO_MEMBERS_FOUND = "No members found";
    static final String MEMBER_NAME_NOT_FOUND = "No member found with name: ";
    static final String LIST_DRIVERS_SECTION = "LIST_DRIVERS";
    static final String MEMBER_NAME = "member-name";
    static final String MEMBER_NAME__HELP = "Name of specific member to list drivers for.";

    @ShellMethod(value="(Experimental) Lists all drivers currently registered by the cluster's Driver Manager.", key={"list drivers"})
    @CliMetaData
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel listDrivers(@ShellOption(value={"member-name"}, defaultValue="__NULL__", help="Name of specific member to list drivers for.") String memberName) {
        ResultModel resultModel = new ResultModel();
        return this.createTabularResultDataAndGetResult(resultModel, memberName);
    }

    private ResultModel createTabularResultDataAndGetResult(ResultModel resultModel, String memberName) {
        TabularResultModel tableModel = resultModel.addTable(LIST_DRIVERS_SECTION);
        List<Object> drivers = new ArrayList();
        Set targetMembers = this.findMembers(null, null);
        if (targetMembers.size() > 0) {
            Object[] arguments = new Object[]{};
            List listDriversResults = this.executeAndGetFunctionResult((Function)new ListDriversFunction(), arguments, targetMembers);
            if (memberName == null) {
                return ResultModel.createMemberStatusResult((List)listDriversResults, (String)"(Experimental) ", null, (boolean)false, (boolean)true);
            }
            for (CliFunctionResult result : listDriversResults) {
                if (!memberName.equals(result.getMemberIdOrName())) continue;
                if (result.isSuccessful()) {
                    drivers = this.getListOfDrivers(result);
                    continue;
                }
                return ResultModel.createError((String)("Error when listing drivers: " + result.getStatusMessage()));
            }
            if (drivers.isEmpty()) {
                return ResultModel.createError((String)("(Experimental) \nNo member found with name: " + memberName));
            }
        } else {
            return ResultModel.createInfo((String)"(Experimental) \nNo members found");
        }
        for (String driver : drivers) {
            tableModel.accumulate("Driver names for: " + memberName, driver);
        }
        return resultModel;
    }

    List<String> getListOfDrivers(CliFunctionResult listDriversResult) {
        return (List)listDriversResult.getResultObject();
    }
}

