/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.CreateJndiBindingCommand;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

@Experimental
public class DescribeDataSourceCommand
extends GfshCommand {
    static final String DESCRIBE_DATA_SOURCE = "describe data-source";
    private static final String DESCRIBE_DATA_SOURCE__HELP = "(Experimental) Describe the configuration of the given data source.";
    static final String DATA_SOURCE_PROPERTIES_SECTION = "data-source-properties";
    static final String REGIONS_USING_DATA_SOURCE_SECTION = "regions-using-data-source";

    @ShellMethod(value="(Experimental) Describe the configuration of the given data source.", key={"describe data-source"})
    @CliMetaData
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel describeDataSource(@ShellOption(value={"name"}, help="Name of the data source to describe") String dataSourceName) {
        boolean pooled;
        ResultModel resultModel = new ResultModel();
        resultModel.setHeader("(Experimental) ");
        TabularResultModel tabularData = resultModel.addTable(DATA_SOURCE_PROPERTIES_SECTION);
        InternalConfigurationPersistenceService ccService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (ccService == null) {
            return ResultModel.createError((String)"Cluster configuration service must be enabled.");
        }
        CacheConfig cacheConfig = ccService.getCacheConfig(null);
        if (cacheConfig == null) {
            return ResultModel.createError((String)String.format("Data source: %s not found", dataSourceName));
        }
        List jndiBindings = cacheConfig.getJndiBindings();
        JndiBindingsType.JndiBinding binding = jndiBindings.stream().filter(b -> b.getJndiName().equals(dataSourceName)).findFirst().orElse(null);
        if (binding == null) {
            return ResultModel.createError((String)String.format("Data source: %s not found", dataSourceName));
        }
        String type = binding.getType();
        if (CreateJndiBindingCommand.DATASOURCE_TYPE.SIMPLE.getType().equals(type)) {
            pooled = false;
        } else if (CreateJndiBindingCommand.DATASOURCE_TYPE.POOLED.getType().equals(type)) {
            pooled = true;
        } else {
            return ResultModel.createError((String)String.format("Unknown data source type: %s", type));
        }
        this.addTableRow(tabularData, "name", binding.getJndiName());
        this.addTableRow(tabularData, "url", binding.getConnectionUrl());
        this.addTableRow(tabularData, "username", binding.getUserName());
        this.addTableRow(tabularData, "pooled", Boolean.toString(pooled));
        if (pooled) {
            this.addTableRow(tabularData, "pooled-data-source-factory-class", binding.getConnPooledDatasourceClass());
            for (JndiBindingsType.JndiBinding.ConfigProperty confProp : binding.getConfigProperties()) {
                this.addTableRow(tabularData, confProp.getName(), confProp.getValue());
            }
        }
        InfoResultModel regionsUsingSection = resultModel.addInfo(REGIONS_USING_DATA_SOURCE_SECTION);
        List<String> regionsUsing = this.getRegionsThatUseDataSource(cacheConfig, dataSourceName);
        regionsUsingSection.setHeader("Regions Using Data Source:");
        if (regionsUsing.isEmpty()) {
            regionsUsingSection.addLine("no regions are using " + dataSourceName);
        } else {
            regionsUsingSection.setContent(regionsUsing);
        }
        return resultModel;
    }

    List<String> getRegionsThatUseDataSource(CacheConfig cacheConfig, String dataSourceName) {
        return cacheConfig.getRegions().stream().filter(regionConfig -> this.hasJdbcMappingThatUsesDataSource((RegionConfig)regionConfig, dataSourceName)).map(RegionConfig::getName).collect(Collectors.toList());
    }

    private boolean hasJdbcMappingThatUsesDataSource(RegionConfig regionConfig, String dataSourceName) {
        return regionConfig.getCustomRegionElements().stream().anyMatch(cacheElement -> this.isRegionMappingUsingDataSource((CacheElement)cacheElement, dataSourceName));
    }

    private boolean isRegionMappingUsingDataSource(CacheElement cacheElement, String dataSourceName) {
        if (!(cacheElement instanceof RegionMapping)) {
            return false;
        }
        RegionMapping regionMapping = (RegionMapping)cacheElement;
        return dataSourceName.equals(regionMapping.getDataSourceName());
    }

    private void addTableRow(TabularResultModel table, String property, String value) {
        table.accumulate("Property", property);
        table.accumulate("Value", value != null ? value : "");
    }

    @ShellMethodAvailability(value={"describe data-source"})
    public boolean commandAvailable() {
        return this.isOnlineCommandAvailable();
    }
}

