/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.ArrayList;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.connectors.jdbc.internal.cli.PreconditionException;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.connectors.util.internal.MappingCommandUtils;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class ListMappingCommand
extends GfshCommand {
    public static final String JDBC_MAPPINGS_SECTION = "jdbc-mappings";
    static final String LIST_MAPPING = "list jdbc-mappings";
    static final String LIST_MAPPING__HELP = "(Experimental) Display JDBC mappings for all members.";
    static final String LIST_OF_MAPPINGS = "List of JDBC mappings";
    static final String NO_MAPPINGS_FOUND = "No JDBC mappings found";
    private static final String LIST_MAPPING__GROUPS_NAME__HELP = "Server Group(s) of the JDBC mappings to list.";

    @CliCommand(value={"list jdbc-mappings"}, help="(Experimental) Display JDBC mappings for all members.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel listMapping(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Server Group(s) of the JDBC mappings to list.") String[] groups) {
        ArrayList<RegionMapping> mappings = new ArrayList<RegionMapping>();
        try {
            ConfigurationPersistenceService configService = this.checkForClusterConfiguration();
            if (groups == null) {
                groups = new String[]{"cluster"};
            }
            for (String group : groups) {
                CacheConfig cacheConfig = this.getCacheConfig(configService, group);
                for (RegionConfig regionConfig : cacheConfig.getRegions()) {
                    mappings.addAll(MappingCommandUtils.getMappingsFromRegionConfig(cacheConfig, regionConfig, group));
                }
            }
        }
        catch (PreconditionException ex) {
            return ResultModel.createError((String)ex.getMessage());
        }
        ResultModel resultModel = new ResultModel();
        boolean mappingsExist = this.fillTabularResultData(mappings, resultModel.addTable(JDBC_MAPPINGS_SECTION));
        if (mappingsExist) {
            resultModel.setHeader("(Experimental) ");
            return resultModel;
        }
        return ResultModel.createInfo((String)"(Experimental) \nNo JDBC mappings found");
    }

    private boolean fillTabularResultData(ArrayList<RegionMapping> mappings, TabularResultModel tableModel) {
        if (mappings == null) {
            return false;
        }
        for (RegionMapping mapping : mappings) {
            tableModel.accumulate(LIST_OF_MAPPINGS, mapping.getRegionName());
        }
        return !mappings.isEmpty();
    }

    private CacheConfig getCacheConfig(ConfigurationPersistenceService configService, String group) throws PreconditionException {
        CacheConfig result = configService.getCacheConfig(group);
        if (result == null) {
            throw new PreconditionException("Cache Configuration not found" + (group.equals("cluster") ? "." : " for group " + group + "."));
        }
        return result;
    }

    private ConfigurationPersistenceService checkForClusterConfiguration() throws PreconditionException {
        ConfigurationPersistenceService result = this.getConfigurationPersistenceService();
        if (result == null) {
            throw new PreconditionException("Cluster Configuration must be enabled.");
        }
        return result;
    }

    @CliAvailabilityIndicator(value={"list jdbc-mappings"})
    public boolean commandAvailable() {
        return this.isOnlineCommandAvailable();
    }
}

