/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMappingExistsException;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

@Experimental
public class CreateMappingFunction
extends CliFunction<RegionMapping> {
    CreateMappingFunction() {
    }

    public CliFunctionResult executeFunction(FunctionContext<RegionMapping> context) throws Exception {
        JdbcConnectorService service = FunctionContextArgumentProvider.getJdbcConnectorService(context);
        RegionMapping regionMapping = (RegionMapping)context.getArguments();
        this.verifyRegionExists(context, regionMapping);
        this.createRegionMapping(service, regionMapping);
        String member = context.getMemberName();
        String message = "Created JDBC mapping for region " + regionMapping.getRegionName() + " on " + member;
        return new CliFunctionResult(member, true, message);
    }

    private void verifyRegionExists(FunctionContext<RegionMapping> context, RegionMapping regionMapping) {
        String regionName;
        Cache cache = context.getCache();
        if (cache.getRegion(regionName = regionMapping.getRegionName()) == null) {
            throw new IllegalStateException("create jdbc-mapping requires that the region \"" + regionName + "\" exists.");
        }
    }

    void createRegionMapping(JdbcConnectorService service, RegionMapping regionMapping) throws RegionMappingExistsException {
        service.createRegionMapping(regionMapping);
    }
}

