/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.pdx.FieldType;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxInstanceFactory;
import org.apache.geode.pdx.internal.PdxField;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.TypeRegistry;

class SqlToPdxInstanceCreator {
    private final InternalCache cache;
    private final RegionMapping regionMapping;
    private final ResultSet resultSet;
    private final TableMetaDataView tableMetaData;
    private final PdxInstanceFactory factory;

    public SqlToPdxInstanceCreator(InternalCache cache, RegionMapping regionMapping, ResultSet resultSet, TableMetaDataView tableMetaData) {
        this.cache = cache;
        this.regionMapping = regionMapping;
        this.resultSet = resultSet;
        this.tableMetaData = tableMetaData;
        this.factory = this.createPdxInstanceFactory();
    }

    public PdxInstance create() throws SQLException {
        if (!this.resultSet.next()) {
            return null;
        }
        TypeRegistry typeRegistry = this.cache.getPdxRegistry();
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = metaData.getColumnName(i);
            String fieldName = this.regionMapping.getFieldNameForColumn(columnName, typeRegistry);
            FieldType fieldType = this.getFieldType(typeRegistry, fieldName);
            this.writeField(columnName, i, fieldName, fieldType);
        }
        if (this.resultSet.next()) {
            throw new JdbcConnectorException("Multiple rows returned for query: " + this.resultSet.getStatement());
        }
        return this.factory.create();
    }

    private PdxInstanceFactory createPdxInstanceFactory() {
        String valueClassName = this.regionMapping.getPdxName();
        if (valueClassName != null) {
            return this.cache.createPdxInstanceFactory(valueClassName);
        }
        return this.cache.createPdxInstanceFactory("no class", false);
    }

    private void writeField(String columnName, int columnIndex, String fieldName, FieldType fieldType) throws SQLException {
        switch (fieldType) {
            case STRING: {
                this.factory.writeString(fieldName, this.resultSet.getString(columnIndex));
                break;
            }
            case CHAR: {
                char charValue = '\u0000';
                String columnValue = this.resultSet.getString(columnIndex);
                if (columnValue != null && columnValue.length() > 0) {
                    charValue = columnValue.toCharArray()[0];
                }
                this.factory.writeChar(fieldName, charValue);
                break;
            }
            case SHORT: {
                this.factory.writeShort(fieldName, this.resultSet.getShort(columnIndex));
                break;
            }
            case INT: {
                this.factory.writeInt(fieldName, this.resultSet.getInt(columnIndex));
                break;
            }
            case LONG: {
                this.factory.writeLong(fieldName, this.resultSet.getLong(columnIndex));
                break;
            }
            case FLOAT: {
                this.factory.writeFloat(fieldName, this.resultSet.getFloat(columnIndex));
                break;
            }
            case DOUBLE: {
                this.factory.writeDouble(fieldName, this.resultSet.getDouble(columnIndex));
                break;
            }
            case BYTE: {
                this.factory.writeByte(fieldName, this.resultSet.getByte(columnIndex));
                break;
            }
            case BOOLEAN: {
                this.factory.writeBoolean(fieldName, this.resultSet.getBoolean(columnIndex));
                break;
            }
            case DATE: {
                Date sqlDate;
                int columnType = this.tableMetaData.getColumnDataType(columnName);
                switch (columnType) {
                    case 91: {
                        sqlDate = this.resultSet.getDate(columnIndex);
                        break;
                    }
                    case 92: 
                    case 2013: {
                        sqlDate = this.resultSet.getTime(columnIndex);
                        break;
                    }
                    default: {
                        sqlDate = this.resultSet.getTimestamp(columnIndex);
                    }
                }
                Date pdxDate = null;
                if (sqlDate != null) {
                    pdxDate = new Date(sqlDate.getTime());
                }
                this.factory.writeDate(fieldName, pdxDate);
                break;
            }
            case BYTE_ARRAY: {
                byte[] byteData = this.isBlobColumn(columnName) ? this.getBlobData(columnIndex) : this.resultSet.getBytes(columnIndex);
                this.factory.writeByteArray(fieldName, byteData);
                break;
            }
            case BOOLEAN_ARRAY: {
                this.factory.writeBooleanArray(fieldName, this.convertJdbcObjectToJavaType(boolean[].class, this.resultSet.getObject(columnIndex)));
                break;
            }
            case CHAR_ARRAY: {
                this.factory.writeCharArray(fieldName, this.convertJdbcObjectToJavaType(char[].class, this.resultSet.getObject(columnIndex)));
                break;
            }
            case SHORT_ARRAY: {
                this.factory.writeShortArray(fieldName, this.convertJdbcObjectToJavaType(short[].class, this.resultSet.getObject(columnIndex)));
                break;
            }
            case INT_ARRAY: {
                this.factory.writeIntArray(fieldName, this.convertJdbcObjectToJavaType(int[].class, this.resultSet.getObject(columnIndex)));
                break;
            }
            case LONG_ARRAY: {
                this.factory.writeLongArray(fieldName, this.convertJdbcObjectToJavaType(long[].class, this.resultSet.getObject(columnIndex)));
                break;
            }
            case FLOAT_ARRAY: {
                this.factory.writeFloatArray(fieldName, this.convertJdbcObjectToJavaType(float[].class, this.resultSet.getObject(columnIndex)));
                break;
            }
            case DOUBLE_ARRAY: {
                this.factory.writeDoubleArray(fieldName, this.convertJdbcObjectToJavaType(double[].class, this.resultSet.getObject(columnIndex)));
                break;
            }
            case STRING_ARRAY: {
                this.factory.writeStringArray(fieldName, this.convertJdbcObjectToJavaType(String[].class, this.resultSet.getObject(columnIndex)));
                break;
            }
            case OBJECT_ARRAY: {
                this.factory.writeObjectArray(fieldName, this.convertJdbcObjectToJavaType(Object[].class, this.resultSet.getObject(columnIndex)));
                break;
            }
            case ARRAY_OF_BYTE_ARRAYS: {
                this.factory.writeArrayOfByteArrays(fieldName, this.convertJdbcObjectToJavaType(byte[][].class, this.resultSet.getObject(columnIndex)));
                break;
            }
            case OBJECT: {
                Object v;
                if (this.isBlobColumn(columnName)) {
                    v = this.getBlobData(columnIndex);
                } else {
                    v = this.resultSet.getObject(columnIndex);
                    if (v instanceof Date) {
                        if (v instanceof java.sql.Date) {
                            java.sql.Date sqlDate = (java.sql.Date)v;
                            v = new Date(sqlDate.getTime());
                        } else if (v instanceof Time) {
                            Time sqlTime = (Time)v;
                            v = new Date(sqlTime.getTime());
                        } else if (v instanceof Timestamp) {
                            Timestamp sqlTimestamp = (Timestamp)v;
                            v = new Date(sqlTimestamp.getTime());
                        }
                    }
                }
                this.factory.writeObject(fieldName, v);
                break;
            }
        }
    }

    private boolean isBlobColumn(String columnName) throws SQLException {
        return this.tableMetaData.getColumnDataType(columnName) == 2004;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBlobData(int columnIndex) throws SQLException {
        Blob blob = this.resultSet.getBlob(columnIndex);
        if (blob == null) {
            return null;
        }
        try {
            long blobLength = blob.length();
            if (blobLength > Integer.MAX_VALUE) {
                throw new JdbcConnectorException("Blob of length " + blobLength + " is too big to be converted to a byte array.");
            }
            byte[] byArray = blob.getBytes(1L, (int)blobLength);
            return byArray;
        }
        finally {
            blob.free();
        }
    }

    private <T> T convertJdbcObjectToJavaType(Class<T> javaType, Object jdbcObject) {
        try {
            return javaType.cast(jdbcObject);
        }
        catch (ClassCastException classCastException) {
            throw JdbcConnectorException.createException("Could not convert " + jdbcObject.getClass().getTypeName() + " to " + javaType.getTypeName(), classCastException);
        }
    }

    private FieldType getFieldType(TypeRegistry typeRegistry, String fieldName) {
        PdxField pdxField;
        String pdxClassName = this.regionMapping.getPdxName();
        if (pdxClassName == null) {
            return FieldType.OBJECT;
        }
        PdxType pdxType = typeRegistry.getPdxTypeForField(fieldName, pdxClassName);
        if (pdxType != null && (pdxField = pdxType.getPdxField(fieldName)) != null) {
            return pdxField.getFieldType();
        }
        throw new JdbcConnectorException("Could not find PdxType for field " + fieldName + ". Add class " + pdxClassName + " with " + fieldName + " to pdx registry.");
    }
}

