/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.DestroyConnectionFunction;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class DestroyConnectionCommand
extends SingleGfshCommand {
    static final String DESTROY_CONNECTION = "destroy jdbc-connection";
    static final String DESTROY_CONNECTION__HELP = "(Experimental) Destroy/Remove the specified jdbc connection.";
    static final String DESTROY_CONNECTION__NAME = "name";
    static final String DESTROY_CONNECTION__NAME__HELP = "Name of the jdbc connection to be destroyed.";

    @CliCommand(value={"destroy jdbc-connection"}, help="(Experimental) Destroy/Remove the specified jdbc connection.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel destroyConnection(@CliOption(key={"name"}, mandatory=true, help="Name of the jdbc connection to be destroyed.") String name) {
        Set targetMembers = this.getMembers(null, null);
        List results = this.executeAndGetFunctionResult((Function)new DestroyConnectionFunction(), name, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult((List)results, (String)"(Experimental) ", null, (boolean)false, (boolean)true);
        result.setConfigObject((Object)name);
        return result;
    }

    public void updateClusterConfig(String group, CacheConfig config, Object element) {
        ConnectorService service = (ConnectorService)config.findCustomCacheElement("connector-service", ConnectorService.class);
        if (service != null) {
            CacheElement.removeElement(service.getConnection(), (String)((String)element));
        }
    }
}

