/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.DescribeMappingFunction;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class DescribeMappingCommand
extends GfshCommand {
    static final String DESCRIBE_MAPPING = "describe jdbc-mapping";
    static final String DESCRIBE_MAPPING__HELP = "(Experimental) Describe the specified jdbc mapping";
    static final String DESCRIBE_MAPPING__REGION_NAME = "region";
    static final String DESCRIBE_MAPPING__REGION_NAME__HELP = "Region name of the jdbc mapping to be described.";
    static final String RESULT_SECTION_NAME = "MappingDescription";
    static final String FIELD_TO_COLUMN_TABLE = "fieldToColumnTable";

    @CliCommand(value={"describe jdbc-mapping"}, help="(Experimental) Describe the specified jdbc mapping")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel describeMapping(@CliOption(key={"region"}, mandatory=true, help="Region name of the jdbc mapping to be described.") String regionName) {
        ConnectorService.RegionMapping mapping = null;
        ConfigurationPersistenceService ccService = this.getConfigurationPersistenceService();
        if (ccService != null) {
            ConnectorService service;
            CacheConfig cacheConfig = ccService.getCacheConfig("cluster");
            if (cacheConfig != null && (service = (ConnectorService)cacheConfig.findCustomCacheElement("connector-service", ConnectorService.class)) != null) {
                mapping = (ConnectorService.RegionMapping)CacheElement.findElement(service.getRegionMapping(), (String)regionName);
            }
        } else {
            DistributedMember targetMember;
            CliFunctionResult result;
            Set members = this.findMembers(null, null);
            if (members.size() > 0 && (result = this.executeFunctionAndGetFunctionResult((Function)new DescribeMappingFunction(), regionName, targetMember = (DistributedMember)members.iterator().next())) != null) {
                mapping = (ConnectorService.RegionMapping)result.getResultObject();
            }
        }
        if (mapping == null) {
            throw new EntityNotFoundException("(Experimental) \nmapping for region '" + regionName + "' not found");
        }
        ResultModel resultModel = new ResultModel();
        this.fillResultData(mapping, resultModel);
        resultModel.setHeader("(Experimental) ");
        return resultModel;
    }

    private void fillResultData(ConnectorService.RegionMapping mapping, ResultModel resultModel) {
        DataResultModel sectionModel = resultModel.addData(RESULT_SECTION_NAME);
        sectionModel.addData(DESCRIBE_MAPPING__REGION_NAME, (Object)mapping.getRegionName());
        sectionModel.addData("connection", (Object)mapping.getConnectionConfigName());
        sectionModel.addData("table", (Object)mapping.getTableName());
        sectionModel.addData("pdx-class-name", (Object)mapping.getPdxClassName());
        sectionModel.addData("value-contains-primary-key", (Object)mapping.isPrimaryKeyInValue());
        TabularResultModel tabularResultData = resultModel.addTable(FIELD_TO_COLUMN_TABLE);
        tabularResultData.setHeader("Field to Column Mappings:");
        if (mapping.getFieldMapping() != null) {
            mapping.getFieldMapping().forEach(entry -> {
                tabularResultData.accumulate("Field", entry.getFieldName());
                tabularResultData.accumulate("Column", entry.getColumnName());
            });
        }
    }
}

