/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.DescribeConnectionFunction;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class DescribeConnectionCommand
extends GfshCommand {
    private static Logger logger = LogService.getLogger();
    static final String DESCRIBE_CONNECTION = "describe jdbc-connection";
    static final String DESCRIBE_CONNECTION__HELP = "(Experimental) Describe the specified jdbc connection .";
    static final String DESCRIBE_CONNECTION__NAME = "name";
    static final String DESCRIBE_CONNECTION__NAME__HELP = "Name of the jdbc connection to be described.";
    static final String OBSCURED_PASSWORD = "********";
    static final String RESULT_SECTION_NAME = "ConnectionDescription";

    @CliCommand(value={"describe jdbc-connection"}, help="(Experimental) Describe the specified jdbc connection .")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel describeConnection(@CliOption(key={"name"}, mandatory=true, help="Name of the jdbc connection to be described.") String name) {
        ConnectorService.Connection connection = null;
        ConfigurationPersistenceService ccService = this.getConfigurationPersistenceService();
        if (ccService != null) {
            ConnectorService service;
            CacheConfig cacheConfig = ccService.getCacheConfig("cluster");
            if (cacheConfig != null && (service = (ConnectorService)cacheConfig.findCustomCacheElement("connector-service", ConnectorService.class)) != null) {
                connection = (ConnectorService.Connection)CacheElement.findElement(service.getConnection(), (String)name);
            }
        } else {
            DistributedMember targetMember;
            CliFunctionResult result;
            Set members = this.findMembers(null, null);
            if (members.size() > 0 && (result = this.executeFunctionAndGetFunctionResult((Function)new DescribeConnectionFunction(), name, targetMember = (DistributedMember)members.iterator().next())) != null) {
                connection = (ConnectorService.Connection)result.getResultObject();
            }
        }
        if (connection == null) {
            throw new EntityNotFoundException("(Experimental) \nconnection named '" + name + "' not found");
        }
        ResultModel resultModel = new ResultModel();
        this.fillResultData(connection, resultModel);
        resultModel.setHeader("(Experimental) ");
        return resultModel;
    }

    private void fillResultData(ConnectorService.Connection connection, ResultModel resultModel) {
        DataResultModel sectionModel = resultModel.addData(RESULT_SECTION_NAME);
        sectionModel.addData(DESCRIBE_CONNECTION__NAME, (Object)connection.getName());
        sectionModel.addData("url", (Object)connection.getUrl());
        if (connection.getUser() != null) {
            sectionModel.addData("user", (Object)connection.getUser());
        }
        if (connection.getPassword() != null) {
            sectionModel.addData("password", (Object)OBSCURED_PASSWORD);
        }
        TabularResultModel tabularResultModel = resultModel.addTable("params");
        tabularResultModel.setHeader("Additional connection parameters:");
        connection.getParameterMap().entrySet().forEach(entry -> {
            tabularResultModel.accumulate("Param Name", (String)entry.getKey());
            tabularResultModel.accumulate("Value", (String)entry.getValue());
        });
    }
}

