/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.AlterMappingFunction;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class AlterMappingCommand
extends SingleGfshCommand {
    static final String ALTER_MAPPING = "alter jdbc-mapping";
    static final String ALTER_MAPPING__HELP = "(Experimental) Alter properties for an existing jdbc mapping.";
    static final String ALTER_MAPPING__REGION_NAME = "region";
    static final String ALTER_MAPPING__REGION_NAME__HELP = "Name of the region the mapping to be altered.";
    static final String ALTER_MAPPING__PDX_CLASS_NAME = "pdx-class-name";
    static final String ALTER_MAPPING__PDX_CLASS_NAME__HELP = "Name of new pdx class for which values with be written to the database.";
    static final String ALTER_MAPPING__TABLE_NAME = "table";
    static final String ALTER_MAPPING__TABLE_NAME__HELP = "Name of new database table for values to be written to.";
    static final String ALTER_MAPPING__CONNECTION_NAME = "connection";
    static final String ALTER_MAPPING__CONNECTION_NAME__HELP = "Name of new JDBC connection to use.";
    static final String ALTER_MAPPING__PRIMARY_KEY_IN_VALUE = "primary-key-in-value";
    static final String ALTER_MAPPING__PRIMARY_KEY_IN_VALUE__HELP = "If false, the entry value does not contain the data used for the database table's primary key, instead the entry key will be used for the primary key column value.";
    static final String ALTER_MAPPING__FIELD_MAPPING = "field-mapping";
    static final String ALTER_MAPPING__FIELD_MAPPING__HELP = "New key value pairs of entry value fields to database columns.";

    @CliCommand(value={"alter jdbc-mapping"}, help="(Experimental) Alter properties for an existing jdbc mapping.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel alterMapping(@CliOption(key={"region"}, mandatory=true, help="Name of the region the mapping to be altered.") String regionName, @CliOption(key={"connection"}, specifiedDefaultValue="", help="Name of new JDBC connection to use.") String connectionName, @CliOption(key={"table"}, help="Name of new database table for values to be written to.", specifiedDefaultValue="") String table, @CliOption(key={"pdx-class-name"}, help="Name of new pdx class for which values with be written to the database.", specifiedDefaultValue="") String pdxClassName, @CliOption(key={"primary-key-in-value"}, help="If false, the entry value does not contain the data used for the database table's primary key, instead the entry key will be used for the primary key column value.", specifiedDefaultValue="true") Boolean keyInValue, @CliOption(key={"field-mapping"}, help="New key value pairs of entry value fields to database columns.", specifiedDefaultValue="") String[] fieldMappings) {
        Set targetMembers = this.getMembers(null, null);
        ConnectorService.RegionMapping newMapping = new ConnectorService.RegionMapping(regionName, pdxClassName, table, connectionName, keyInValue);
        newMapping.setFieldMapping(fieldMappings);
        ConfigurationPersistenceService ccService = this.getConfigurationPersistenceService();
        if (ccService != null) {
            CacheConfig cacheConfig = ccService.getCacheConfig("cluster");
            ConnectorService service = (ConnectorService)cacheConfig.findCustomCacheElement("connector-service", ConnectorService.class);
            if (service == null) {
                throw new EntityNotFoundException("mapping with name '" + regionName + "' does not exist.");
            }
            ConnectorService.RegionMapping mapping = (ConnectorService.RegionMapping)CacheElement.findElement(service.getRegionMapping(), (String)regionName);
            if (mapping == null) {
                throw new EntityNotFoundException("mapping with name '" + regionName + "' does not exist.");
            }
        }
        List results = this.executeAndGetFunctionResult((Function)new AlterMappingFunction(), newMapping, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult((List)results, (String)"(Experimental) ", null, (boolean)false, (boolean)true);
        CliFunctionResult successResult = results.stream().filter(CliFunctionResult::isSuccessful).findAny().get();
        ConnectorService.RegionMapping mergedMapping = (ConnectorService.RegionMapping)successResult.getResultObject();
        result.setConfigObject((Object)mergedMapping);
        return result;
    }

    public void updateClusterConfig(String group, CacheConfig config, Object element) {
        ConnectorService.RegionMapping mapping = (ConnectorService.RegionMapping)element;
        ConnectorService service = (ConnectorService)config.findCustomCacheElement("connector-service", ConnectorService.class);
        CacheElement.removeElement(service.getRegionMapping(), (String)mapping.getId());
        service.getRegionMapping().add(mapping);
    }
}

