/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigNotFoundException;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

@Experimental
public class AlterConnectionFunction
extends CliFunction<ConnectorService.Connection> {
    public CliFunctionResult executeFunction(FunctionContext<ConnectorService.Connection> context) throws Exception {
        ConnectorService.Connection connectionConfig;
        JdbcConnectorService service = FunctionContextArgumentProvider.getJdbcConnectorService(context);
        ConnectorService.Connection existingConfig = service.getConnectionConfig((connectionConfig = (ConnectorService.Connection)context.getArguments()).getName());
        if (existingConfig == null) {
            throw new ConnectionConfigNotFoundException("ConnectionConfiguration " + connectionConfig.getName() + " was not found");
        }
        ConnectorService.Connection alteredConfig = this.alterConnectionConfig(connectionConfig, existingConfig);
        service.replaceConnectionConfig(alteredConfig);
        return new CliFunctionResult(context.getMemberName(), (Object)alteredConfig, null);
    }

    ConnectorService.Connection alterConnectionConfig(ConnectorService.Connection connectionConfig, ConnectorService.Connection existingConfig) {
        String url = this.getValue(connectionConfig.getUrl(), existingConfig.getUrl());
        String user = this.getValue(connectionConfig.getUser(), existingConfig.getUser());
        String password = this.getValue(connectionConfig.getPassword(), existingConfig.getPassword());
        String parameters = connectionConfig.getParameters();
        if (parameters == null) {
            parameters = existingConfig.getParameters();
        }
        ConnectorService.Connection alteredConfig = new ConnectorService.Connection(existingConfig.getName(), url, user, password, parameters);
        return alteredConfig;
    }

    private String getValue(String newValue, String existingValue) {
        if (newValue == null) {
            return existingValue;
        }
        return newValue.isEmpty() ? null : newValue;
    }
}

