/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.Map;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigNotFoundException;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.cli.JdbcCliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

@Experimental
public class AlterConnectionFunction
extends JdbcCliFunction<ConnectionConfiguration, CliFunctionResult> {
    AlterConnectionFunction() {
    }

    @Override
    CliFunctionResult getFunctionResult(JdbcConnectorService service, FunctionContext<ConnectionConfiguration> context) throws Exception {
        ConnectionConfiguration connectionConfig = (ConnectionConfiguration)context.getArguments();
        ConnectionConfiguration existingConfig = service.getConnectionConfig(connectionConfig.getName());
        if (existingConfig == null) {
            throw new ConnectionConfigNotFoundException("ConnectionConfiguration " + connectionConfig.getName() + " was not found");
        }
        ConnectionConfiguration alteredConfig = this.alterConnectionConfig(connectionConfig, existingConfig);
        service.replaceConnectionConfig(alteredConfig);
        String member = this.getMember(context);
        XmlEntity xmlEntity = this.createXmlEntity(context);
        CliFunctionResult result = this.createSuccessResult(connectionConfig.getName(), member, xmlEntity);
        return result;
    }

    ConnectionConfiguration alterConnectionConfig(ConnectionConfiguration connectionConfig, ConnectionConfiguration existingConfig) {
        String url = this.getValue(connectionConfig.getUrl(), existingConfig.getUrl());
        String user = this.getValue(connectionConfig.getUser(), existingConfig.getUser());
        String password = this.getValue(connectionConfig.getPassword(), existingConfig.getPassword());
        Map<String, String> parameters = connectionConfig.getParameters();
        if (parameters == null) {
            parameters = existingConfig.getParameters();
        }
        ConnectionConfiguration alteredConfig = new ConnectionConfiguration(existingConfig.getName(), url, user, password, parameters);
        return alteredConfig;
    }

    private String getValue(String newValue, String existingValue) {
        if (newValue == null) {
            return existingValue;
        }
        return newValue.isEmpty() ? null : newValue;
    }

    private CliFunctionResult createSuccessResult(String connectionName, String member, XmlEntity xmlEntity) {
        String message = "Altered JDBC connection " + connectionName + " on " + member;
        return new CliFunctionResult(member, xmlEntity, message);
    }
}

