/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.annotations.Experimental;

@Experimental
public class ConnectionConfiguration
implements Serializable {
    private final String name;
    private final String url;
    private final String user;
    private final String password;
    private final Map<String, String> parameters;

    public ConnectionConfiguration(String name, String url, String user, String password, Map<String, String> parameters) {
        this.name = name;
        this.url = url;
        this.user = user;
        this.password = password;
        this.parameters = parameters == null ? null : Collections.unmodifiableMap(parameters);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Properties getConnectionProperties() {
        Properties properties = new Properties();
        if (this.parameters != null) {
            properties.putAll(this.parameters);
        }
        return properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionConfiguration that = (ConnectionConfiguration)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ConnectionConfiguration{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", user='" + this.user + '\'' + ", password='" + this.password + '\'' + ", parameters=" + this.parameters + '}';
    }
}

