/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.io.Serializable;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

class ExceptionHandler
implements Serializable {
    private static final Logger logger = LogService.getLogger();

    ExceptionHandler() {
    }

    void handleException(FunctionContext<?> context, Exception exception) {
        String message = this.getExceptionMessage(exception);
        String member = this.getMember(context.getCache());
        context.getResultSender().lastResult((Object)this.handleException(member, message, exception));
    }

    private CliFunctionResult handleException(String memberNameOrId, String exceptionMsg, Exception exception) {
        if (exception != null && logger.isDebugEnabled()) {
            logger.debug(exception.getMessage(), (Throwable)exception);
        }
        return new CliFunctionResult(memberNameOrId, false, exceptionMsg);
    }

    private String getMember(Cache cache) {
        return CliUtil.getMemberNameOrId((DistributedMember)cache.getDistributedSystem().getDistributedMember());
    }

    private String getExceptionMessage(Exception exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = ExceptionUtils.getStackTrace((Throwable)exception);
        }
        return message;
    }
}

