/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.connectors.jdbc.internal.cli.DestroyConnectionFunction;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class DestroyConnectionCommand
implements GfshCommand {
    static final String DESTROY_CONNECTION = "destroy jdbc-connection";
    static final String DESTROY_CONNECTION__HELP = "(Experimental) Destroy/Remove the specified jdbc connection.";
    static final String DESTROY_CONNECTION__NAME = "name";
    static final String DESTROY_CONNECTION__NAME__HELP = "Name of the jdbc connection to be destroyed.";
    private static final String ERROR_PREFIX = "ERROR: ";

    @CliCommand(value={"destroy jdbc-connection"}, help="(Experimental) Destroy/Remove the specified jdbc connection.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result destroyConnection(@CliOption(key={"name"}, mandatory=true, help="Name of the jdbc connection to be destroyed.") String name) {
        Set targetMembers = this.getMembers(null, null);
        ResultCollector<CliFunctionResult, List<CliFunctionResult>> resultCollector = this.execute(new DestroyConnectionFunction(), name, targetMembers);
        TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
        XmlEntity xmlEntity = this.fillTabularResultData(resultCollector, tabularResultData);
        tabularResultData.setHeader("(Experimental) ");
        CommandResult result = ResultBuilder.buildResult((ResultData)tabularResultData);
        this.updateClusterConfiguration((Result)result, xmlEntity);
        return result;
    }

    ResultCollector<CliFunctionResult, List<CliFunctionResult>> execute(DestroyConnectionFunction function, String connectionName, Set<DistributedMember> targetMembers) {
        return this.executeFunction((Function)function, connectionName, targetMembers);
    }

    private XmlEntity fillTabularResultData(ResultCollector<CliFunctionResult, List<CliFunctionResult>> resultCollector, TabularResultData tabularResultData) {
        XmlEntity xmlEntity = null;
        for (CliFunctionResult oneResult : (List)resultCollector.getResult()) {
            if (oneResult.isSuccessful()) {
                xmlEntity = this.addSuccessToResults(tabularResultData, oneResult);
                continue;
            }
            this.addErrorToResults(tabularResultData, oneResult);
        }
        return xmlEntity;
    }

    private XmlEntity addSuccessToResults(TabularResultData tabularResultData, CliFunctionResult oneResult) {
        tabularResultData.accumulate("Member", (Object)oneResult.getMemberIdOrName());
        tabularResultData.accumulate("Status", (Object)oneResult.getMessage());
        return oneResult.getXmlEntity();
    }

    private void addErrorToResults(TabularResultData tabularResultData, CliFunctionResult oneResult) {
        tabularResultData.accumulate("Member", (Object)oneResult.getMemberIdOrName());
        tabularResultData.accumulate("Status", (Object)(ERROR_PREFIX + oneResult.getMessage()));
        tabularResultData.setStatus(Result.Status.ERROR);
    }

    private void updateClusterConfiguration(Result result, XmlEntity xmlEntity) {
        if (xmlEntity != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity(xmlEntity, null));
        }
    }
}

