/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.cli.ListConnectionFunction;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

@Experimental
public class ListConnectionCommand
implements GfshCommand {
    static final String LIST_JDBC_CONNECTION = "list jdbc-connections";
    static final String LIST_JDBC_CONNECTION__HELP = "(Experimental) Display jdbc connections for all members.";
    static final String LIST_OF_CONNECTIONS = "List of connections";
    static final String NO_CONNECTIONS_FOUND = "No connections found";

    @CliCommand(value={"list jdbc-connections"}, help="(Experimental) Display jdbc connections for all members.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result listConnection() {
        Set targetMembers = this.getMembers(null, null);
        if (targetMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult((String)"No Members Found");
        }
        ResultCollector<ConnectionConfiguration, List<ConnectionConfiguration[]>> resultCollector = this.execute(new ListConnectionFunction(), (DistributedMember)targetMembers.iterator().next());
        TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
        boolean connectionsExist = this.fillTabularResultData(resultCollector, tabularResultData);
        return this.createResult(tabularResultData, connectionsExist);
    }

    ResultCollector<ConnectionConfiguration, List<ConnectionConfiguration[]>> execute(ListConnectionFunction function, DistributedMember targetMember) {
        return this.executeFunction(function, null, targetMember);
    }

    private Result createResult(TabularResultData tabularResultData, boolean connectionsExist) {
        if (connectionsExist) {
            tabularResultData.setHeader("(Experimental) ");
            return ResultBuilder.buildResult((ResultData)tabularResultData);
        }
        return ResultBuilder.createInfoResult((String)"(Experimental) \nNo connections found");
    }

    private boolean fillTabularResultData(ResultCollector<ConnectionConfiguration, List<ConnectionConfiguration[]>> resultCollector, TabularResultData tabularResultData) {
        HashSet<ConnectionConfiguration> connectionConfigs = new HashSet<ConnectionConfiguration>();
        for (Object resultObject : (List)resultCollector.getResult()) {
            if (resultObject instanceof ConnectionConfiguration[]) {
                connectionConfigs.addAll(Arrays.asList((ConnectionConfiguration[])resultObject));
                continue;
            }
            if (resultObject instanceof Throwable) {
                throw new IllegalStateException((Throwable)resultObject);
            }
            throw new IllegalStateException(resultObject.getClass().getName());
        }
        for (ConnectionConfiguration connectionConfig : connectionConfigs) {
            tabularResultData.accumulate(LIST_OF_CONNECTIONS, (Object)connectionConfig.getName());
        }
        return !connectionConfigs.isEmpty();
    }
}

