/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.RegionMappingExistsException;
import org.apache.geode.connectors.jdbc.internal.cli.ExceptionHandler;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.connectors.jdbc.internal.cli.JdbcCliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

@Experimental
public class CreateMappingFunction
extends JdbcCliFunction<RegionMapping, CliFunctionResult> {
    CreateMappingFunction() {
        super(new FunctionContextArgumentProvider(), new ExceptionHandler());
    }

    @Override
    CliFunctionResult getFunctionResult(JdbcConnectorService service, FunctionContext<RegionMapping> context) throws Exception {
        RegionMapping regionMapping = (RegionMapping)context.getArguments();
        this.createRegionMapping(service, regionMapping);
        String member = this.getMember(context);
        XmlEntity xmlEntity = this.createXmlEntity(context);
        return this.createSuccessResult(regionMapping.getRegionName(), member, xmlEntity);
    }

    void createRegionMapping(JdbcConnectorService service, RegionMapping regionMapping) throws RegionMappingExistsException {
        service.createRegionMapping(regionMapping);
    }

    private CliFunctionResult createSuccessResult(String regionName, String member, XmlEntity xmlEntity) {
        String message = "Created JDBC mapping for region " + regionName + " on " + member;
        return new CliFunctionResult(member, xmlEntity, message);
    }
}

