/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigExistsException;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.cli.ExceptionHandler;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.connectors.jdbc.internal.cli.JdbcCliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

@Experimental
public class CreateConnectionFunction
extends JdbcCliFunction<ConnectionConfiguration, CliFunctionResult> {
    CreateConnectionFunction() {
        super(new FunctionContextArgumentProvider(), new ExceptionHandler());
    }

    @Override
    CliFunctionResult getFunctionResult(JdbcConnectorService service, FunctionContext<ConnectionConfiguration> context) throws Exception {
        ConnectionConfiguration connectionConfig = (ConnectionConfiguration)context.getArguments();
        this.createConnectionConfig(service, connectionConfig);
        String member = this.getMember(context);
        XmlEntity xmlEntity = this.createXmlEntity(context);
        return this.createSuccessResult(connectionConfig.getName(), member, xmlEntity);
    }

    void createConnectionConfig(JdbcConnectorService service, ConnectionConfiguration connectionConfig) throws ConnectionConfigExistsException {
        service.createConnectionConfig(connectionConfig);
    }

    private CliFunctionResult createSuccessResult(String connectionName, String member, XmlEntity xmlEntity) {
        String message = "Created JDBC connection " + connectionName + " on " + member;
        return new CliFunctionResult(member, xmlEntity, message);
    }
}

