/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.util.Properties;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.CacheCallback;
import org.apache.geode.connectors.jdbc.internal.DataSourceManager;
import org.apache.geode.connectors.jdbc.internal.HikariJdbcDataSourceFactory;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.SqlHandler;
import org.apache.geode.internal.cache.InternalCache;

@Experimental
public abstract class AbstractJdbcCallback
implements CacheCallback {
    private volatile SqlHandler sqlHandler;

    protected AbstractJdbcCallback() {
    }

    protected AbstractJdbcCallback(SqlHandler sqlHandler) {
        this.sqlHandler = sqlHandler;
    }

    public void close() {
        if (this.sqlHandler != null) {
            this.sqlHandler.close();
        }
    }

    public void init(Properties props) {
    }

    protected SqlHandler getSqlHandler() {
        return this.sqlHandler;
    }

    protected void checkInitialized(InternalCache cache) {
        if (this.sqlHandler == null) {
            this.initialize(cache);
        }
    }

    private synchronized void initialize(InternalCache cache) {
        if (this.sqlHandler == null) {
            JdbcConnectorService service = (JdbcConnectorService)cache.getService(JdbcConnectorService.class);
            DataSourceManager manager = new DataSourceManager(new HikariJdbcDataSourceFactory());
            this.sqlHandler = new SqlHandler(manager, service);
        }
    }
}

