/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc;

import org.apache.geode.CopyHelper;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.SerializedCacheValue;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.connectors.jdbc.internal.AbstractJdbcCallback;
import org.apache.geode.connectors.jdbc.internal.SqlHandler;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.pdx.PdxInstance;

@Experimental
public class JdbcWriter<K, V>
extends AbstractJdbcCallback
implements CacheWriter<K, V> {
    public JdbcWriter() {
    }

    JdbcWriter(SqlHandler sqlHandler) {
        super(sqlHandler);
    }

    public void beforeUpdate(EntryEvent<K, V> event) throws CacheWriterException {
        this.checkInitialized((InternalCache)event.getRegion().getRegionService());
        this.getSqlHandler().write(event.getRegion(), event.getOperation(), event.getKey(), this.getPdxNewValue(event));
    }

    public void beforeCreate(EntryEvent<K, V> event) throws CacheWriterException {
        this.checkInitialized((InternalCache)event.getRegion().getRegionService());
        this.getSqlHandler().write(event.getRegion(), event.getOperation(), event.getKey(), this.getPdxNewValue(event));
    }

    public void beforeDestroy(EntryEvent<K, V> event) throws CacheWriterException {
        this.checkInitialized((InternalCache)event.getRegion().getRegionService());
        this.getSqlHandler().write(event.getRegion(), event.getOperation(), event.getKey(), this.getPdxNewValue(event));
    }

    public void beforeRegionDestroy(RegionEvent<K, V> event) throws CacheWriterException {
    }

    public void beforeRegionClear(RegionEvent<K, V> event) throws CacheWriterException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PdxInstance getPdxNewValue(EntryEvent<K, V> event) {
        DefaultQuery.setPdxReadSerialized((boolean)true);
        try {
            SerializedCacheValue serializedNewValue;
            Object newValue = event.getNewValue();
            if (!(newValue instanceof PdxInstance) && (newValue = (serializedNewValue = event.getSerializedNewValue()) != null ? serializedNewValue.getDeserializedValue() : CopyHelper.copy((Object)newValue)) != null && !(newValue instanceof PdxInstance)) {
                String valueClassName = newValue == null ? "null" : newValue.getClass().getName();
                throw new IllegalArgumentException(this.getClass().getSimpleName() + " only supports PDX values; newValue is " + valueClassName);
            }
            PdxInstance pdxInstance = (PdxInstance)newValue;
            return pdxInstance;
        }
        finally {
            DefaultQuery.setPdxReadSerialized((boolean)false);
        }
    }
}

