/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.configuration;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.XSDRootElement;
import org.apache.geode.connectors.jdbc.internal.configuration.FieldMapping;

@Experimental
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"fieldMappings"})
@XmlRootElement(name="mapping", namespace="http://geode.apache.org/schema/jdbc")
@XSDRootElement(namespace="http://geode.apache.org/schema/jdbc", schemaLocation="http://geode.apache.org/schema/jdbc/jdbc-1.0.xsd")
public class RegionMapping
extends CacheElement {
    @XmlElement(name="field-mapping", namespace="http://geode.apache.org/schema/jdbc")
    protected final List<FieldMapping> fieldMappings = new ArrayList<FieldMapping>();
    @XmlAttribute(name="data-source")
    protected String dataSourceName;
    @XmlAttribute(name="table")
    protected String tableName;
    @XmlAttribute(name="pdx-name")
    protected String pdxName;
    @XmlAttribute(name="ids")
    protected String ids;
    @XmlAttribute(name="specified-ids")
    protected boolean specifiedIds;
    @XmlAttribute(name="catalog")
    protected String catalog;
    @XmlAttribute(name="schema")
    protected String schema;
    @XmlTransient
    protected String regionName;
    public static final String ELEMENT_ID = "jdbc-mapping";

    public RegionMapping() {
    }

    public RegionMapping(String regionName, String pdxName, String tableName, String dataSourceName, String ids, String catalog, String schema) {
        this.regionName = regionName;
        this.pdxName = pdxName;
        this.tableName = tableName;
        this.dataSourceName = dataSourceName;
        this.ids = ids;
        this.specifiedIds = !StringUtils.isEmpty((CharSequence)ids);
        this.catalog = catalog;
        this.schema = schema;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPdxName(String pdxName) {
        this.pdxName = pdxName;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setSpecifiedIds(boolean specifiedIds) {
        this.specifiedIds = specifiedIds;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getPdxName() {
        return this.pdxName;
    }

    public String getIds() {
        return this.ids;
    }

    public boolean getSpecifiedIds() {
        return this.specifiedIds;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<FieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void addFieldMapping(FieldMapping value) {
        this.fieldMappings.add(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RegionMapping that = (RegionMapping)((Object)o);
        return RegionMapping.isEqual(this.regionName, that.regionName) && RegionMapping.isEqual(this.pdxName, that.pdxName) && RegionMapping.isEqual(this.tableName, that.tableName) && RegionMapping.isEqual(this.dataSourceName, that.dataSourceName) && RegionMapping.isEqual(this.ids, that.ids) && this.specifiedIds == that.specifiedIds && RegionMapping.isEqual(this.catalog, that.catalog) && RegionMapping.isEqual(this.schema, that.schema) && RegionMapping.isEqual(this.fieldMappings, that.fieldMappings);
    }

    private static boolean isEqual(Object o1, Object o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    public int hashCode() {
        int result = this.regionName != null ? this.regionName.hashCode() : 0;
        result = 31 * result + this.pdxName.hashCode();
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        result = 31 * result + (this.dataSourceName != null ? this.dataSourceName.hashCode() : 0);
        result = 31 * result + (this.ids != null ? this.ids.hashCode() : 0);
        result = 31 * result + (this.catalog != null ? this.catalog.hashCode() : 0);
        result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RegionMapping{regionName='" + this.regionName + '\'' + ", pdxName='" + this.pdxName + '\'' + ", tableName='" + this.tableName + '\'' + ", dataSourceName='" + this.dataSourceName + '\'' + ", ids='" + this.ids + '\'' + ", specifiedIds='" + this.specifiedIds + '\'' + ", catalog='" + this.catalog + '\'' + ", schema='" + this.schema + '\'' + ", fieldMapping='" + this.fieldMappings + '\'' + '}';
    }

    public String getId() {
        return ELEMENT_ID;
    }
}

