/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteStreamServer;
import com.healthmarketscience.rmiio.SimpleRemoteInputStream;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.RegionAttributesDataPolicy;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.JdbcAsyncWriter;
import org.apache.geode.connectors.jdbc.JdbcLoader;
import org.apache.geode.connectors.jdbc.JdbcWriter;
import org.apache.geode.connectors.jdbc.internal.cli.CreateMappingFunction;
import org.apache.geode.connectors.jdbc.internal.cli.CreateMappingPreconditionCheckFunction;
import org.apache.geode.connectors.jdbc.internal.cli.MappingCommandUtils;
import org.apache.geode.connectors.jdbc.internal.cli.PreconditionException;
import org.apache.geode.connectors.jdbc.internal.configuration.FieldMapping;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.ManagementAgent;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class CreateMappingCommand
extends SingleGfshCommand {
    static final String CREATE_MAPPING = "create jdbc-mapping";
    private static final String CREATE_MAPPING__HELP = "(Experimental) Create a JDBC mapping for a region for use with a JDBC database.";
    private static final String CREATE_MAPPING__REGION_NAME = "region";
    private static final String CREATE_MAPPING__REGION_NAME__HELP = "Name of the region the JDBC mapping is being created for.";
    private static final String CREATE_MAPPING__PDX_NAME = "pdx-name";
    private static final String CREATE_MAPPING__PDX_NAME__HELP = "Name of pdx class for which values will be written to the database.";
    private static final String CREATE_MAPPING__TABLE_NAME = "table";
    private static final String CREATE_MAPPING__TABLE_NAME__HELP = "Name of database table for values to be written to.";
    private static final String CREATE_MAPPING__DATA_SOURCE_NAME = "data-source";
    private static final String CREATE_MAPPING__DATA_SOURCE_NAME__HELP = "Name of JDBC data source to use.";
    private static final String CREATE_MAPPING__SYNCHRONOUS_NAME = "synchronous";
    private static final String CREATE_MAPPING__SYNCHRONOUS_NAME__HELP = "By default, writes will be asynchronous. If true, writes will be synchronous.";
    private static final String CREATE_MAPPING__ID_NAME = "id";
    private static final String CREATE_MAPPING__ID_NAME__HELP = "The table column names to use as the region key for this JDBC mapping. If more than one column name is given then they must be separated by commas.";
    private static final String CREATE_MAPPING__CATALOG_NAME = "catalog";
    private static final String CREATE_MAPPING__CATALOG_NAME__HELP = "The catalog that contains the database table. By default, the catalog is the empty string causing the table to be referenced without a catalog prefix.";
    private static final String CREATE_MAPPING__SCHEMA_NAME = "schema";
    private static final String CREATE_MAPPING__SCHEMA_NAME__HELP = "The schema that contains the database table. By default, the schema is the empty string causing the table to be referenced without a schema prefix.";
    private static final String CREATE_MAPPING__GROUPS_NAME = "groups";
    private static final String CREATE_MAPPING__GROUPS_NAME__HELP = "The names of the server groups on which this mapping should be created.";
    private static final String CREATE_MAPPING__PDX_CLASS_FILE = "pdx-class-file";
    private static final String CREATE_MAPPING__PDX_CLASS_FILE__HELP = "The file that contains the PDX class. It must be a file with the \".jar\" or \".class\" extension. By default, the PDX class must be on the server's classpath or gfsh deployed.";
    public static final String CREATE_MAPPING__IFNOTEXISTS__HELP = "By default, an attempt to create a duplicate jdbc mapping is reported as an error. If this option is specified without a value or is specified with a value of true, then gfsh displays a \"Skipping...\" acknowledgement, but does not throw an error.";
    static final String IF_NOT_EXISTS_SKIPPING_EXCEPTION_MESSAGE = "Skipping: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"create jdbc-mapping"}, help="(Experimental) Create a JDBC mapping for a region for use with a JDBC database.")
    @CliMetaData(interceptor="org.apache.geode.connectors.jdbc.internal.cli.CreateMappingCommand$Interceptor", relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel createMapping(@CliOption(key={"region"}, mandatory=true, help="Name of the region the JDBC mapping is being created for.") String regionName, @CliOption(key={"data-source"}, mandatory=true, help="Name of JDBC data source to use.") String dataSourceName, @CliOption(key={"table"}, help="Name of database table for values to be written to.") String table, @CliOption(key={"pdx-name"}, mandatory=true, help="Name of pdx class for which values will be written to the database.") String pdxName, @CliOption(key={"pdx-class-file"}, help="The file that contains the PDX class. It must be a file with the \".jar\" or \".class\" extension. By default, the PDX class must be on the server's classpath or gfsh deployed.") String pdxClassFile, @CliOption(key={"synchronous"}, help="By default, writes will be asynchronous. If true, writes will be synchronous.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean synchronous, @CliOption(key={"id"}, help="The table column names to use as the region key for this JDBC mapping. If more than one column name is given then they must be separated by commas.") String id, @CliOption(key={"catalog"}, help="The catalog that contains the database table. By default, the catalog is the empty string causing the table to be referenced without a catalog prefix.") String catalog, @CliOption(key={"schema"}, help="The schema that contains the database table. By default, the schema is the empty string causing the table to be referenced without a schema prefix.") String schema, @CliOption(key={"if-not-exists"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="By default, an attempt to create a duplicate jdbc mapping is reported as an error. If this option is specified without a value or is specified with a value of true, then gfsh displays a \"Skipping...\" acknowledgement, but does not throw an error.") boolean ifNotExists, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="The names of the server groups on which this mapping should be created.") String[] groups) throws IOException {
        if (regionName.startsWith("/")) {
            regionName = regionName.substring(1);
        }
        String tempPdxClassFilePath = null;
        String remoteInputStreamName = null;
        RemoteInputStream remoteInputStream = null;
        if (pdxClassFile != null) {
            List<String> pdxClassFilePaths = this.getFilePathFromShell();
            if (pdxClassFilePaths.size() != 1) {
                throw new IllegalStateException("Expected only one element in the list returned by getFilePathFromShell, but it returned: " + pdxClassFilePaths);
            }
            tempPdxClassFilePath = pdxClassFilePaths.get(0);
        }
        Set targetMembers = this.findMembers(groups, null);
        RegionMapping mapping = new RegionMapping(regionName, pdxName, table, dataSourceName, id, catalog, schema);
        try {
            ConfigurationPersistenceService configurationPersistenceService = this.checkForClusterConfiguration();
            if (groups == null) {
                groups = new String[]{"cluster"};
            }
            for (String group : groups) {
                CacheConfig cacheConfig = MappingCommandUtils.getCacheConfig(configurationPersistenceService, group);
                RegionConfig regionConfig = this.checkForRegion(regionName, cacheConfig, group);
                this.checkForExistingMapping(regionName, regionConfig);
                this.checkForCacheLoader(regionName, regionConfig);
                this.checkForCacheWriter(regionName, synchronous, regionConfig);
                this.checkForAsyncQueue(regionName, synchronous, cacheConfig);
                this.checkForAEQIdForAccessor(regionName, synchronous, regionConfig);
            }
        }
        catch (PreconditionException ex) {
            if (ifNotExists) {
                return ResultModel.createInfo((String)(IF_NOT_EXISTS_SKIPPING_EXCEPTION_MESSAGE + ex.getMessage()));
            }
            return ResultModel.createError((String)ex.getMessage());
        }
        if (pdxClassFile != null) {
            ManagementAgent agent = ((SystemManagementService)this.getManagementService()).getManagementAgent();
            RemoteStreamExporter exporter = agent.getRemoteStreamExporter();
            remoteInputStreamName = FilenameUtils.getName((String)tempPdxClassFilePath);
            remoteInputStream = (RemoteInputStream)exporter.export((RemoteStreamServer)this.createSimpleRemoteInputStream(tempPdxClassFilePath));
        }
        CliFunctionResult preconditionCheckResult = null;
        try {
            preconditionCheckResult = this.executeFunctionAndGetFunctionResult((Function)new CreateMappingPreconditionCheckFunction(), new Object[]{mapping, remoteInputStreamName, remoteInputStream}, (DistributedMember)targetMembers.iterator().next());
        }
        finally {
            if (remoteInputStream != null) {
                try {
                    remoteInputStream.close(true);
                }
                catch (IOException exporter) {}
            }
        }
        if (preconditionCheckResult.isSuccessful()) {
            Object[] preconditionOutput = (Object[])preconditionCheckResult.getResultObject();
            String computedIds = (String)preconditionOutput[0];
            if (computedIds != null) {
                mapping.setIds(computedIds);
            }
            ArrayList fieldMappings = (ArrayList)preconditionOutput[1];
            for (FieldMapping fieldMapping : fieldMappings) {
                mapping.addFieldMapping(fieldMapping);
            }
        } else {
            String message = preconditionCheckResult.getStatusMessage();
            return ResultModel.createError((String)message);
        }
        Object[] arguments = new Object[]{mapping, synchronous};
        List results = this.executeAndGetFunctionResult((Function)new CreateMappingFunction(), arguments, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult((List)results, (String)"(Experimental) ", null, (boolean)false, (boolean)true);
        result.setConfigObject((Object)arguments);
        return result;
    }

    SimpleRemoteInputStream createSimpleRemoteInputStream(String tempPdxClassFilePath) throws FileNotFoundException {
        return new SimpleRemoteInputStream((InputStream)new FileInputStream(tempPdxClassFilePath));
    }

    private ConfigurationPersistenceService checkForClusterConfiguration() throws PreconditionException {
        ConfigurationPersistenceService result = this.getConfigurationPersistenceService();
        if (result == null) {
            throw new PreconditionException("Cluster Configuration must be enabled.");
        }
        return result;
    }

    private RegionConfig checkForRegion(String regionName, CacheConfig cacheConfig, String groupName) throws PreconditionException {
        return MappingCommandUtils.checkForRegion(regionName, cacheConfig, groupName);
    }

    private void checkForExistingMapping(String regionName, RegionConfig regionConfig) throws PreconditionException {
        if (regionConfig.getCustomRegionElements().stream().anyMatch(element -> element instanceof RegionMapping)) {
            throw new PreconditionException("A JDBC mapping for " + regionName + " already exists.");
        }
    }

    private void checkForCacheLoader(String regionName, RegionConfig regionConfig) throws PreconditionException {
        DeclarableType loaderDeclarable;
        RegionAttributesType regionAttributes = regionConfig.getRegionAttributes();
        if (regionAttributes != null && (loaderDeclarable = regionAttributes.getCacheLoader()) != null) {
            throw new PreconditionException("The existing region " + regionName + " must not already have a cache-loader, but it has " + loaderDeclarable.getClassName());
        }
    }

    private void checkForCacheWriter(String regionName, boolean synchronous, RegionConfig regionConfig) throws PreconditionException {
        DeclarableType writerDeclarable;
        RegionAttributesType writerAttributes;
        if (synchronous && (writerAttributes = regionConfig.getRegionAttributes()) != null && (writerDeclarable = writerAttributes.getCacheWriter()) != null) {
            throw new PreconditionException("The existing region " + regionName + " must not already have a cache-writer, but it has " + writerDeclarable.getClassName());
        }
    }

    private void checkForAsyncQueue(String regionName, boolean synchronous, CacheConfig cacheConfig) throws PreconditionException {
        if (!synchronous) {
            String queueName = MappingCommandUtils.createAsyncEventQueueName(regionName);
            CacheConfig.AsyncEventQueue asyncEventQueue = cacheConfig.getAsyncEventQueues().stream().filter(queue -> queue.getId().equals(queueName)).findFirst().orElse(null);
            if (asyncEventQueue != null) {
                throw new PreconditionException("An async-event-queue named " + queueName + " must not already exist.");
            }
        }
    }

    private void checkForAEQIdForAccessor(String regionName, boolean synchronous, RegionConfig regionConfig) throws PreconditionException {
        RegionAttributesType regionAttributesType = regionConfig.getRegionAttributes();
        if (!synchronous && regionAttributesType != null) {
            boolean isAccessor = MappingCommandUtils.isAccessor(regionAttributesType);
            if (!isAccessor) {
                return;
            }
            String queueName = MappingCommandUtils.createAsyncEventQueueName(regionName);
            if (regionAttributesType.getAsyncEventQueueIds() != null && regionAttributesType.getAsyncEventQueueIds().contains(queueName)) {
                throw new PreconditionException("An async-event-queue named " + queueName + " must not already exist.");
            }
        }
    }

    public boolean updateConfigForGroup(String group, CacheConfig cacheConfig, Object element) {
        if (element == null) {
            return false;
        }
        Object[] arguments = (Object[])element;
        RegionMapping regionMapping = (RegionMapping)((Object)arguments[0]);
        boolean synchronous = (Boolean)arguments[1];
        String regionName = regionMapping.getRegionName();
        String queueName = MappingCommandUtils.createAsyncEventQueueName(regionName);
        RegionConfig regionConfig = this.findRegionConfig(cacheConfig, regionName);
        if (regionConfig == null) {
            return false;
        }
        RegionAttributesType attributes = this.getRegionAttribute(regionConfig);
        if (MappingCommandUtils.isAccessor(attributes)) {
            this.alterProxyRegion(queueName, attributes, synchronous);
        } else {
            this.addMappingToRegion(regionMapping, regionConfig);
            if (!synchronous) {
                this.createAsyncQueue(cacheConfig, attributes, queueName);
            }
            this.alterNonProxyRegion(queueName, attributes, synchronous);
        }
        return true;
    }

    private RegionAttributesType getRegionAttribute(RegionConfig config) {
        if (config.getRegionAttributes() == null) {
            config.setRegionAttributes(new RegionAttributesType());
        }
        return config.getRegionAttributes();
    }

    @CliAvailabilityIndicator(value={"create jdbc-mapping"})
    public boolean commandAvailable() {
        return this.isOnlineCommandAvailable();
    }

    private void alterProxyRegion(String queueName, RegionAttributesType attributes, boolean synchronous) {
        if (!synchronous) {
            this.addAsyncEventQueueId(queueName, attributes);
        }
    }

    private void alterNonProxyRegion(String queueName, RegionAttributesType attributes, boolean synchronous) {
        this.setCacheLoader(attributes);
        if (synchronous) {
            this.setCacheWriter(attributes);
        } else {
            this.addAsyncEventQueueId(queueName, attributes);
        }
    }

    private void addMappingToRegion(RegionMapping newCacheElement, RegionConfig regionConfig) {
        regionConfig.getCustomRegionElements().add(newCacheElement);
    }

    private RegionConfig findRegionConfig(CacheConfig cacheConfig, String regionName) {
        return cacheConfig.getRegions().stream().filter(region -> region.getName().equals(regionName)).findFirst().orElse(null);
    }

    private void createAsyncQueue(CacheConfig cacheConfig, RegionAttributesType attributes, String queueName) {
        CacheConfig.AsyncEventQueue asyncEventQueue = new CacheConfig.AsyncEventQueue();
        asyncEventQueue.setId(queueName);
        boolean isPartitioned = attributes.getDataPolicy().equals((Object)RegionAttributesDataPolicy.PARTITION) || attributes.getDataPolicy().equals((Object)RegionAttributesDataPolicy.PERSISTENT_PARTITION);
        asyncEventQueue.setParallel(Boolean.valueOf(isPartitioned));
        DeclarableType listener = new DeclarableType();
        listener.setClassName(JdbcAsyncWriter.class.getName());
        asyncEventQueue.setAsyncEventListener(listener);
        cacheConfig.getAsyncEventQueues().add(asyncEventQueue);
    }

    private void addAsyncEventQueueId(String queueName, RegionAttributesType attributes) {
        String asyncEventQueueList = attributes.getAsyncEventQueueIds();
        if (asyncEventQueueList == null) {
            asyncEventQueueList = "";
        }
        if (!asyncEventQueueList.contains(queueName)) {
            if (asyncEventQueueList.length() > 0) {
                asyncEventQueueList = asyncEventQueueList + ',';
            }
            asyncEventQueueList = asyncEventQueueList + queueName;
            attributes.setAsyncEventQueueIds(asyncEventQueueList);
        }
    }

    private void setCacheLoader(RegionAttributesType attributes) {
        DeclarableType loader = new DeclarableType();
        loader.setClassName(JdbcLoader.class.getName());
        attributes.setCacheLoader(loader);
    }

    private void setCacheWriter(RegionAttributesType attributes) {
        DeclarableType writer = new DeclarableType();
        writer.setClassName(JdbcWriter.class.getName());
        attributes.setCacheWriter(writer);
    }

    List<String> getFilePathFromShell() {
        return CommandExecutionContext.getFilePathFromShell();
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        public ResultModel preExecution(GfshParseResult parseResult) {
            String pdxClassFileName = (String)parseResult.getParamValue(CreateMappingCommand.CREATE_MAPPING__PDX_CLASS_FILE);
            if (StringUtils.isBlank((CharSequence)pdxClassFileName)) {
                return ResultModel.createInfo((String)"");
            }
            ResultModel result = new ResultModel();
            File pdxClassFile = new File(pdxClassFileName);
            if (!pdxClassFile.exists()) {
                return ResultModel.createError((String)(pdxClassFile + " not found."));
            }
            if (!pdxClassFile.isFile()) {
                return ResultModel.createError((String)(pdxClassFile + " is not a file."));
            }
            String fileExtension = FilenameUtils.getExtension((String)pdxClassFileName);
            if (!fileExtension.equalsIgnoreCase("jar") && !fileExtension.equalsIgnoreCase("class")) {
                return ResultModel.createError((String)(pdxClassFile + " must end with \".jar\" or \".class\"."));
            }
            result.addFile(pdxClassFile, 2);
            return result;
        }
    }
}

