/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.concurrency.loop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.test.concurrency.ParallelExecutor;
import org.apache.geode.test.concurrency.Runner;
import org.apache.geode.test.concurrency.loop.LoopRunnerConfig;

public class LoopRunner
implements Runner {
    private static final int DEFAULT_COUNT = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Throwable> runTestMethod(Method child) {
        int count = this.getCount(child);
        ExecutorService executorService = Executors.newCachedThreadPool();
        try {
            DelegatingExecutor executor = new DelegatingExecutor(executorService);
            for (int i = 0; i < count; ++i) {
                try {
                    Object test = child.getDeclaringClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    child.invoke(test, executor);
                    continue;
                }
                catch (InvocationTargetException ex) {
                    Throwable exceptionToReturn = ex.getCause();
                    if (exceptionToReturn == null) {
                        exceptionToReturn = ex;
                    }
                    List<Throwable> list = Collections.singletonList(ex.getCause());
                    executorService.shutdown();
                    return list;
                }
                catch (Exception e) {
                    try {
                        List<Throwable> list = Collections.singletonList(e);
                        executorService.shutdown();
                        return list;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return Collections.emptyList();
                    }
                }
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    private int getCount(Method child) {
        LoopRunnerConfig config = child.getDeclaringClass().getAnnotation(LoopRunnerConfig.class);
        if (config == null) {
            return 2000;
        }
        return config.count();
    }

    private static class DelegatingExecutor
    implements ParallelExecutor {
        private final ExecutorService executorService;
        private final List<Future<?>> futures;
        private final AtomicInteger callablesStarting = new AtomicInteger(0);
        private final CountDownLatch start = new CountDownLatch(1);

        public DelegatingExecutor(ExecutorService executorService) {
            this.executorService = executorService;
            this.futures = new ArrayList();
        }

        @Override
        public <T> Future<T> inParallel(Callable<T> callable) {
            this.callablesStarting.getAndIncrement();
            Future<Object> future = this.executorService.submit(() -> {
                this.callablesStarting.getAndDecrement();
                this.start.await();
                return callable.call();
            });
            this.futures.add(future);
            return future;
        }

        @Override
        public void execute() throws ExecutionException, InterruptedException {
            while (this.callablesStarting.get() > 0) {
            }
            this.start.countDown();
            for (Future<?> future : this.futures) {
                future.get();
            }
            this.futures.clear();
        }
    }
}

