/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.inet;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.Retry;

public class LocalHostUtil {
    private static final String USE_LINK_LOCAL_ADDRESSES_PROPERTY = "gemfire.net.useLinkLocalAddresses";
    private static final boolean useLinkLocalAddresses = Boolean.getBoolean("gemfire.net.useLinkLocalAddresses");
    @MakeNotStatic
    private static boolean useIPv6Addresses = !Boolean.getBoolean("java.net.preferIPv4Stack") && Boolean.getBoolean("java.net.preferIPv6Addresses");
    private static final InetAddress localHost = LocalHostUtil.tryToResolveLocalHost();

    private static InetAddress tryToResolveLocalHost() {
        try {
            return Retry.tryFor(60L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS, LocalHostUtil::resolveLocalHost, Objects::nonNull);
        }
        catch (InterruptedException | TimeoutException exception) {
            return null;
        }
    }

    private static InetAddress resolveLocalHost() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByAddress(InetAddress.getLocalHost().getAddress());
            if (inetAddress.isLoopbackAddress()) {
                InetAddress ipv4Fallback = null;
                InetAddress ipv6Fallback = null;
                Set<InetAddress> myInterfaces = LocalHostUtil.getMyAddresses();
                boolean preferIPv6 = useIPv6Addresses;
                String lhName = null;
                for (InetAddress addr : myInterfaces) {
                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || lhName != null) break;
                    boolean ipv6 = addr instanceof Inet6Address;
                    boolean ipv4 = addr instanceof Inet4Address;
                    if (preferIPv6 && ipv6 || !preferIPv6 && ipv4) {
                        String addrName = LocalHostUtil.reverseDNS(addr);
                        if (inetAddress.isLoopbackAddress()) {
                            inetAddress = addr;
                            lhName = addrName;
                            continue;
                        }
                        if (addrName == null) continue;
                        inetAddress = addr;
                        lhName = addrName;
                        continue;
                    }
                    if (preferIPv6 && ipv4 && ipv4Fallback == null) {
                        ipv4Fallback = addr;
                        continue;
                    }
                    if (preferIPv6 || !ipv6 || ipv6Fallback != null) continue;
                    ipv6Fallback = addr;
                }
                if (inetAddress.isLoopbackAddress()) {
                    if (ipv4Fallback != null) {
                        inetAddress = ipv4Fallback;
                        useIPv6Addresses = false;
                    } else if (ipv6Fallback != null) {
                        inetAddress = ipv6Fallback;
                        useIPv6Addresses = true;
                    }
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return inetAddress;
    }

    public static Set<InetAddress> getMyAddresses() {
        Enumeration<NetworkInterface> interfaces;
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        HashSet<InetAddress> locals = new HashSet<InetAddress>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new IllegalArgumentException("Unable to examine network interfaces", e);
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface face = interfaces.nextElement();
            boolean faceIsUp = false;
            try {
                faceIsUp = face.isUp();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            if (!faceIsUp) continue;
            Enumeration<InetAddress> addrs = face.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || !useLinkLocalAddresses && addr.isLinkLocalAddress()) {
                    locals.add(addr);
                    continue;
                }
                result.add(addr);
            }
        }
        if (result.size() == 0) {
            return locals;
        }
        return result;
    }

    private static String reverseDNS(InetAddress addr) {
        byte[] addrBytes = addr.getAddress();
        StringBuilder lookup = new StringBuilder();
        for (int index = addrBytes.length - 1; index >= 0; --index) {
            lookup.append(addrBytes[index] & 0xFF).append('.');
        }
        lookup.append("in-addr.arpa");
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attrs = ctx.getAttributes(lookup.toString(), new String[]{"PTR"});
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMoreElements()) {
                Attribute attr = ae.next();
                NamingEnumeration<?> vals = attr.getAll();
                while (vals.hasMoreElements()) {
                    Object elem = vals.nextElement();
                    if (!"PTR".equals(attr.getID()) || elem == null) continue;
                    return elem.toString();
                }
            }
            ctx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean preferIPv6Addresses() {
        return useIPv6Addresses;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        if (localHost == null) {
            throw new UnknownHostException();
        }
        return localHost;
    }

    public static boolean isLocalHost(Object host) {
        if (host instanceof InetAddress) {
            InetAddress inetAddress = (InetAddress)host;
            if (LocalHostUtil.isLocalHost(inetAddress)) {
                return true;
            }
            if (inetAddress.isLoopbackAddress()) {
                return true;
            }
            try {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface i = en.nextElement();
                    Enumeration<InetAddress> en2 = i.getInetAddresses();
                    while (en2.hasMoreElements()) {
                        InetAddress addr = en2.nextElement();
                        if (!inetAddress.equals(addr)) continue;
                        return true;
                    }
                }
                return false;
            }
            catch (SocketException e) {
                throw new IllegalArgumentException("Unable to query network interface", e);
            }
        }
        return LocalHostUtil.isLocalHost((Object)LocalHostUtil.toInetAddress(host.toString()));
    }

    private static boolean isLocalHost(InetAddress host) {
        try {
            return LocalHostUtil.getLocalHost().equals(host);
        }
        catch (UnknownHostException ignored) {
            return false;
        }
    }

    public static InetAddress toInetAddress(String host) {
        if (host == null || host.length() == 0) {
            return null;
        }
        try {
            int index = host.indexOf("/");
            if (index > -1) {
                return InetAddress.getByName(host.substring(index + 1));
            }
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String getLocalHostName() throws UnknownHostException {
        return LocalHostUtil.getLocalHost().getHostName();
    }

    public static String getLocalHostString() throws UnknownHostException {
        return LocalHostUtil.getLocalHost().toString();
    }

    public static String getCanonicalLocalHostName() throws UnknownHostException {
        return LocalHostUtil.getLocalHost().getCanonicalHostName();
    }
}

