/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer.kotlin;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.Result;
import kotlin.Triple;
import kotlin.UByte;
import kotlin.UByteArray;
import kotlin.UInt;
import kotlin.UIntArray;
import kotlin.ULong;
import kotlin.ULongArray;
import kotlin.UShort;
import kotlin.UShortArray;
import kotlin.ranges.CharProgression;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongProgression;
import kotlin.ranges.LongRange;
import kotlin.ranges.UIntProgression;
import kotlin.ranges.UIntRange;
import kotlin.ranges.ULongProgression;
import kotlin.ranges.ULongRange;
import kotlin.text.CharCategory;
import kotlin.text.CharDirectionality;
import kotlin.text.HexFormat;
import kotlin.text.MatchGroup;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimedValue;
import kotlin.uuid.Uuid;
import org.apache.fury.AbstractThreadSafeFury;
import org.apache.fury.Fury;
import org.apache.fury.ThreadSafeFury;
import org.apache.fury.resolver.ClassResolver;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.serializer.collection.CollectionSerializers;
import org.apache.fury.serializer.collection.MapSerializers;
import org.apache.fury.serializer.kotlin.DurationSerializer;
import org.apache.fury.serializer.kotlin.KotlinArrayDequeSerializer;
import org.apache.fury.serializer.kotlin.KotlinToJavaClass;
import org.apache.fury.serializer.kotlin.UByteArraySerializer;
import org.apache.fury.serializer.kotlin.UByteSerializer;
import org.apache.fury.serializer.kotlin.UIntArraySerializer;
import org.apache.fury.serializer.kotlin.UIntSerializer;
import org.apache.fury.serializer.kotlin.ULongArraySerializer;
import org.apache.fury.serializer.kotlin.ULongSerializer;
import org.apache.fury.serializer.kotlin.UShortArraySerializer;
import org.apache.fury.serializer.kotlin.UShortSerializer;
import org.apache.fury.serializer.kotlin.UuidSerializer;

public class KotlinSerializers {
    public static void registerSerializers(ThreadSafeFury fury) {
        AbstractThreadSafeFury threadSafeFury = (AbstractThreadSafeFury)fury;
        threadSafeFury.registerCallback(KotlinSerializers::registerSerializers);
    }

    public static void registerSerializers(Fury fury) {
        ClassResolver resolver = fury.getClassResolver();
        Class<UByte> ubyteClass = KotlinToJavaClass.INSTANCE.getUByteClass();
        resolver.register(ubyteClass);
        resolver.registerSerializer(ubyteClass, (Serializer)new UByteSerializer(fury));
        Class<UShort> ushortClass = KotlinToJavaClass.INSTANCE.getUShortClass();
        resolver.register(ushortClass);
        resolver.registerSerializer(ushortClass, (Serializer)new UShortSerializer(fury));
        Class<UInt> uintClass = KotlinToJavaClass.INSTANCE.getUIntClass();
        resolver.register(uintClass);
        resolver.registerSerializer(uintClass, (Serializer)new UIntSerializer(fury));
        Class<ULong> ulongClass = KotlinToJavaClass.INSTANCE.getULongClass();
        resolver.register(ulongClass);
        resolver.registerSerializer(ulongClass, (Serializer)new ULongSerializer(fury));
        Class<List<Object>> emptyListClass = KotlinToJavaClass.INSTANCE.getEmptyListClass();
        resolver.register(emptyListClass);
        resolver.registerSerializer(emptyListClass, (Serializer)new CollectionSerializers.EmptyListSerializer(fury, emptyListClass));
        Class<Set<Object>> emptySetClass = KotlinToJavaClass.INSTANCE.getEmptySetClass();
        resolver.register(emptySetClass);
        resolver.registerSerializer(emptySetClass, (Serializer)new CollectionSerializers.EmptySetSerializer(fury, emptySetClass));
        Class<Map<Object, Object>> emptyMapClass = KotlinToJavaClass.INSTANCE.getEmptyMapClass();
        resolver.register(emptyMapClass);
        resolver.registerSerializer(emptyMapClass, (Serializer)new MapSerializers.EmptyMapSerializer(fury, emptyMapClass));
        Class arrayDequeClass = KotlinToJavaClass.INSTANCE.getArrayDequeClass();
        resolver.register(arrayDequeClass);
        resolver.registerSerializer(arrayDequeClass, new KotlinArrayDequeSerializer(fury, arrayDequeClass));
        resolver.register(UByteArray.class);
        resolver.registerSerializer(UByteArray.class, (Serializer)new UByteArraySerializer(fury));
        resolver.register(UShortArray.class);
        resolver.registerSerializer(UShortArray.class, (Serializer)new UShortArraySerializer(fury));
        resolver.register(UIntArray.class);
        resolver.registerSerializer(UIntArray.class, (Serializer)new UIntArraySerializer(fury));
        resolver.register(ULongArray.class);
        resolver.registerSerializer(ULongArray.class, (Serializer)new ULongArraySerializer(fury));
        resolver.register(CharRange.class);
        resolver.register(CharProgression.class);
        resolver.register(IntRange.class);
        resolver.register(IntProgression.class);
        resolver.register(LongRange.class);
        resolver.register(LongProgression.class);
        resolver.register(UIntRange.class);
        resolver.register(UIntProgression.class);
        resolver.register(ULongRange.class);
        resolver.register(ULongProgression.class);
        resolver.register(Pair.class);
        resolver.register(Triple.class);
        resolver.register(Result.class);
        resolver.register(Result.Failure.class);
        resolver.register(KotlinToJavaClass.INSTANCE.getRandomDefaultClass());
        resolver.register(KotlinToJavaClass.INSTANCE.getRandomInternalClass());
        resolver.register(KotlinToJavaClass.INSTANCE.getRandomSerializedClass());
        resolver.register(Regex.class);
        resolver.register(KotlinToJavaClass.INSTANCE.getRegexSerializedClass());
        resolver.register(RegexOption.class);
        resolver.register(CharCategory.class);
        resolver.register(CharDirectionality.class);
        resolver.register(HexFormat.class);
        resolver.register(MatchGroup.class);
        resolver.register(DurationUnit.class);
        resolver.register(Duration.class);
        resolver.registerSerializer(Duration.class, (Serializer)new DurationSerializer(fury));
        resolver.register(TimedValue.class);
        resolver.register(Uuid.class);
        resolver.registerSerializer(Uuid.class, (Serializer)new UuidSerializer(fury));
    }
}

