/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.kotlin;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.ImmutableSerializer;
import org.apache.fory.serializer.Serializer;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\tJ\u001f\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/apache/fory/serializer/kotlin/DurationSerializer;", "Lorg/apache/fory/serializer/ImmutableSerializer;", "Lkotlin/time/Duration;", "fory", "Lorg/apache/fory/Fory;", "needToWriteRef", "", "<init>", "(Lorg/apache/fory/Fory;Z)V", "(Lorg/apache/fory/Fory;)V", "durationUnitSerializer", "Lorg/apache/fory/serializer/Serializer;", "Lkotlin/time/DurationUnit;", "getDurationUnitSerializer", "()Lorg/apache/fory/serializer/Serializer;", "durationUnitSerializer$delegate", "Lkotlin/Lazy;", "write", "", "buffer", "Lorg/apache/fory/memory/MemoryBuffer;", "value", "write-HG0u8IE", "(Lorg/apache/fory/memory/MemoryBuffer;J)V", "read", "read-5sfh64U", "(Lorg/apache/fory/memory/MemoryBuffer;)J", "computeDurationUnitPrecision", "computeDurationUnitPrecision-LRDsOJo", "(J)Lkotlin/time/DurationUnit;", "fory-kotlin"})
@SourceDebugExtension(value={"SMAP\nDurationSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DurationSerializer.kt\norg/apache/fory/serializer/kotlin/DurationSerializer\n+ 2 Duration.kt\nkotlin/time/Duration\n*L\n1#1,118:1\n683#2,2:119\n*S KotlinDebug\n*F\n+ 1 DurationSerializer.kt\norg/apache/fory/serializer/kotlin/DurationSerializer\n*L\n87#1:119,2\n*E\n"})
public final class DurationSerializer
extends ImmutableSerializer<Duration> {
    @NotNull
    private final Lazy durationUnitSerializer$delegate;

    public DurationSerializer(@NotNull Fory fory, boolean needToWriteRef) {
        Intrinsics.checkNotNullParameter((Object)fory, (String)"fory");
        super(fory, Duration.class, needToWriteRef);
        this.durationUnitSerializer$delegate = LazyKt.lazy(() -> DurationSerializer.durationUnitSerializer_delegate$lambda$0(fory));
    }

    public DurationSerializer(@NotNull Fory fory) {
        Intrinsics.checkNotNullParameter((Object)fory, (String)"fory");
        this(fory, fory.getConfig().isTimeRefIgnored());
    }

    private final Serializer<DurationUnit> getDurationUnitSerializer() {
        Lazy lazy = this.durationUnitSerializer$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Serializer)object;
    }

    public void write-HG0u8IE(@NotNull MemoryBuffer buffer, long value) {
        long l;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        DurationUnit unit = this.computeDurationUnitPrecision-LRDsOJo(value);
        this.getDurationUnitSerializer().write(buffer, (Object)unit);
        switch (WhenMappings.$EnumSwitchMapping$0[unit.ordinal()]) {
            case 1: {
                l = Duration.getInWholeNanoseconds-impl((long)value);
                break;
            }
            case 2: {
                l = Duration.getInWholeMicroseconds-impl((long)value);
                break;
            }
            case 3: {
                l = Duration.getInWholeMilliseconds-impl((long)value);
                break;
            }
            case 4: {
                l = Duration.getInWholeSeconds-impl((long)value);
                break;
            }
            case 5: {
                l = Duration.getInWholeMinutes-impl((long)value);
                break;
            }
            case 6: {
                l = Duration.getInWholeHours-impl((long)value);
                break;
            }
            case 7: {
                l = Duration.getInWholeDays-impl((long)value);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        long rawValue = l;
        buffer.writeInt64(rawValue);
    }

    public long read-5sfh64U(@NotNull MemoryBuffer buffer) {
        long l;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        DurationUnit unit = (DurationUnit)this.getDurationUnitSerializer().read(buffer);
        long rawValue = buffer.readInt64();
        DurationUnit durationUnit = unit;
        switch (durationUnit == null ? -1 : WhenMappings.$EnumSwitchMapping$0[durationUnit.ordinal()]) {
            case 1: {
                l = DurationKt.toDuration((long)rawValue, (DurationUnit)DurationUnit.NANOSECONDS);
                break;
            }
            case 2: {
                l = DurationKt.toDuration((long)rawValue, (DurationUnit)DurationUnit.MICROSECONDS);
                break;
            }
            case 3: {
                l = DurationKt.toDuration((long)rawValue, (DurationUnit)DurationUnit.MILLISECONDS);
                break;
            }
            case 4: {
                l = DurationKt.toDuration((long)rawValue, (DurationUnit)DurationUnit.SECONDS);
                break;
            }
            case 5: {
                l = DurationKt.toDuration((long)rawValue, (DurationUnit)DurationUnit.MINUTES);
                break;
            }
            case 6: {
                l = DurationKt.toDuration((long)rawValue, (DurationUnit)DurationUnit.HOURS);
                break;
            }
            case 7: {
                l = DurationKt.toDuration((long)rawValue, (DurationUnit)DurationUnit.DAYS);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private final DurationUnit computeDurationUnitPrecision-LRDsOJo(long value) {
        void hours;
        void minutes;
        void seconds;
        boolean nanoSecondPrecision;
        boolean microsecondPrecision;
        void nanoseconds;
        boolean millisecondPrecision;
        if (Duration.equals-impl0((long)value, (long)Duration.Companion.getZERO-UwyO8pc())) {
            return DurationUnit.NANOSECONDS;
        }
        if (Duration.isInfinite-impl((long)value)) {
            return DurationUnit.MILLISECONDS;
        }
        long arg0$iv = Duration.getAbsoluteValue-UwyO8pc((long)value);
        boolean bl = false;
        int n = Duration.getNanosecondsComponent-impl((long)arg0$iv);
        int n2 = Duration.getSecondsComponent-impl((long)arg0$iv);
        int n3 = Duration.getMinutesComponent-impl((long)arg0$iv);
        int n4 = Duration.getHoursComponent-impl((long)arg0$iv);
        long days = Duration.getInWholeDays-impl((long)arg0$iv);
        boolean bl2 = false;
        boolean bl3 = millisecondPrecision = nanoseconds >= 1000000 && nanoseconds % 1000000 == false;
        if (millisecondPrecision) {
            return DurationUnit.MILLISECONDS;
        }
        boolean bl4 = microsecondPrecision = nanoseconds >= 1000 && nanoseconds % 1000 == false;
        if (microsecondPrecision) {
            return DurationUnit.MICROSECONDS;
        }
        boolean bl5 = nanoSecondPrecision = nanoseconds != false && nanoseconds % 1000 != false;
        if (nanoSecondPrecision) {
            return DurationUnit.NANOSECONDS;
        }
        if (seconds != false) {
            return DurationUnit.SECONDS;
        }
        if (minutes != false) {
            return DurationUnit.MINUTES;
        }
        if (hours != false) {
            return DurationUnit.HOURS;
        }
        return DurationUnit.DAYS;
    }

    private static final Serializer durationUnitSerializer_delegate$lambda$0(Fory $fory) {
        return $fory.getClassResolver().getSerializer(DurationUnit.class);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DurationUnit.values().length];
            try {
                nArray[DurationUnit.NANOSECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.MICROSECONDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.MILLISECONDS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.SECONDS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.MINUTES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.HOURS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.DAYS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

