/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.kotlin;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.apache.fory.collection.ClassValueCache;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.Platform;
import org.apache.fory.util.DefaultValueUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\n2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0014\u0010\u0014\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rd\u0010\u0006\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n \u000b*\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b0\b \u000b**\u0012$\u0012\"\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n \u000b*\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/apache/fory/serializer/kotlin/KotlinDefaultValueSupport;", "Lorg/apache/fory/util/DefaultValueUtils$DefaultValueSupport;", "<init>", "()V", "LOG", "Lorg/apache/fory/logging/Logger;", "cachedKotlinDataClassDefaultValues", "Lorg/apache/fory/collection/ClassValueCache;", "", "", "", "kotlin.jvm.PlatformType", "Lorg/apache/fory/collection/ClassValueCache;", "hasDefaultValues", "", "cls", "Ljava/lang/Class;", "getAllDefaultValues", "getDefaultValue", "fieldName", "isKotlinDataClass", "getDefaultValueForType", "type", "Ljava/lang/reflect/Type;", "fory-kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinDefaultValueSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDefaultValueSupport.kt\norg/apache/fory/serializer/kotlin/KotlinDefaultValueSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class KotlinDefaultValueSupport
extends DefaultValueUtils.DefaultValueSupport {
    @NotNull
    private final Logger LOG;
    private final ClassValueCache<Map<String, Object>> cachedKotlinDataClassDefaultValues;

    public KotlinDefaultValueSupport() {
        Logger logger = LoggerFactory.getLogger(KotlinDefaultValueSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.LOG = logger;
        this.cachedKotlinDataClassDefaultValues = ClassValueCache.newClassKeyCache((int)32);
    }

    public boolean hasDefaultValues(@NotNull Class<?> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        if (!this.isKotlinDataClass(cls)) {
            return false;
        }
        return !this.getAllDefaultValues(cls).isEmpty();
    }

    @NotNull
    public Map<String, Object> getAllDefaultValues(@NotNull Class<?> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Map map = (Map)this.cachedKotlinDataClassDefaultValues.getIfPresent(cls);
        if (map != null) {
            Map it = map;
            boolean bl = false;
            return it;
        }
        try {
            if (!this.isKotlinDataClass(cls)) {
                this.cachedKotlinDataClassDefaultValues.put(cls, (Object)MapsKt.emptyMap());
                return MapsKt.emptyMap();
            }
            KClass kClass = JvmClassMappingKt.getKotlinClass(cls);
            KFunction kFunction = KClasses.getPrimaryConstructor((KClass)kClass);
            if (kFunction == null) {
                return MapsKt.emptyMap();
            }
            KFunction primaryConstructor = kFunction;
            List parameters = primaryConstructor.getParameters();
            Map argsMap = new LinkedHashMap();
            for (KParameter parameter : parameters) {
                if (parameter.isOptional()) continue;
                Object defaultValue = this.getDefaultValueForType(ReflectJvmMapping.getJavaType((KType)parameter.getType()));
                if (defaultValue != null) {
                    argsMap.put(parameter, defaultValue);
                    continue;
                }
                this.cachedKotlinDataClassDefaultValues.put(cls, (Object)MapsKt.emptyMap());
                return MapsKt.emptyMap();
            }
            Object instance = primaryConstructor.callBy(argsMap);
            Map defaultValues = new LinkedHashMap();
            for (KParameter parameter : parameters) {
                KProperty1 prop;
                Object v1;
                block9: {
                    if (!parameter.isOptional() || parameter.getName() == null) continue;
                    Iterable iterable = KClasses.getMemberProperties((KClass)kClass);
                    for (Object t : iterable) {
                        KProperty1 it = (KProperty1)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)parameter.getName())) continue;
                        v1 = t;
                        break block9;
                    }
                    v1 = null;
                }
                KProperty1 property = v1;
                if (property == null) continue;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)instance, (String)"null cannot be cast to non-null type kotlin.Any");
                Object value = prop.get(instance);
                if (value == null) continue;
                String string = parameter.getName();
                Intrinsics.checkNotNull((Object)string);
                defaultValues.put(string, value);
            }
            this.cachedKotlinDataClassDefaultValues.put(cls, (Object)defaultValues);
            map = defaultValues;
        }
        catch (Exception e) {
            this.LOG.info("Error getting default values for class " + cls.getName() + ": " + e.getMessage());
            this.cachedKotlinDataClassDefaultValues.put(cls, (Object)MapsKt.emptyMap());
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Nullable
    public Object getDefaultValue(@NotNull Class<?> cls, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        if (!this.isKotlinDataClass(cls)) {
            return null;
        }
        return this.getAllDefaultValues(cls).get(fieldName);
    }

    private final boolean isKotlinDataClass(Class<?> cls) {
        return JvmClassMappingKt.getKotlinClass(cls).isData();
    }

    private final Object getDefaultValueForType(Type type) {
        Type type2;
        Type type3 = type;
        Class clazz = type3 instanceof Class ? (Class)type : (type3 instanceof ParameterizedType ? ((type2 = ((ParameterizedType)type).getRawType()) instanceof Class ? (Class)type2 : null) : null);
        if (clazz == null) {
            return null;
        }
        Class clazz2 = clazz;
        Class clazz3 = clazz2;
        return Intrinsics.areEqual((Object)clazz3, Integer.TYPE) || Intrinsics.areEqual((Object)clazz3, Integer.TYPE) ? Integer.valueOf(0) : (Intrinsics.areEqual((Object)clazz3, Long.TYPE) || Intrinsics.areEqual((Object)clazz3, Long.TYPE) ? Long.valueOf(0L) : (Intrinsics.areEqual((Object)clazz3, Double.TYPE) || Intrinsics.areEqual((Object)clazz3, Double.TYPE) ? Double.valueOf(0.0) : (Intrinsics.areEqual((Object)clazz3, Float.TYPE) || Intrinsics.areEqual((Object)clazz3, Float.TYPE) ? Float.valueOf(0.0f) : (Intrinsics.areEqual((Object)clazz3, Boolean.TYPE) || Intrinsics.areEqual((Object)clazz3, Boolean.TYPE) ? Boolean.valueOf(false) : (Intrinsics.areEqual((Object)clazz3, Byte.TYPE) || Intrinsics.areEqual((Object)clazz3, Byte.TYPE) ? Byte.valueOf((byte)0) : (Intrinsics.areEqual((Object)clazz3, Short.TYPE) || Intrinsics.areEqual((Object)clazz3, Short.TYPE) ? Short.valueOf((short)0) : (Intrinsics.areEqual((Object)clazz3, Character.TYPE) || Intrinsics.areEqual((Object)clazz3, Character.TYPE) ? Character.valueOf('\u0000') : (Intrinsics.areEqual((Object)clazz3, String.class) ? "" : Platform.newInstance((Class)clazz2)))))))));
    }
}

