/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.extension.serializer;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.util.unsafe._JDKAccess;

public class ProtobufSerializer
extends Serializer<Message> {
    private static final int SMALL_BYTES_THRESHOLD = 32;
    private static final ClassValue<MethodHandle[]> parseFromMethodCache = new ClassValue<MethodHandle[]>(){

        @Override
        protected MethodHandle[] computeValue(Class<?> type) {
            try {
                MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(type);
                MethodHandle parseFrom1 = lookup.findStatic(type, "parseFrom", MethodType.methodType(type, CodedInputStream.class));
                MethodHandle parseFrom2 = lookup.findStatic(type, "parseFrom", MethodType.methodType(type, ByteBuffer.class));
                return new MethodHandle[]{parseFrom1, parseFrom2};
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final MethodHandle parseFromStream;
    private final ExtensionRegistryLite emptyRegistry;
    private final MethodHandle parseFromByteBuffer;

    public ProtobufSerializer(Fory fory, Class type) {
        super(fory, type, true);
        MethodHandle[] methodHandles = parseFromMethodCache.get(type);
        this.parseFromStream = methodHandles[0];
        this.parseFromByteBuffer = methodHandles[0];
        this.emptyRegistry = ExtensionRegistryLite.getEmptyRegistry();
    }

    public void write(MemoryBuffer buffer, Message value) {
        int size = value.getSerializedSize();
        buffer.writeVarUint32(size);
        buffer.grow(size);
        byte[] heapMemory = buffer.getHeapMemory();
        try {
            if (heapMemory != null) {
                int writerIndex = buffer._unsafeHeapWriterIndex();
                CodedOutputStream stream = CodedOutputStream.newInstance((byte[])heapMemory, (int)writerIndex, (int)size);
                value.writeTo(stream);
                buffer.increaseWriterIndex(size);
            } else if (size < 32) {
                buffer.writeBytes(value.toByteArray());
            } else {
                ByteBuffer buf = buffer.sliceAsByteBuffer(buffer._unsafeHeapWriterIndex(), size);
                CodedOutputStream stream = CodedOutputStream.newInstance((ByteBuffer)buf);
                value.writeTo(stream);
                buffer.increaseWriterIndex(size);
            }
        }
        catch (IOException e) {
            Platform.throwException((Throwable)e);
        }
    }

    public Message read(MemoryBuffer buffer) {
        int size = buffer.readVarUint32Small14();
        buffer.checkReadableBytes(size);
        byte[] heapMemory = buffer.getHeapMemory();
        try {
            if (heapMemory != null) {
                CodedInputStream stream = CodedInputStream.newInstance((byte[])heapMemory, (int)buffer._unsafeHeapReaderIndex(), (int)size);
                buffer.increaseReaderIndex(size);
                return this.parseFromStream.invoke(stream);
            }
            if (size < 32) {
                byte[] bytes = buffer.readBytes(size);
                return this.parseFromStream.invoke(bytes, this.emptyRegistry);
            }
            ByteBuffer byteBuffer = buffer.sliceAsByteBuffer(buffer.readerIndex(), size);
            buffer.increaseReaderIndex(size);
            return this.parseFromByteBuffer.invoke(byteBuffer);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

