/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.data;

import java.io.Serializable;
import java.util.Objects;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumn;

public final class Span
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RowColumn start = RowColumn.EMPTY;
    private boolean startInclusive = true;
    private RowColumn end = RowColumn.EMPTY;
    private boolean endInclusive = true;

    public Span() {
    }

    private Span(Builder builder) {
        this.startInclusive = ((Builder)builder).start.inclusive;
        if (!((Builder)builder).start.infinite) {
            this.start = Span.buildRowColumn(builder.start);
            if (!this.startInclusive) {
                this.start = this.start.following();
                this.startInclusive = true;
            }
        }
        this.endInclusive = ((Builder)builder).end.inclusive;
        if (!((Builder)builder).end.infinite) {
            this.end = Span.buildRowColumn(builder.end);
            if (this.endInclusive) {
                this.end = this.end.following();
                this.endInclusive = false;
            }
        }
    }

    private static RowColumn buildRowColumn(KeyBuilder key) {
        if (key.infinite || key.row.equals(Bytes.EMPTY)) {
            return RowColumn.EMPTY;
        }
        if (key.cf.equals(Bytes.EMPTY)) {
            return new RowColumn(key.row);
        }
        if (key.cq.equals(Bytes.EMPTY)) {
            return new RowColumn(key.row, new Column(key.cf));
        }
        if (key.cv.equals(Bytes.EMPTY)) {
            return new RowColumn(key.row, new Column(key.cf, key.cq));
        }
        return new RowColumn(key.row, new Column(key.cf, key.cq, key.cv));
    }

    public Span(RowColumn start, boolean startInclusive, RowColumn end, boolean endInclusive) {
        Objects.requireNonNull(start, "start must not be null");
        Objects.requireNonNull(end, "end must not be null");
        this.start = start;
        this.startInclusive = startInclusive;
        this.end = end;
        this.endInclusive = endInclusive;
    }

    public Span(Bytes startRow, boolean startRowInclusive, Bytes endRow, boolean endRowInclusive) {
        Objects.requireNonNull(startRow, "startRow must not be null");
        Objects.requireNonNull(endRow, "endRow must not be null");
        this.startInclusive = startRowInclusive;
        if (!startRow.equals(Bytes.EMPTY)) {
            this.start = new RowColumn(startRow);
            if (!this.startInclusive) {
                this.start = this.start.following();
                this.startInclusive = true;
            }
        }
        this.endInclusive = endRowInclusive;
        if (!endRow.equals(Bytes.EMPTY)) {
            this.end = new RowColumn(endRow);
            if (this.endInclusive) {
                this.end = this.end.following();
                this.endInclusive = false;
            }
        }
    }

    public Span(CharSequence startRow, boolean startRowInclusive, CharSequence endRow, boolean endRowInclusive) {
        this(Bytes.of(startRow), startRowInclusive, Bytes.of(endRow), endRowInclusive);
    }

    public RowColumn getStart() {
        return this.start;
    }

    public RowColumn getEnd() {
        return this.end;
    }

    public boolean isStartInclusive() {
        return this.startInclusive;
    }

    public boolean isEndInclusive() {
        return this.endInclusive;
    }

    public boolean equals(Object o) {
        return o instanceof Span && this.equals((Span)o);
    }

    public boolean equals(Span other) {
        return this.start.equals(other.start) && this.startInclusive == other.startInclusive && this.end.equals(other.end) && this.endInclusive == other.endInclusive;
    }

    public String toString() {
        return (this.startInclusive && !this.start.equals(RowColumn.EMPTY) ? "[" : "(") + (this.start.equals(RowColumn.EMPTY) ? "-inf" : this.start) + "," + (this.end.equals(RowColumn.EMPTY) ? "+inf" : this.end) + (this.endInclusive && !this.end.equals(RowColumn.EMPTY) ? "]" : ")");
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.startInclusive, this.endInclusive);
    }

    public static Span exact(Bytes row) {
        Objects.requireNonNull(row);
        return new Span(row, true, row, true);
    }

    public static Span exact(CharSequence row) {
        Objects.requireNonNull(row);
        return Span.exact(Bytes.of(row));
    }

    public static Span exact(Bytes row, Column col) {
        Objects.requireNonNull(row);
        Objects.requireNonNull(col);
        RowColumn start = new RowColumn(row, col);
        return new Span(start, true, start.following(), false);
    }

    public static Span exact(CharSequence row, Column col) {
        Objects.requireNonNull(row);
        Objects.requireNonNull(col);
        return Span.exact(Bytes.of(row), col);
    }

    private static Bytes followingPrefix(Bytes prefix) {
        int changeIndex;
        byte[] prefixBytes = prefix.toArray();
        for (changeIndex = prefix.length() - 1; changeIndex >= 0 && prefixBytes[changeIndex] == -1; --changeIndex) {
        }
        if (changeIndex < 0) {
            return null;
        }
        byte[] newBytes = new byte[changeIndex + 1];
        System.arraycopy(prefixBytes, 0, newBytes, 0, changeIndex + 1);
        int n = changeIndex;
        newBytes[n] = (byte)(newBytes[n] + 1);
        return Bytes.of(newBytes);
    }

    public static Span prefix(Bytes rowPrefix) {
        Objects.requireNonNull(rowPrefix);
        Bytes fp = Span.followingPrefix(rowPrefix);
        return new Span(rowPrefix, true, fp == null ? Bytes.EMPTY : fp, false);
    }

    public static Span prefix(CharSequence rowPrefix) {
        Objects.requireNonNull(rowPrefix);
        return Span.prefix(Bytes.of(rowPrefix));
    }

    public static Span prefix(Bytes row, Column colPrefix) {
        Objects.requireNonNull(row);
        Objects.requireNonNull(colPrefix);
        Bytes cf = colPrefix.getFamily();
        Bytes cq = colPrefix.getQualifier();
        Bytes cv = colPrefix.getVisibility();
        if (colPrefix.isVisibilitySet()) {
            Bytes fp = Span.followingPrefix(cv);
            RowColumn end = fp == null ? new RowColumn(row, new Column(cf, cq)).following() : new RowColumn(row, new Column(cf, cq, fp));
            return new Span(new RowColumn(row, colPrefix), true, end, false);
        }
        if (colPrefix.isQualifierSet()) {
            Bytes fp = Span.followingPrefix(cq);
            RowColumn end = fp == null ? new RowColumn(row, new Column(cf)).following() : new RowColumn(row, new Column(cf, fp));
            return new Span(new RowColumn(row, colPrefix), true, end, false);
        }
        if (colPrefix.isFamilySet()) {
            Bytes fp = Span.followingPrefix(cf);
            RowColumn end = fp == null ? new RowColumn(row).following() : new RowColumn(row, new Column(fp));
            return new Span(new RowColumn(row, colPrefix), true, end, false);
        }
        return Span.prefix(row);
    }

    public static Span prefix(CharSequence row, Column colPrefix) {
        Objects.requireNonNull(row);
        Objects.requireNonNull(colPrefix);
        return Span.prefix(Bytes.of(row), colPrefix);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class EndCFBuilder
    extends EndBuilder {
        private EndCFBuilder(Builder builder) {
            super(builder);
        }

        public EndCQBuilder fam(Bytes cf) {
            ((Builder)this.builder).end.cf = cf;
            return new EndCQBuilder(this.builder);
        }

        public EndCQBuilder fam(CharSequence cf) {
            return this.fam(Bytes.of(cf));
        }
    }

    public static class EndCQBuilder
    extends EndBuilder {
        private EndCQBuilder(Builder builder) {
            super(builder);
        }

        public EndCVBuilder qual(Bytes cq) {
            ((Builder)this.builder).end.cq = cq;
            return new EndCVBuilder(this.builder);
        }

        public EndCVBuilder qual(CharSequence cq) {
            return this.qual(Bytes.of(cq));
        }
    }

    public static class EndCVBuilder
    extends EndBuilder {
        private EndCVBuilder(Builder builder) {
            super(builder);
        }

        public EndBuilder vis(Bytes cv) {
            ((Builder)this.builder).end.cv = cv;
            return this;
        }

        public EndBuilder vis(CharSequence cv) {
            return this.vis(Bytes.of(cv));
        }
    }

    public static class StartCFBuilder
    extends StartBuilder {
        private StartCFBuilder(Builder builder) {
            super(builder);
        }

        public StartCQBuilder fam(Bytes cf) {
            ((Builder)this.builder).start.cf = cf;
            return new StartCQBuilder(this.builder);
        }

        public StartCQBuilder fam(CharSequence cf) {
            return this.fam(Bytes.of(cf));
        }
    }

    public static class StartCQBuilder
    extends StartBuilder {
        private StartCQBuilder(Builder builder) {
            super(builder);
        }

        public StartCVBuilder qual(Bytes cq) {
            ((Builder)this.builder).start.cq = cq;
            return new StartCVBuilder(this.builder);
        }

        public StartCVBuilder qual(CharSequence cq) {
            return this.qual(Bytes.of(cq));
        }
    }

    public static class StartCVBuilder
    extends StartBuilder {
        private StartCVBuilder(Builder builder) {
            super(builder);
        }

        public StartBuilder vis(Bytes cv) {
            ((Builder)this.builder).start.cv = cv;
            return new StartBuilder(this.builder);
        }

        public StartBuilder vis(CharSequence cv) {
            return this.vis(Bytes.of(cv));
        }
    }

    public static class EndBuilder {
        protected Builder builder;

        private EndBuilder(Builder builder) {
            this.builder = builder;
        }

        public EndBuilder exclusive() {
            ((Builder)this.builder).end.inclusive = false;
            return this;
        }

        public Span build() {
            return new Span(this.builder);
        }
    }

    public static class StartBuilder {
        protected Builder builder;

        private StartBuilder(Builder builder) {
            this.builder = builder;
        }

        public EndCFBuilder endRow(Bytes row) {
            return this.builder.endRow(row);
        }

        public EndCFBuilder endRow(CharSequence row) {
            return this.endRow(Bytes.of(row));
        }

        public StartBuilder exclusive() {
            ((Builder)this.builder).start.inclusive = false;
            return this;
        }

        public Span build() {
            return new Span(this.builder);
        }
    }

    public static class Builder {
        private KeyBuilder start = new KeyBuilder();
        private KeyBuilder end = new KeyBuilder();

        private Builder() {
        }

        public StartCFBuilder startRow(Bytes row) {
            this.start.row = row;
            this.start.infinite = false;
            return new StartCFBuilder(this);
        }

        public StartCFBuilder startRow(CharSequence row) {
            return this.startRow(Bytes.of(row));
        }

        public EndCFBuilder endRow(Bytes row) {
            this.end.row = row;
            this.end.infinite = false;
            return new EndCFBuilder(this);
        }

        public EndCFBuilder endRow(CharSequence row) {
            return this.endRow(Bytes.of(row));
        }

        public Span build() {
            return new Span(this);
        }
    }

    private static class KeyBuilder {
        protected Bytes row = Bytes.EMPTY;
        protected Bytes cf = Bytes.EMPTY;
        protected Bytes cq = Bytes.EMPTY;
        protected Bytes cv = Bytes.EMPTY;
        protected boolean inclusive = true;
        protected boolean infinite = true;

        private KeyBuilder() {
        }
    }
}

