/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.config;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.api.config.ObserverSpecification;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluoConfiguration
extends SimpleConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FluoConfiguration.class);
    public static final String FLUO_PREFIX = "fluo";
    private static final String CLIENT_PREFIX = "fluo.client";
    public static final String CLIENT_APPLICATION_NAME_PROP = "fluo.client.application.name";
    public static final String CLIENT_ACCUMULO_PASSWORD_PROP = "fluo.client.accumulo.password";
    public static final String CLIENT_ACCUMULO_USER_PROP = "fluo.client.accumulo.user";
    public static final String CLIENT_ACCUMULO_INSTANCE_PROP = "fluo.client.accumulo.instance";
    public static final String CLIENT_ACCUMULO_ZOOKEEPERS_PROP = "fluo.client.accumulo.zookeepers";
    public static final String CLIENT_ZOOKEEPER_TIMEOUT_PROP = "fluo.client.zookeeper.timeout";
    public static final String CLIENT_ZOOKEEPER_CONNECT_PROP = "fluo.client.zookeeper.connect";
    public static final String CLIENT_RETRY_TIMEOUT_MS_PROP = "fluo.client.retry.timeout.ms";
    public static final int CLIENT_ZOOKEEPER_TIMEOUT_DEFAULT = 30000;
    public static final String CLIENT_ACCUMULO_ZOOKEEPERS_DEFAULT = "localhost";
    public static final String CLIENT_ZOOKEEPER_CONNECT_DEFAULT = "localhost/fluo";
    public static final int CLIENT_RETRY_TIMEOUT_MS_DEFAULT = -1;
    private static final String ADMIN_PREFIX = "fluo.admin";
    public static final String ADMIN_ACCUMULO_TABLE_PROP = "fluo.admin.accumulo.table";
    public static final String ADMIN_ACCUMULO_CLASSPATH_PROP = "fluo.admin.accumulo.classpath";
    public static final String ADMIN_ACCUMULO_CLASSPATH_DEFAULT = "";
    private static final String WORKER_PREFIX = "fluo.worker";
    public static final String WORKER_NUM_THREADS_PROP = "fluo.worker.num.threads";
    public static final int WORKER_NUM_THREADS_DEFAULT = 10;
    private static final String LOADER_PREFIX = "fluo.loader";
    public static final String LOADER_NUM_THREADS_PROP = "fluo.loader.num.threads";
    public static final String LOADER_QUEUE_SIZE_PROP = "fluo.loader.queue.size";
    public static final int LOADER_NUM_THREADS_DEFAULT = 10;
    public static final int LOADER_QUEUE_SIZE_DEFAULT = 10;
    private static final String MINI_PREFIX = "fluo.mini";
    public static final String MINI_START_ACCUMULO_PROP = "fluo.mini.start.accumulo";
    public static final String MINI_DATA_DIR_PROP = "fluo.mini.data.dir";
    public static final boolean MINI_START_ACCUMULO_DEFAULT = true;
    public static final String MINI_DATA_DIR_DEFAULT = "${env:FLUO_HOME}/mini";
    public static final String OBSERVER_PREFIX = "fluo.observer.";
    public static final String TRANSACTION_PREFIX = "fluo.tx";
    public static final String TRANSACTION_ROLLBACK_TIME_PROP = "fluo.tx.rollback.time";
    public static final long TRANSACTION_ROLLBACK_TIME_DEFAULT = 300000L;
    public static final String REPORTER_PREFIX = "fluo.metrics.reporter";
    public static final String APP_PREFIX = "fluo.app";

    public FluoConfiguration() {
    }

    public FluoConfiguration(SimpleConfiguration other) {
        super(other);
    }

    public FluoConfiguration(InputStream in) {
        super(in);
    }

    public FluoConfiguration(File propertiesFile) {
        super(propertiesFile);
    }

    public FluoConfiguration(Map<String, String> map) {
        super(map);
    }

    public void validate() {
        this.getAccumuloClasspath();
        this.getAccumuloInstance();
        this.getAccumuloPassword();
        this.getAccumuloTable();
        this.getAccumuloUser();
        this.getAccumuloZookeepers();
        this.getApplicationName();
        this.getAppZookeepers();
        this.getClientRetryTimeout();
        this.getLoaderQueueSize();
        this.getLoaderThreads();
        this.getObserverSpecifications();
        this.getTransactionRollbackTime();
        this.getWorkerThreads();
        this.getZookeeperTimeout();
    }

    public FluoConfiguration setApplicationName(String applicationName) {
        this.verifyApplicationName(applicationName);
        this.setProperty(CLIENT_APPLICATION_NAME_PROP, applicationName);
        return this;
    }

    public String getApplicationName() {
        String applicationName = this.getString(CLIENT_APPLICATION_NAME_PROP);
        this.verifyApplicationName(applicationName);
        return applicationName;
    }

    private void verifyApplicationName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Application name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Application name length must be > 0");
        }
        String reason = null;
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u0000') {
                reason = "null character not allowed @" + i;
                break;
            }
            if (c == '/' || c == '.' || c == ':') {
                reason = "invalid character '" + c + "'";
                break;
            }
            if (!(c > '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\ud800' && c <= '\uf8ff') && (c < '\ufff0' || c > '\uffff')) continue;
            reason = "invalid character @" + i;
            break;
        }
        if (reason != null) {
            throw new IllegalArgumentException("Invalid application name \"" + name + "\" caused by " + reason);
        }
    }

    public FluoConfiguration setInstanceZookeepers(String zookeepers) {
        return this.setNonEmptyString(CLIENT_ZOOKEEPER_CONNECT_PROP, zookeepers);
    }

    public String getInstanceZookeepers() {
        return this.getNonEmptyString(CLIENT_ZOOKEEPER_CONNECT_PROP, CLIENT_ZOOKEEPER_CONNECT_DEFAULT);
    }

    public String getAppZookeepers() {
        return this.getInstanceZookeepers() + "/" + this.getApplicationName();
    }

    public FluoConfiguration setZookeeperTimeout(int timeout) {
        return this.setPositiveInt(CLIENT_ZOOKEEPER_TIMEOUT_PROP, timeout);
    }

    public int getZookeeperTimeout() {
        return this.getPositiveInt(CLIENT_ZOOKEEPER_TIMEOUT_PROP, 30000);
    }

    public FluoConfiguration setClientRetryTimeout(int timeoutMS) {
        Preconditions.checkArgument((timeoutMS >= -1 ? 1 : 0) != 0, (Object)"fluo.client.retry.timeout.ms must be >= -1");
        this.setProperty(CLIENT_RETRY_TIMEOUT_MS_PROP, timeoutMS);
        return this;
    }

    public int getClientRetryTimeout() {
        int retval = this.getInt(CLIENT_RETRY_TIMEOUT_MS_PROP, -1);
        Preconditions.checkArgument((retval >= -1 ? 1 : 0) != 0, (Object)"fluo.client.retry.timeout.ms must be >= -1");
        return retval;
    }

    public FluoConfiguration setAccumuloInstance(String accumuloInstance) {
        return this.setNonEmptyString(CLIENT_ACCUMULO_INSTANCE_PROP, accumuloInstance);
    }

    public String getAccumuloInstance() {
        return this.getNonEmptyString(CLIENT_ACCUMULO_INSTANCE_PROP);
    }

    public FluoConfiguration setAccumuloUser(String accumuloUser) {
        return this.setNonEmptyString(CLIENT_ACCUMULO_USER_PROP, accumuloUser);
    }

    public String getAccumuloUser() {
        return this.getNonEmptyString(CLIENT_ACCUMULO_USER_PROP);
    }

    public FluoConfiguration setAccumuloPassword(String accumuloPassword) {
        this.setProperty(CLIENT_ACCUMULO_PASSWORD_PROP, FluoConfiguration.verifyNotNull(CLIENT_ACCUMULO_PASSWORD_PROP, accumuloPassword));
        return this;
    }

    public String getAccumuloPassword() {
        return FluoConfiguration.verifyNotNull(CLIENT_ACCUMULO_PASSWORD_PROP, this.getString(CLIENT_ACCUMULO_PASSWORD_PROP));
    }

    public FluoConfiguration setAccumuloZookeepers(String zookeepers) {
        return this.setNonEmptyString(CLIENT_ACCUMULO_ZOOKEEPERS_PROP, zookeepers);
    }

    public String getAccumuloZookeepers() {
        return this.getNonEmptyString(CLIENT_ACCUMULO_ZOOKEEPERS_PROP, CLIENT_ACCUMULO_ZOOKEEPERS_DEFAULT);
    }

    public FluoConfiguration setAccumuloTable(String table) {
        return this.setNonEmptyString(ADMIN_ACCUMULO_TABLE_PROP, table);
    }

    public String getAccumuloTable() {
        return this.getNonEmptyString(ADMIN_ACCUMULO_TABLE_PROP);
    }

    public FluoConfiguration setAccumuloClasspath(String path) {
        this.setProperty(ADMIN_ACCUMULO_CLASSPATH_PROP, FluoConfiguration.verifyNotNull(ADMIN_ACCUMULO_CLASSPATH_PROP, path));
        return this;
    }

    public String getAccumuloClasspath() {
        return this.getString(ADMIN_ACCUMULO_CLASSPATH_PROP, ADMIN_ACCUMULO_CLASSPATH_DEFAULT);
    }

    public FluoConfiguration setWorkerThreads(int numThreads) {
        return this.setPositiveInt(WORKER_NUM_THREADS_PROP, numThreads);
    }

    public int getWorkerThreads() {
        return this.getPositiveInt(WORKER_NUM_THREADS_PROP, 10);
    }

    public List<ObserverSpecification> getObserverSpecifications() {
        ArrayList<ObserverSpecification> configList = new ArrayList<ObserverSpecification>();
        Iterator<String> iter = this.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.startsWith(OBSERVER_PREFIX)) continue;
            String value = this.getString(key).trim();
            if (value.isEmpty()) {
                throw new IllegalArgumentException(key + " is set to empty value");
            }
            String[] fields = value.split(",");
            if (fields.length == 0) {
                throw new IllegalArgumentException(key + " has bad value: " + value);
            }
            String className = fields[0];
            if (className.isEmpty()) {
                throw new IllegalArgumentException(key + " has empty class name: " + className);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            for (int i = 1; i < fields.length; ++i) {
                String[] kv = fields[i].split("=");
                if (kv.length != 2) {
                    throw new IllegalArgumentException(key + " has invalid param. Expected 'key=value' but encountered '" + fields[i] + "'");
                }
                if (kv[0].isEmpty() || kv[1].isEmpty()) {
                    throw new IllegalArgumentException(key + " has empty key or value in param: " + fields[i]);
                }
                params.put(kv[0], kv[1]);
            }
            ObserverSpecification observerSpecification = new ObserverSpecification(className, params);
            configList.add(observerSpecification);
        }
        return configList;
    }

    private int getNextObserverId() {
        Iterator<String> iter1 = this.getKeys(OBSERVER_PREFIX.substring(0, OBSERVER_PREFIX.length() - 1));
        int max = -1;
        while (iter1.hasNext()) {
            String key = iter1.next();
            String suffix = key.substring(OBSERVER_PREFIX.length());
            if (!suffix.matches("\\d+")) continue;
            try {
                max = Math.max(max, Integer.parseInt(suffix));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return max + 1;
    }

    private void addObserver(ObserverSpecification oconf, int next) {
        Map<String, String> params = oconf.getConfiguration().toMap();
        StringBuilder paramString = new StringBuilder();
        for (Map.Entry<String, String> pentry : params.entrySet()) {
            paramString.append(',');
            paramString.append(pentry.getKey());
            paramString.append('=');
            paramString.append(pentry.getValue());
        }
        this.setProperty(OBSERVER_PREFIX + next, oconf.getClassName() + paramString);
    }

    public FluoConfiguration addObserver(ObserverSpecification oconf) {
        int next = this.getNextObserverId();
        this.addObserver(oconf, next);
        return this;
    }

    public FluoConfiguration addObservers(Iterable<ObserverSpecification> observers) {
        int next = this.getNextObserverId();
        for (ObserverSpecification oconf : observers) {
            this.addObserver(oconf, next++);
        }
        return this;
    }

    public FluoConfiguration clearObservers() {
        Iterator<String> iter1 = this.getKeys(OBSERVER_PREFIX.substring(0, OBSERVER_PREFIX.length() - 1));
        while (iter1.hasNext()) {
            String key = iter1.next();
            this.clearProperty(key);
        }
        return this;
    }

    public FluoConfiguration setTransactionRollbackTime(long time, TimeUnit tu) {
        return this.setPositiveLong(TRANSACTION_ROLLBACK_TIME_PROP, tu.toMillis(time));
    }

    public long getTransactionRollbackTime() {
        return this.getPositiveLong(TRANSACTION_ROLLBACK_TIME_PROP, 300000L);
    }

    public FluoConfiguration setLoaderThreads(int numThreads) {
        return this.setNonNegativeInt(LOADER_NUM_THREADS_PROP, numThreads);
    }

    public int getLoaderThreads() {
        return this.getNonNegativeInt(LOADER_NUM_THREADS_PROP, 10);
    }

    public FluoConfiguration setLoaderQueueSize(int queueSize) {
        return this.setNonNegativeInt(LOADER_QUEUE_SIZE_PROP, queueSize);
    }

    public int getLoaderQueueSize() {
        return this.getNonNegativeInt(LOADER_QUEUE_SIZE_PROP, 10);
    }

    public SimpleConfiguration getReporterConfiguration(String reporter) {
        return this.subset("fluo.metrics.reporter." + reporter);
    }

    public SimpleConfiguration getAppConfiguration() {
        return this.subset(APP_PREFIX);
    }

    public FluoConfiguration setMiniStartAccumulo(boolean startAccumulo) {
        this.setProperty(MINI_START_ACCUMULO_PROP, startAccumulo);
        return this;
    }

    public boolean getMiniStartAccumulo() {
        return this.getBoolean(MINI_START_ACCUMULO_PROP, true);
    }

    public FluoConfiguration setMiniDataDir(String dataDir) {
        return this.setNonEmptyString(MINI_DATA_DIR_PROP, dataDir);
    }

    public String getMiniDataDir() {
        return this.getNonEmptyString(MINI_DATA_DIR_PROP, MINI_DATA_DIR_DEFAULT);
    }

    public void print() {
        Iterator<String> iter = this.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            log.info(key + " = " + this.getRawString(key));
        }
    }

    private boolean verifyStringPropSet(String key) {
        if (this.containsKey(key) && !this.getString(key).isEmpty()) {
            return true;
        }
        log.info(key + " is not set");
        return false;
    }

    private boolean verifyStringPropNotSet(String key) {
        if (this.containsKey(key) && !this.getString(key).isEmpty()) {
            log.info(key + " should not be set");
            return false;
        }
        return true;
    }

    public boolean hasRequiredClientProps() {
        boolean valid = true;
        valid &= this.verifyStringPropSet(CLIENT_APPLICATION_NAME_PROP);
        valid &= this.verifyStringPropSet(CLIENT_ACCUMULO_USER_PROP);
        valid &= this.verifyStringPropSet(CLIENT_ACCUMULO_PASSWORD_PROP);
        return valid &= this.verifyStringPropSet(CLIENT_ACCUMULO_INSTANCE_PROP);
    }

    public boolean hasRequiredAdminProps() {
        boolean valid = true;
        valid &= this.hasRequiredClientProps();
        return valid &= this.verifyStringPropSet(ADMIN_ACCUMULO_TABLE_PROP);
    }

    public boolean hasRequiredOracleProps() {
        boolean valid = true;
        return valid &= this.hasRequiredClientProps();
    }

    public boolean hasRequiredWorkerProps() {
        boolean valid = true;
        return valid &= this.hasRequiredClientProps();
    }

    public boolean hasRequiredMiniFluoProps() {
        boolean valid = true;
        if (this.getMiniStartAccumulo()) {
            valid &= this.verifyStringPropNotSet(CLIENT_ACCUMULO_USER_PROP);
            valid &= this.verifyStringPropNotSet(CLIENT_ACCUMULO_PASSWORD_PROP);
            valid &= this.verifyStringPropNotSet(CLIENT_ACCUMULO_INSTANCE_PROP);
            valid &= this.verifyStringPropNotSet(CLIENT_ACCUMULO_ZOOKEEPERS_PROP);
            if (!(valid &= this.verifyStringPropNotSet(CLIENT_ZOOKEEPER_CONNECT_PROP))) {
                log.error("Client properties should not be set in your configuration if MiniFluo is configured to start its own accumulo (indicated by fluo.mini.start.accumulo being set to true)");
            }
        } else {
            valid &= this.hasRequiredClientProps();
            valid &= this.hasRequiredAdminProps();
            valid &= this.hasRequiredOracleProps();
            valid &= this.hasRequiredWorkerProps();
        }
        return valid;
    }

    public SimpleConfiguration getClientConfiguration() {
        SimpleConfiguration clientConfig = new SimpleConfiguration();
        Iterator<String> iter = this.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.startsWith(CLIENT_PREFIX)) continue;
            clientConfig.setProperty(key, this.getRawString(key));
        }
        return clientConfig;
    }

    public static SimpleConfiguration getDefaultConfiguration() {
        SimpleConfiguration config = new SimpleConfiguration();
        FluoConfiguration.setDefaultConfiguration(config);
        return config;
    }

    public static void setDefaultConfiguration(SimpleConfiguration config) {
        config.setProperty(CLIENT_ZOOKEEPER_CONNECT_PROP, CLIENT_ZOOKEEPER_CONNECT_DEFAULT);
        config.setProperty(CLIENT_ZOOKEEPER_TIMEOUT_PROP, 30000);
        config.setProperty(CLIENT_ACCUMULO_ZOOKEEPERS_PROP, CLIENT_ACCUMULO_ZOOKEEPERS_DEFAULT);
        config.setProperty(WORKER_NUM_THREADS_PROP, 10);
        config.setProperty(TRANSACTION_ROLLBACK_TIME_PROP, 300000L);
        config.setProperty(LOADER_NUM_THREADS_PROP, 10);
        config.setProperty(LOADER_QUEUE_SIZE_PROP, 10);
        config.setProperty(MINI_START_ACCUMULO_PROP, true);
        config.setProperty(MINI_DATA_DIR_PROP, MINI_DATA_DIR_DEFAULT);
    }

    private FluoConfiguration setNonNegativeInt(String property, int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)(property + " must be non-negative"));
        this.setProperty(property, value);
        return this;
    }

    private int getNonNegativeInt(String property, int defaultValue) {
        int value = this.getInt(property, defaultValue);
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)(property + " must be non-negative"));
        return value;
    }

    private FluoConfiguration setPositiveInt(String property, int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)(property + " must be positive"));
        this.setProperty(property, value);
        return this;
    }

    private int getPositiveInt(String property, int defaultValue) {
        int value = this.getInt(property, defaultValue);
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)(property + " must be positive"));
        return value;
    }

    private FluoConfiguration setPositiveLong(String property, long value) {
        Preconditions.checkArgument((value > 0L ? 1 : 0) != 0, (Object)(property + " must be positive"));
        this.setProperty(property, value);
        return this;
    }

    private long getPositiveLong(String property, long defaultValue) {
        long value = this.getLong(property, defaultValue);
        Preconditions.checkArgument((value > 0L ? 1 : 0) != 0, (Object)(property + " must be positive"));
        return value;
    }

    private FluoConfiguration setNonEmptyString(String property, String value) {
        Objects.requireNonNull(value, property + " cannot be null");
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)(property + " cannot be empty"));
        this.setProperty(property, value);
        return this;
    }

    private String getNonEmptyString(String property, String defaultValue) {
        String value = this.getString(property, defaultValue);
        Objects.requireNonNull(value, property + " cannot be null");
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)(property + " cannot be empty"));
        return value;
    }

    private String getNonEmptyString(String property) {
        String value = this.getString(property);
        Objects.requireNonNull(value, property + " cannot be null");
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)(property + " cannot be empty"));
        return value;
    }

    private static String verifyNotNull(String property, String value) {
        Objects.requireNonNull(value, property + " cannot be null");
        return value;
    }
}

