/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.entrypoint;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpecFactory;
import org.apache.flink.runtime.resourcemanager.active.ActiveResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.active.ResourceManagerDriver;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.yarn.DefaultYarnNodeManagerClientFactory;
import org.apache.flink.yarn.DefaultYarnResourceManagerClientFactory;
import org.apache.flink.yarn.YarnResourceManagerDriver;
import org.apache.flink.yarn.YarnWorkerNode;
import org.apache.flink.yarn.configuration.YarnResourceManagerDriverConfiguration;
import org.apache.flink.yarn.entrypoint.YarnWorkerResourceSpecFactory;

public class YarnResourceManagerFactory
extends ActiveResourceManagerFactory<YarnWorkerNode> {
    private static final YarnResourceManagerFactory INSTANCE = new YarnResourceManagerFactory();

    private YarnResourceManagerFactory() {
    }

    public static YarnResourceManagerFactory getInstance() {
        return INSTANCE;
    }

    protected ResourceManagerDriver<YarnWorkerNode> createResourceManagerDriver(Configuration configuration, String webInterfaceUrl, String rpcAddress) {
        YarnResourceManagerDriverConfiguration yarnResourceManagerDriverConfiguration = new YarnResourceManagerDriverConfiguration(System.getenv(), rpcAddress, webInterfaceUrl);
        return new YarnResourceManagerDriver(configuration, yarnResourceManagerDriverConfiguration, DefaultYarnResourceManagerClientFactory.getInstance(), DefaultYarnNodeManagerClientFactory.getInstance());
    }

    protected ResourceManagerRuntimeServicesConfiguration createResourceManagerRuntimeServicesConfiguration(Configuration configuration) throws ConfigurationException {
        return ResourceManagerRuntimeServicesConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpecFactory)YarnWorkerResourceSpecFactory.INSTANCE);
    }

    public boolean supportMultiLeaderSession() {
        return false;
    }
}

