/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.configuration;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.yarn.api.ApplicationConstants;

public class YarnResourceManagerDriverConfiguration {
    @Nullable
    private final String webInterfaceUrl;
    private final String rpcAddress;
    private final String yarnFiles;
    private final String flinkClasspath;
    private final String clientShipFiles;
    private final String flinkDistJar;
    private final String currentDir;
    @Nullable
    private final String remoteKeytabPath;
    @Nullable
    private final String localKeytabPath;
    @Nullable
    private final String keytabPrinciple;
    @Nullable
    private final String krb5Path;
    @Nullable
    private final String yarnSiteXMLPath;

    public YarnResourceManagerDriverConfiguration(Map<String, String> env, String rpcAddress, @Nullable String webInterfaceUrl) {
        this.rpcAddress = (String)Preconditions.checkNotNull((Object)rpcAddress);
        this.webInterfaceUrl = webInterfaceUrl;
        this.yarnFiles = (String)Preconditions.checkNotNull((Object)env.get("_FLINK_YARN_FILES"));
        this.flinkClasspath = (String)Preconditions.checkNotNull((Object)env.get("_FLINK_CLASSPATH"));
        this.clientShipFiles = (String)Preconditions.checkNotNull((Object)env.get("_CLIENT_SHIP_FILES"));
        this.flinkDistJar = (String)Preconditions.checkNotNull((Object)env.get("_FLINK_DIST_JAR"));
        this.remoteKeytabPath = env.get("_REMOTE_KEYTAB_PATH");
        this.localKeytabPath = env.get("_LOCAL_KEYTAB_PATH");
        this.keytabPrinciple = env.get("_KEYTAB_PRINCIPAL");
        this.krb5Path = env.get("_KRB5_PATH");
        this.yarnSiteXMLPath = env.get("_YARN_SITE_XML_PATH");
        this.currentDir = (String)Preconditions.checkNotNull((Object)env.get(ApplicationConstants.Environment.PWD.key()));
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    @Nullable
    public String getWebInterfaceUrl() {
        return this.webInterfaceUrl;
    }

    public String getClientShipFiles() {
        return this.clientShipFiles;
    }

    public String getFlinkClasspath() {
        return this.flinkClasspath;
    }

    public String getFlinkDistJar() {
        return this.flinkDistJar;
    }

    @Nullable
    public String getKeytabPrinciple() {
        return this.keytabPrinciple;
    }

    @Nullable
    public String getKrb5Path() {
        return this.krb5Path;
    }

    @Nullable
    public String getLocalKeytabPath() {
        return this.localKeytabPath;
    }

    @Nullable
    public String getRemoteKeytabPath() {
        return this.remoteKeytabPath;
    }

    public String getYarnFiles() {
        return this.yarnFiles;
    }

    @Nullable
    public String getYarnSiteXMLPath() {
        return this.yarnSiteXMLPath;
    }

    public String getCurrentDir() {
        return this.currentDir;
    }
}

