/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.entrypoint;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpecFactory;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnWorkerResourceSpecFactory
extends WorkerResourceSpecFactory {
    public static final YarnWorkerResourceSpecFactory INSTANCE = new YarnWorkerResourceSpecFactory();
    private static final Logger LOG = LoggerFactory.getLogger(YarnWorkerResourceSpecFactory.class);

    private YarnWorkerResourceSpecFactory() {
    }

    public WorkerResourceSpec createDefaultWorkerResourceSpec(Configuration configuration) {
        return this.workerResourceSpecFromConfigAndCpu(configuration, YarnWorkerResourceSpecFactory.getDefaultCpus(configuration));
    }

    @VisibleForTesting
    static CPUResource getDefaultCpus(Configuration configuration) {
        int fallback = (Integer)configuration.get(YarnConfigOptions.VCORES);
        double cpuCoresDouble = TaskExecutorProcessUtils.getCpuCoresWithFallback((Configuration)configuration, (double)fallback).getValue().doubleValue();
        long cpuCoresLong = Math.max((long)Math.ceil(cpuCoresDouble), 1L);
        if ((double)cpuCoresLong != cpuCoresDouble) {
            LOG.info("The amount of cpu cores must be a positive integer on Yarn. Rounding {} up to the closest positive integer {}.", (Object)cpuCoresDouble, (Object)cpuCoresLong);
        }
        if (cpuCoresLong > Integer.MAX_VALUE) {
            throw new IllegalConfigurationException(String.format("The amount of cpu cores %d cannot exceed Integer.MAX_VALUE: %d", cpuCoresLong, Integer.MAX_VALUE));
        }
        return new CPUResource((double)cpuCoresLong);
    }
}

