/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.File;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.deployment.AbstractContainerizedClusterClientFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.DeploymentOptionsInternal;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.Utils;
import org.apache.flink.yarn.YarnClientYarnClusterInformationRetriever;
import org.apache.flink.yarn.YarnClusterDescriptor;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.flink.yarn.configuration.YarnDeploymentTarget;
import org.apache.flink.yarn.configuration.YarnLogConfigUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

@Internal
public class YarnClusterClientFactory
extends AbstractContainerizedClusterClientFactory<ApplicationId> {
    public boolean isCompatibleWith(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String deploymentTarget = (String)configuration.get(DeploymentOptions.TARGET);
        return YarnDeploymentTarget.isValidYarnTarget(deploymentTarget);
    }

    public YarnClusterDescriptor createClusterDescriptor(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String configurationDirectory = (String)configuration.get(DeploymentOptionsInternal.CONF_DIR);
        YarnLogConfigUtil.setLogConfigFileInConfig(configuration, configurationDirectory);
        return this.getClusterDescriptor(configuration);
    }

    @Nullable
    public ApplicationId getClusterId(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String clusterId = (String)configuration.get(YarnConfigOptions.APPLICATION_ID);
        return clusterId != null ? ApplicationId.fromString((String)clusterId) : null;
    }

    public Optional<String> getApplicationTargetName() {
        return Optional.of(YarnDeploymentTarget.APPLICATION.getName());
    }

    private YarnClusterDescriptor getClusterDescriptor(Configuration configuration) {
        YarnClient yarnClient = YarnClient.createYarnClient();
        YarnConfiguration yarnConfiguration = Utils.getYarnAndHadoopConfiguration(configuration);
        if (System.getenv().get("IN_TESTS") != null) {
            File f = new File(System.getenv("YARN_CONF_DIR"), "yarn-site.xml");
            Path yarnSitePath = new Path(f.getAbsolutePath());
            yarnConfiguration.addResource(yarnSitePath);
        }
        yarnClient.init((org.apache.hadoop.conf.Configuration)yarnConfiguration);
        yarnClient.start();
        return new YarnClusterDescriptor(configuration, yarnConfiguration, yarnClient, YarnClientYarnClusterInformationRetriever.create(yarnClient), false);
    }
}

