/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.client.JobInitializationException;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.test.util.SuccessException;
import org.apache.flink.util.ExceptionUtils;
import org.junit.Assert;

public class TestUtils {
    public static void tryExecute(StreamExecutionEnvironment see, String name) throws Exception {
        block5: {
            JobClient jobClient = null;
            try {
                StreamGraph graph = see.getStreamGraph();
                graph.setJobName(name);
                jobClient = see.executeAsync(graph);
                jobClient.getJobExecutionResult().get();
            }
            catch (Throwable root) {
                Optional successAsCause;
                if (jobClient != null) {
                    try {
                        jobClient.cancel().get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((successAsCause = ExceptionUtils.findThrowable((Throwable)root, SuccessException.class)).isPresent()) break block5;
                root.printStackTrace();
                Assert.fail((String)("Test failed: " + root.getMessage()));
            }
        }
    }

    public static void submitJobAndWaitForResult(ClusterClient<?> client, JobGraph jobGraph, ClassLoader classLoader) throws Exception {
        ((JobResult)((CompletableFuture)client.submitJob(jobGraph).thenCompose(arg_0 -> client.requestJobResult(arg_0))).get()).toJobExecutionResult(classLoader);
    }

    public static void waitUntilJobInitializationFinished(JobID id, MiniClusterWithClientResource miniCluster, ClassLoader userCodeClassloader) throws JobInitializationException {
        ClusterClient clusterClient = miniCluster.getClusterClient();
        ClientUtils.waitUntilJobInitializationFinished(() -> (JobStatus)clusterClient.getJobStatus(id).get(), () -> (JobResult)clusterClient.requestJobResult(id).get(), (ClassLoader)userCodeClassloader);
    }

    public static File getMostRecentCompletedCheckpoint(File checkpointDir) throws IOException {
        return Files.find(checkpointDir.toPath(), 2, TestUtils::isCompletedCheckpoint, new FileVisitOption[0]).max(Comparator.comparing(Path::toString)).map(Path::toFile).orElseThrow(() -> new IllegalStateException("Cannot generate checkpoint"));
    }

    private static boolean isCompletedCheckpoint(Path path, BasicFileAttributes attr) {
        return attr.isDirectory() && path.getFileName().toString().startsWith("chk-") && TestUtils.hasMetadata(path);
    }

    private static boolean hasMetadata(Path file) {
        try {
            return Files.find(file.toAbsolutePath(), 1, (path, attrs) -> path.getFileName().toString().equals("_metadata"), new FileVisitOption[0]).findAny().isPresent();
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
            return false;
        }
    }
}

